/*
 * Copyright 2013-2018 Amazon.com, Inc. or its affiliates. All Rights Reserved.
 * 
 * Licensed under the Apache License, Version 2.0 (the "License"). You may not use this file except in compliance with
 * the License. A copy of the License is located at
 * 
 * http://aws.amazon.com/apache2.0
 * 
 * or in the "license" file accompanying this file. This file is distributed on an "AS IS" BASIS, WITHOUT WARRANTIES OR
 * CONDITIONS OF ANY KIND, either express or implied. See the License for the specific language governing permissions
 * and limitations under the License.
 */

package software.amazon.awssdk.services.sns.transform;

import java.util.Map;
import javax.annotation.Generated;

import software.amazon.awssdk.core.exception.SdkClientException;
import software.amazon.awssdk.core.Request;
import software.amazon.awssdk.core.DefaultRequest;
import software.amazon.awssdk.core.http.HttpMethodName;
import software.amazon.awssdk.services.sns.model.*;
import software.amazon.awssdk.core.runtime.transform.Marshaller;
import software.amazon.awssdk.core.util.StringConversion;

/**
 * SubscribeRequest Marshaller
 */

@Generated("software.amazon.awssdk:aws-java-sdk-code-generator")
public class SubscribeRequestMarshaller implements Marshaller<Request<SubscribeRequest>, SubscribeRequest> {

    public Request<SubscribeRequest> marshall(SubscribeRequest subscribeRequest) {

        if (subscribeRequest == null) {
            throw SdkClientException.builder().message("Invalid argument passed to marshall(...)").build();
        }

        Request<SubscribeRequest> request = new DefaultRequest<SubscribeRequest>(subscribeRequest, "SnsClient");
        request.addParameter("Action", "Subscribe");
        request.addParameter("Version", "2010-03-31");
        request.setHttpMethod(HttpMethodName.POST);

        if (subscribeRequest.topicArn() != null) {
            request.addParameter("TopicArn", StringConversion.fromString(subscribeRequest.topicArn()));
        }

        if (subscribeRequest.protocol() != null) {
            request.addParameter("Protocol", StringConversion.fromString(subscribeRequest.protocol()));
        }

        if (subscribeRequest.endpoint() != null) {
            request.addParameter("Endpoint", StringConversion.fromString(subscribeRequest.endpoint()));
        }

        java.util.Map<String, String> attributes = subscribeRequest.attributes();

        if (attributes != null) {
            int attributesListIndex = 1;
            for (Map.Entry<String, String> entry : attributes.entrySet()) {
                if (entry.getKey() != null) {
                    request.addParameter("Attributes.entry." + attributesListIndex + ".key",
                            StringConversion.fromString(entry.getKey()));
                }
                if (entry.getValue() != null) {
                    request.addParameter("Attributes.entry." + attributesListIndex + ".value",
                            StringConversion.fromString(entry.getValue()));
                }
                attributesListIndex++;
            }
        }

        if (subscribeRequest.returnSubscriptionArn() != null) {
            request.addParameter("ReturnSubscriptionArn", StringConversion.fromBoolean(subscribeRequest.returnSubscriptionArn()));
        }

        return request;
    }

}
