/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.sns.transform;

import software.amazon.awssdk.core.DefaultRequest;
import software.amazon.awssdk.core.Request;
import software.amazon.awssdk.core.exception.SdkClientException;
import software.amazon.awssdk.core.http.HttpMethodName;
import software.amazon.awssdk.core.runtime.transform.Marshaller;
import software.amazon.awssdk.core.util.StringConversion;
import software.amazon.awssdk.services.sns.model.ConfirmSubscriptionRequest;

public class ConfirmSubscriptionRequestMarshaller
implements Marshaller<Request<ConfirmSubscriptionRequest>, ConfirmSubscriptionRequest> {
    public Request<ConfirmSubscriptionRequest> marshall(ConfirmSubscriptionRequest confirmSubscriptionRequest) {
        if (confirmSubscriptionRequest == null) {
            throw SdkClientException.builder().message("Invalid argument passed to marshall(...)").build();
        }
        DefaultRequest request = new DefaultRequest((Object)confirmSubscriptionRequest, "SnsClient");
        request.addParameter("Action", "ConfirmSubscription");
        request.addParameter("Version", "2010-03-31");
        request.setHttpMethod(HttpMethodName.POST);
        if (confirmSubscriptionRequest.topicArn() != null) {
            request.addParameter("TopicArn", StringConversion.fromString((String)confirmSubscriptionRequest.topicArn()));
        }
        if (confirmSubscriptionRequest.token() != null) {
            request.addParameter("Token", StringConversion.fromString((String)confirmSubscriptionRequest.token()));
        }
        if (confirmSubscriptionRequest.authenticateOnUnsubscribe() != null) {
            request.addParameter("AuthenticateOnUnsubscribe", StringConversion.fromString((String)confirmSubscriptionRequest.authenticateOnUnsubscribe()));
        }
        return request;
    }
}

