/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.sns.transform;

import software.amazon.awssdk.core.DefaultRequest;
import software.amazon.awssdk.core.Request;
import software.amazon.awssdk.core.exception.SdkClientException;
import software.amazon.awssdk.core.http.HttpMethodName;
import software.amazon.awssdk.core.runtime.transform.Marshaller;
import software.amazon.awssdk.core.util.StringConversion;
import software.amazon.awssdk.services.sns.model.DeletePlatformApplicationRequest;

public class DeletePlatformApplicationRequestMarshaller
implements Marshaller<Request<DeletePlatformApplicationRequest>, DeletePlatformApplicationRequest> {
    public Request<DeletePlatformApplicationRequest> marshall(DeletePlatformApplicationRequest deletePlatformApplicationRequest) {
        if (deletePlatformApplicationRequest == null) {
            throw SdkClientException.builder().message("Invalid argument passed to marshall(...)").build();
        }
        DefaultRequest request = new DefaultRequest((Object)deletePlatformApplicationRequest, "SnsClient");
        request.addParameter("Action", "DeletePlatformApplication");
        request.addParameter("Version", "2010-03-31");
        request.setHttpMethod(HttpMethodName.POST);
        if (deletePlatformApplicationRequest.platformApplicationArn() != null) {
            request.addParameter("PlatformApplicationArn", StringConversion.fromString((String)deletePlatformApplicationRequest.platformApplicationArn()));
        }
        return request;
    }
}

