/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.sns.transform;

import java.util.Map;
import software.amazon.awssdk.core.DefaultRequest;
import software.amazon.awssdk.core.Request;
import software.amazon.awssdk.core.exception.SdkClientException;
import software.amazon.awssdk.core.http.HttpMethodName;
import software.amazon.awssdk.core.runtime.transform.Marshaller;
import software.amazon.awssdk.core.util.StringConversion;
import software.amazon.awssdk.services.sns.model.SubscribeRequest;

public class SubscribeRequestMarshaller
implements Marshaller<Request<SubscribeRequest>, SubscribeRequest> {
    public Request<SubscribeRequest> marshall(SubscribeRequest subscribeRequest) {
        Map<String, String> attributes;
        if (subscribeRequest == null) {
            throw SdkClientException.builder().message("Invalid argument passed to marshall(...)").build();
        }
        DefaultRequest request = new DefaultRequest((Object)subscribeRequest, "SnsClient");
        request.addParameter("Action", "Subscribe");
        request.addParameter("Version", "2010-03-31");
        request.setHttpMethod(HttpMethodName.POST);
        if (subscribeRequest.topicArn() != null) {
            request.addParameter("TopicArn", StringConversion.fromString((String)subscribeRequest.topicArn()));
        }
        if (subscribeRequest.protocol() != null) {
            request.addParameter("Protocol", StringConversion.fromString((String)subscribeRequest.protocol()));
        }
        if (subscribeRequest.endpoint() != null) {
            request.addParameter("Endpoint", StringConversion.fromString((String)subscribeRequest.endpoint()));
        }
        if ((attributes = subscribeRequest.attributes()) != null) {
            int attributesListIndex = 1;
            for (Map.Entry<String, String> entry : attributes.entrySet()) {
                if (entry.getKey() != null) {
                    request.addParameter("Attributes.entry." + attributesListIndex + ".key", StringConversion.fromString((String)entry.getKey()));
                }
                if (entry.getValue() != null) {
                    request.addParameter("Attributes.entry." + attributesListIndex + ".value", StringConversion.fromString((String)entry.getValue()));
                }
                ++attributesListIndex;
            }
        }
        if (subscribeRequest.returnSubscriptionArn() != null) {
            request.addParameter("ReturnSubscriptionArn", StringConversion.fromBoolean((Boolean)subscribeRequest.returnSubscriptionArn()));
        }
        return request;
    }
}

