/*
 * Copyright 2013-2018 Amazon.com, Inc. or its affiliates. All Rights Reserved.
 * 
 * Licensed under the Apache License, Version 2.0 (the "License"). You may not use this file except in compliance with
 * the License. A copy of the License is located at
 * 
 * http://aws.amazon.com/apache2.0
 * 
 * or in the "license" file accompanying this file. This file is distributed on an "AS IS" BASIS, WITHOUT WARRANTIES OR
 * CONDITIONS OF ANY KIND, either express or implied. See the License for the specific language governing permissions
 * and limitations under the License.
 */

package software.amazon.awssdk.services.sns.model;

import java.util.Arrays;
import java.util.Collections;
import java.util.List;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Consumer;
import java.util.function.Function;
import software.amazon.awssdk.annotations.Generated;
import software.amazon.awssdk.awscore.AwsRequestOverrideConfiguration;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

/**
 * <p>
 * Input for SetTopicAttributes action.
 * </p>
 */
@Generated("software.amazon.awssdk:codegen")
public final class SetTopicAttributesRequest extends SnsRequest implements
        ToCopyableBuilder<SetTopicAttributesRequest.Builder, SetTopicAttributesRequest> {
    private static final SdkField<String> TOPIC_ARN_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .getter(getter(SetTopicAttributesRequest::topicArn)).setter(setter(Builder::topicArn))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("TopicArn").build()).build();

    private static final SdkField<String> ATTRIBUTE_NAME_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .getter(getter(SetTopicAttributesRequest::attributeName)).setter(setter(Builder::attributeName))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("AttributeName").build()).build();

    private static final SdkField<String> ATTRIBUTE_VALUE_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .getter(getter(SetTopicAttributesRequest::attributeValue)).setter(setter(Builder::attributeValue))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("AttributeValue").build()).build();

    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(TOPIC_ARN_FIELD,
            ATTRIBUTE_NAME_FIELD, ATTRIBUTE_VALUE_FIELD));

    private final String topicArn;

    private final String attributeName;

    private final String attributeValue;

    private SetTopicAttributesRequest(BuilderImpl builder) {
        super(builder);
        this.topicArn = builder.topicArn;
        this.attributeName = builder.attributeName;
        this.attributeValue = builder.attributeValue;
    }

    /**
     * <p>
     * The ARN of the topic to modify.
     * </p>
     * 
     * @return The ARN of the topic to modify.
     */
    public String topicArn() {
        return topicArn;
    }

    /**
     * <p>
     * The name of the attribute you want to set. Only a subset of the topic's attributes are mutable.
     * </p>
     * <p>
     * Valid values: <code>Policy</code> | <code>DisplayName</code> | <code>DeliveryPolicy</code>
     * </p>
     * 
     * @return The name of the attribute you want to set. Only a subset of the topic's attributes are mutable.</p>
     *         <p>
     *         Valid values: <code>Policy</code> | <code>DisplayName</code> | <code>DeliveryPolicy</code>
     */
    public String attributeName() {
        return attributeName;
    }

    /**
     * <p>
     * The new value for the attribute.
     * </p>
     * 
     * @return The new value for the attribute.
     */
    public String attributeValue() {
        return attributeValue;
    }

    @Override
    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    @Override
    public int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + Objects.hashCode(topicArn());
        hashCode = 31 * hashCode + Objects.hashCode(attributeName());
        hashCode = 31 * hashCode + Objects.hashCode(attributeValue());
        return hashCode;
    }

    @Override
    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof SetTopicAttributesRequest)) {
            return false;
        }
        SetTopicAttributesRequest other = (SetTopicAttributesRequest) obj;
        return Objects.equals(topicArn(), other.topicArn()) && Objects.equals(attributeName(), other.attributeName())
                && Objects.equals(attributeValue(), other.attributeValue());
    }

    @Override
    public String toString() {
        return ToString.builder("SetTopicAttributesRequest").add("TopicArn", topicArn()).add("AttributeName", attributeName())
                .add("AttributeValue", attributeValue()).build();
    }

    public <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
        case "TopicArn":
            return Optional.ofNullable(clazz.cast(topicArn()));
        case "AttributeName":
            return Optional.ofNullable(clazz.cast(attributeName()));
        case "AttributeValue":
            return Optional.ofNullable(clazz.cast(attributeValue()));
        default:
            return Optional.empty();
        }
    }

    @Override
    public List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    private static <T> Function<Object, T> getter(Function<SetTopicAttributesRequest, T> g) {
        return obj -> g.apply((SetTopicAttributesRequest) obj);
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder) obj, val);
    }

    public interface Builder extends SnsRequest.Builder, SdkPojo, CopyableBuilder<Builder, SetTopicAttributesRequest> {
        /**
         * <p>
         * The ARN of the topic to modify.
         * </p>
         * 
         * @param topicArn
         *        The ARN of the topic to modify.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder topicArn(String topicArn);

        /**
         * <p>
         * The name of the attribute you want to set. Only a subset of the topic's attributes are mutable.
         * </p>
         * <p>
         * Valid values: <code>Policy</code> | <code>DisplayName</code> | <code>DeliveryPolicy</code>
         * </p>
         * 
         * @param attributeName
         *        The name of the attribute you want to set. Only a subset of the topic's attributes are mutable.</p>
         *        <p>
         *        Valid values: <code>Policy</code> | <code>DisplayName</code> | <code>DeliveryPolicy</code>
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder attributeName(String attributeName);

        /**
         * <p>
         * The new value for the attribute.
         * </p>
         * 
         * @param attributeValue
         *        The new value for the attribute.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder attributeValue(String attributeValue);

        @Override
        Builder overrideConfiguration(AwsRequestOverrideConfiguration overrideConfiguration);

        @Override
        Builder overrideConfiguration(Consumer<AwsRequestOverrideConfiguration.Builder> builderConsumer);
    }

    static final class BuilderImpl extends SnsRequest.BuilderImpl implements Builder {
        private String topicArn;

        private String attributeName;

        private String attributeValue;

        private BuilderImpl() {
        }

        private BuilderImpl(SetTopicAttributesRequest model) {
            super(model);
            topicArn(model.topicArn);
            attributeName(model.attributeName);
            attributeValue(model.attributeValue);
        }

        public final String getTopicArn() {
            return topicArn;
        }

        @Override
        public final Builder topicArn(String topicArn) {
            this.topicArn = topicArn;
            return this;
        }

        public final void setTopicArn(String topicArn) {
            this.topicArn = topicArn;
        }

        public final String getAttributeName() {
            return attributeName;
        }

        @Override
        public final Builder attributeName(String attributeName) {
            this.attributeName = attributeName;
            return this;
        }

        public final void setAttributeName(String attributeName) {
            this.attributeName = attributeName;
        }

        public final String getAttributeValue() {
            return attributeValue;
        }

        @Override
        public final Builder attributeValue(String attributeValue) {
            this.attributeValue = attributeValue;
            return this;
        }

        public final void setAttributeValue(String attributeValue) {
            this.attributeValue = attributeValue;
        }

        @Override
        public Builder overrideConfiguration(AwsRequestOverrideConfiguration overrideConfiguration) {
            super.overrideConfiguration(overrideConfiguration);
            return this;
        }

        @Override
        public Builder overrideConfiguration(Consumer<AwsRequestOverrideConfiguration.Builder> builderConsumer) {
            super.overrideConfiguration(builderConsumer);
            return this;
        }

        @Override
        public SetTopicAttributesRequest build() {
            return new SetTopicAttributesRequest(this);
        }

        @Override
        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }
    }
}
