/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.sns.model;

import java.util.Arrays;
import java.util.Collection;
import java.util.List;
import software.amazon.awssdk.AmazonWebServiceResult;
import software.amazon.awssdk.ResponseMetadata;
import software.amazon.awssdk.services.sns.model.PhoneNumberListCopier;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

public class ListPhoneNumbersOptedOutResponse
extends AmazonWebServiceResult<ResponseMetadata>
implements ToCopyableBuilder<Builder, ListPhoneNumbersOptedOutResponse> {
    private final List<String> phoneNumbers;
    private final String nextToken;

    private ListPhoneNumbersOptedOutResponse(BuilderImpl builder) {
        this.phoneNumbers = builder.phoneNumbers;
        this.nextToken = builder.nextToken;
    }

    public List<String> phoneNumbers() {
        return this.phoneNumbers;
    }

    public String nextToken() {
        return this.nextToken;
    }

    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    public int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + (this.phoneNumbers() == null ? 0 : this.phoneNumbers().hashCode());
        hashCode = 31 * hashCode + (this.nextToken() == null ? 0 : this.nextToken().hashCode());
        return hashCode;
    }

    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof ListPhoneNumbersOptedOutResponse)) {
            return false;
        }
        ListPhoneNumbersOptedOutResponse other = (ListPhoneNumbersOptedOutResponse)((Object)obj);
        if (other.phoneNumbers() == null ^ this.phoneNumbers() == null) {
            return false;
        }
        if (other.phoneNumbers() != null && !other.phoneNumbers().equals(this.phoneNumbers())) {
            return false;
        }
        if (other.nextToken() == null ^ this.nextToken() == null) {
            return false;
        }
        return other.nextToken() == null || other.nextToken().equals(this.nextToken());
    }

    public String toString() {
        StringBuilder sb = new StringBuilder();
        sb.append("{");
        if (this.phoneNumbers() != null) {
            sb.append("PhoneNumbers: ").append(this.phoneNumbers()).append(",");
        }
        if (this.nextToken() != null) {
            sb.append("NextToken: ").append(this.nextToken()).append(",");
        }
        sb.append("}");
        return sb.toString();
    }

    private static final class BuilderImpl
    implements Builder {
        private List<String> phoneNumbers;
        private String nextToken;

        private BuilderImpl() {
        }

        private BuilderImpl(ListPhoneNumbersOptedOutResponse model) {
            this.setPhoneNumbers(model.phoneNumbers);
            this.setNextToken(model.nextToken);
        }

        public final Collection<String> getPhoneNumbers() {
            return this.phoneNumbers;
        }

        @Override
        public final Builder phoneNumbers(Collection<String> phoneNumbers) {
            this.phoneNumbers = PhoneNumberListCopier.copy(phoneNumbers);
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder phoneNumbers(String ... phoneNumbers) {
            this.phoneNumbers(Arrays.asList(phoneNumbers));
            return this;
        }

        public final void setPhoneNumbers(Collection<String> phoneNumbers) {
            this.phoneNumbers = PhoneNumberListCopier.copy(phoneNumbers);
        }

        @SafeVarargs
        public final void setPhoneNumbers(String ... phoneNumbers) {
            this.phoneNumbers(Arrays.asList(phoneNumbers));
        }

        public final String getNextToken() {
            return this.nextToken;
        }

        @Override
        public final Builder nextToken(String nextToken) {
            this.nextToken = nextToken;
            return this;
        }

        public final void setNextToken(String nextToken) {
            this.nextToken = nextToken;
        }

        public ListPhoneNumbersOptedOutResponse build() {
            return new ListPhoneNumbersOptedOutResponse(this);
        }
    }

    public static interface Builder
    extends CopyableBuilder<Builder, ListPhoneNumbersOptedOutResponse> {
        public Builder phoneNumbers(Collection<String> var1);

        public Builder phoneNumbers(String ... var1);

        public Builder nextToken(String var1);
    }
}

