/*
 * Copyright 2012-2017 Amazon.com, Inc. or its affiliates. All Rights Reserved.
 * 
 * Licensed under the Apache License, Version 2.0 (the "License"). You may not use this file except in compliance with
 * the License. A copy of the License is located at
 * 
 * http://aws.amazon.com/apache2.0
 * 
 * or in the "license" file accompanying this file. This file is distributed on an "AS IS" BASIS, WITHOUT WARRANTIES OR
 * CONDITIONS OF ANY KIND, either express or implied. See the License for the specific language governing permissions
 * and limitations under the License.
 */

package software.amazon.awssdk.services.sns.model;

import java.util.Arrays;
import java.util.Collection;
import java.util.List;
import javax.annotation.Generated;
import software.amazon.awssdk.AmazonWebServiceRequest;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

/**
 * <p>
 * The input for the <code>GetSMSAttributes</code> request.
 * </p>
 */
@Generated("software.amazon.awssdk:codegen")
public class GetSMSAttributesRequest extends AmazonWebServiceRequest implements
        ToCopyableBuilder<GetSMSAttributesRequest.Builder, GetSMSAttributesRequest> {
    private final List<String> attributes;

    private GetSMSAttributesRequest(BuilderImpl builder) {
        this.attributes = builder.attributes;
    }

    /**
     * <p>
     * A list of the individual attribute names, such as <code>MonthlySpendLimit</code>, for which you want values.
     * </p>
     * <p>
     * For all attribute names, see <a
     * href="http://docs.aws.amazon.com/sns/latest/api/API_SetSMSAttributes.html">SetSMSAttributes</a>.
     * </p>
     * <p>
     * If you don't use this parameter, Amazon SNS returns all SMS attributes.
     * </p>
     * <p>
     * Attempts to modify the collection returned by this method will result in an UnsupportedOperationException.
     * </p>
     * 
     * @return A list of the individual attribute names, such as <code>MonthlySpendLimit</code>, for which you want
     *         values.</p>
     *         <p>
     *         For all attribute names, see <a
     *         href="http://docs.aws.amazon.com/sns/latest/api/API_SetSMSAttributes.html">SetSMSAttributes</a>.
     *         </p>
     *         <p>
     *         If you don't use this parameter, Amazon SNS returns all SMS attributes.
     */
    public List<String> attributes() {
        return attributes;
    }

    @Override
    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    @Override
    public int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + ((attributes() == null) ? 0 : attributes().hashCode());
        return hashCode;
    }

    @Override
    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof GetSMSAttributesRequest)) {
            return false;
        }
        GetSMSAttributesRequest other = (GetSMSAttributesRequest) obj;
        if (other.attributes() == null ^ this.attributes() == null) {
            return false;
        }
        if (other.attributes() != null && !other.attributes().equals(this.attributes())) {
            return false;
        }
        return true;
    }

    @Override
    public String toString() {
        StringBuilder sb = new StringBuilder();
        sb.append("{");
        if (attributes() != null) {
            sb.append("Attributes: ").append(attributes()).append(",");
        }
        sb.append("}");
        return sb.toString();
    }

    public interface Builder extends CopyableBuilder<Builder, GetSMSAttributesRequest> {
        /**
         * <p>
         * A list of the individual attribute names, such as <code>MonthlySpendLimit</code>, for which you want values.
         * </p>
         * <p>
         * For all attribute names, see <a
         * href="http://docs.aws.amazon.com/sns/latest/api/API_SetSMSAttributes.html">SetSMSAttributes</a>.
         * </p>
         * <p>
         * If you don't use this parameter, Amazon SNS returns all SMS attributes.
         * </p>
         * 
         * @param attributes
         *        A list of the individual attribute names, such as <code>MonthlySpendLimit</code>, for which you want
         *        values.</p>
         *        <p>
         *        For all attribute names, see <a
         *        href="http://docs.aws.amazon.com/sns/latest/api/API_SetSMSAttributes.html">SetSMSAttributes</a>.
         *        </p>
         *        <p>
         *        If you don't use this parameter, Amazon SNS returns all SMS attributes.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder attributes(Collection<String> attributes);

        /**
         * <p>
         * A list of the individual attribute names, such as <code>MonthlySpendLimit</code>, for which you want values.
         * </p>
         * <p>
         * For all attribute names, see <a
         * href="http://docs.aws.amazon.com/sns/latest/api/API_SetSMSAttributes.html">SetSMSAttributes</a>.
         * </p>
         * <p>
         * If you don't use this parameter, Amazon SNS returns all SMS attributes.
         * </p>
         * 
         * @param attributes
         *        A list of the individual attribute names, such as <code>MonthlySpendLimit</code>, for which you want
         *        values.</p>
         *        <p>
         *        For all attribute names, see <a
         *        href="http://docs.aws.amazon.com/sns/latest/api/API_SetSMSAttributes.html">SetSMSAttributes</a>.
         *        </p>
         *        <p>
         *        If you don't use this parameter, Amazon SNS returns all SMS attributes.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder attributes(String... attributes);
    }

    private static final class BuilderImpl implements Builder {
        private List<String> attributes;

        private BuilderImpl() {
        }

        private BuilderImpl(GetSMSAttributesRequest model) {
            setAttributes(model.attributes);
        }

        public final Collection<String> getAttributes() {
            return attributes;
        }

        @Override
        public final Builder attributes(Collection<String> attributes) {
            this.attributes = ListStringCopier.copy(attributes);
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder attributes(String... attributes) {
            attributes(Arrays.asList(attributes));
            return this;
        }

        public final void setAttributes(Collection<String> attributes) {
            this.attributes = ListStringCopier.copy(attributes);
        }

        @Override
        public GetSMSAttributesRequest build() {
            return new GetSMSAttributesRequest(this);
        }
    }
}
