/*
 * Copyright 2012-2017 Amazon.com, Inc. or its affiliates. All Rights Reserved.
 * 
 * Licensed under the Apache License, Version 2.0 (the "License"). You may not use this file except in compliance with
 * the License. A copy of the License is located at
 * 
 * http://aws.amazon.com/apache2.0
 * 
 * or in the "license" file accompanying this file. This file is distributed on an "AS IS" BASIS, WITHOUT WARRANTIES OR
 * CONDITIONS OF ANY KIND, either express or implied. See the License for the specific language governing permissions
 * and limitations under the License.
 */

package software.amazon.awssdk.services.sns.model;

import javax.annotation.Generated;
import software.amazon.awssdk.AmazonWebServiceRequest;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

/**
 * <p>
 * Input for ListSubscriptionsByTopic action.
 * </p>
 */
@Generated("software.amazon.awssdk:codegen")
public class ListSubscriptionsByTopicRequest extends AmazonWebServiceRequest implements
        ToCopyableBuilder<ListSubscriptionsByTopicRequest.Builder, ListSubscriptionsByTopicRequest> {
    private final String topicArn;

    private final String nextToken;

    private ListSubscriptionsByTopicRequest(BuilderImpl builder) {
        this.topicArn = builder.topicArn;
        this.nextToken = builder.nextToken;
    }

    /**
     * <p>
     * The ARN of the topic for which you wish to find subscriptions.
     * </p>
     * 
     * @return The ARN of the topic for which you wish to find subscriptions.
     */
    public String topicArn() {
        return topicArn;
    }

    /**
     * <p>
     * Token returned by the previous <code>ListSubscriptionsByTopic</code> request.
     * </p>
     * 
     * @return Token returned by the previous <code>ListSubscriptionsByTopic</code> request.
     */
    public String nextToken() {
        return nextToken;
    }

    @Override
    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    @Override
    public int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + ((topicArn() == null) ? 0 : topicArn().hashCode());
        hashCode = 31 * hashCode + ((nextToken() == null) ? 0 : nextToken().hashCode());
        return hashCode;
    }

    @Override
    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof ListSubscriptionsByTopicRequest)) {
            return false;
        }
        ListSubscriptionsByTopicRequest other = (ListSubscriptionsByTopicRequest) obj;
        if (other.topicArn() == null ^ this.topicArn() == null) {
            return false;
        }
        if (other.topicArn() != null && !other.topicArn().equals(this.topicArn())) {
            return false;
        }
        if (other.nextToken() == null ^ this.nextToken() == null) {
            return false;
        }
        if (other.nextToken() != null && !other.nextToken().equals(this.nextToken())) {
            return false;
        }
        return true;
    }

    @Override
    public String toString() {
        StringBuilder sb = new StringBuilder();
        sb.append("{");
        if (topicArn() != null) {
            sb.append("TopicArn: ").append(topicArn()).append(",");
        }
        if (nextToken() != null) {
            sb.append("NextToken: ").append(nextToken()).append(",");
        }
        sb.append("}");
        return sb.toString();
    }

    public interface Builder extends CopyableBuilder<Builder, ListSubscriptionsByTopicRequest> {
        /**
         * <p>
         * The ARN of the topic for which you wish to find subscriptions.
         * </p>
         * 
         * @param topicArn
         *        The ARN of the topic for which you wish to find subscriptions.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder topicArn(String topicArn);

        /**
         * <p>
         * Token returned by the previous <code>ListSubscriptionsByTopic</code> request.
         * </p>
         * 
         * @param nextToken
         *        Token returned by the previous <code>ListSubscriptionsByTopic</code> request.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder nextToken(String nextToken);
    }

    private static final class BuilderImpl implements Builder {
        private String topicArn;

        private String nextToken;

        private BuilderImpl() {
        }

        private BuilderImpl(ListSubscriptionsByTopicRequest model) {
            setTopicArn(model.topicArn);
            setNextToken(model.nextToken);
        }

        public final String getTopicArn() {
            return topicArn;
        }

        @Override
        public final Builder topicArn(String topicArn) {
            this.topicArn = topicArn;
            return this;
        }

        public final void setTopicArn(String topicArn) {
            this.topicArn = topicArn;
        }

        public final String getNextToken() {
            return nextToken;
        }

        @Override
        public final Builder nextToken(String nextToken) {
            this.nextToken = nextToken;
            return this;
        }

        public final void setNextToken(String nextToken) {
            this.nextToken = nextToken;
        }

        @Override
        public ListSubscriptionsByTopicRequest build() {
            return new ListSubscriptionsByTopicRequest(this);
        }
    }
}
