/*
 * Copyright 2012-2017 Amazon.com, Inc. or its affiliates. All Rights Reserved.
 * 
 * Licensed under the Apache License, Version 2.0 (the "License"). You may not use this file except in compliance with
 * the License. A copy of the License is located at
 * 
 * http://aws.amazon.com/apache2.0
 * 
 * or in the "license" file accompanying this file. This file is distributed on an "AS IS" BASIS, WITHOUT WARRANTIES OR
 * CONDITIONS OF ANY KIND, either express or implied. See the License for the specific language governing permissions
 * and limitations under the License.
 */

package software.amazon.awssdk.services.sns.model;

import java.util.Arrays;
import java.util.Collection;
import java.util.List;
import javax.annotation.Generated;
import software.amazon.awssdk.AmazonWebServiceResult;
import software.amazon.awssdk.ResponseMetadata;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

/**
 * <p>
 * Response for ListTopics action.
 * </p>
 */
@Generated("software.amazon.awssdk:codegen")
public class ListTopicsResponse extends AmazonWebServiceResult<ResponseMetadata> implements
        ToCopyableBuilder<ListTopicsResponse.Builder, ListTopicsResponse> {
    private final List<Topic> topics;

    private final String nextToken;

    private ListTopicsResponse(BuilderImpl builder) {
        this.topics = builder.topics;
        this.nextToken = builder.nextToken;
    }

    /**
     * <p>
     * A list of topic ARNs.
     * </p>
     * <p>
     * Attempts to modify the collection returned by this method will result in an UnsupportedOperationException.
     * </p>
     * 
     * @return A list of topic ARNs.
     */
    public List<Topic> topics() {
        return topics;
    }

    /**
     * <p>
     * Token to pass along to the next <code>ListTopics</code> request. This element is returned if there are additional
     * topics to retrieve.
     * </p>
     * 
     * @return Token to pass along to the next <code>ListTopics</code> request. This element is returned if there are
     *         additional topics to retrieve.
     */
    public String nextToken() {
        return nextToken;
    }

    @Override
    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    @Override
    public int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + ((topics() == null) ? 0 : topics().hashCode());
        hashCode = 31 * hashCode + ((nextToken() == null) ? 0 : nextToken().hashCode());
        return hashCode;
    }

    @Override
    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof ListTopicsResponse)) {
            return false;
        }
        ListTopicsResponse other = (ListTopicsResponse) obj;
        if (other.topics() == null ^ this.topics() == null) {
            return false;
        }
        if (other.topics() != null && !other.topics().equals(this.topics())) {
            return false;
        }
        if (other.nextToken() == null ^ this.nextToken() == null) {
            return false;
        }
        if (other.nextToken() != null && !other.nextToken().equals(this.nextToken())) {
            return false;
        }
        return true;
    }

    @Override
    public String toString() {
        StringBuilder sb = new StringBuilder();
        sb.append("{");
        if (topics() != null) {
            sb.append("Topics: ").append(topics()).append(",");
        }
        if (nextToken() != null) {
            sb.append("NextToken: ").append(nextToken()).append(",");
        }
        sb.append("}");
        return sb.toString();
    }

    public interface Builder extends CopyableBuilder<Builder, ListTopicsResponse> {
        /**
         * <p>
         * A list of topic ARNs.
         * </p>
         * 
         * @param topics
         *        A list of topic ARNs.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder topics(Collection<Topic> topics);

        /**
         * <p>
         * A list of topic ARNs.
         * </p>
         * 
         * @param topics
         *        A list of topic ARNs.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder topics(Topic... topics);

        /**
         * <p>
         * Token to pass along to the next <code>ListTopics</code> request. This element is returned if there are
         * additional topics to retrieve.
         * </p>
         * 
         * @param nextToken
         *        Token to pass along to the next <code>ListTopics</code> request. This element is returned if there are
         *        additional topics to retrieve.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder nextToken(String nextToken);
    }

    private static final class BuilderImpl implements Builder {
        private List<Topic> topics;

        private String nextToken;

        private BuilderImpl() {
        }

        private BuilderImpl(ListTopicsResponse model) {
            setTopics(model.topics);
            setNextToken(model.nextToken);
        }

        public final Collection<Topic> getTopics() {
            return topics;
        }

        @Override
        public final Builder topics(Collection<Topic> topics) {
            this.topics = TopicsListCopier.copy(topics);
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder topics(Topic... topics) {
            topics(Arrays.asList(topics));
            return this;
        }

        public final void setTopics(Collection<Topic> topics) {
            this.topics = TopicsListCopier.copy(topics);
        }

        public final String getNextToken() {
            return nextToken;
        }

        @Override
        public final Builder nextToken(String nextToken) {
            this.nextToken = nextToken;
            return this;
        }

        public final void setNextToken(String nextToken) {
            this.nextToken = nextToken;
        }

        @Override
        public ListTopicsResponse build() {
            return new ListTopicsResponse(this);
        }
    }
}
