/*
 * Copyright 2012-2017 Amazon.com, Inc. or its affiliates. All Rights Reserved.
 * 
 * Licensed under the Apache License, Version 2.0 (the "License"). You may not use this file except in compliance with
 * the License. A copy of the License is located at
 * 
 * http://aws.amazon.com/apache2.0
 * 
 * or in the "license" file accompanying this file. This file is distributed on an "AS IS" BASIS, WITHOUT WARRANTIES OR
 * CONDITIONS OF ANY KIND, either express or implied. See the License for the specific language governing permissions
 * and limitations under the License.
 */

package software.amazon.awssdk.services.sns.transform;

import java.util.List;

import javax.annotation.Generated;

import software.amazon.awssdk.SdkClientException;
import software.amazon.awssdk.Request;
import software.amazon.awssdk.DefaultRequest;
import software.amazon.awssdk.http.HttpMethodName;
import software.amazon.awssdk.services.sns.model.*;
import software.amazon.awssdk.runtime.transform.Marshaller;
import software.amazon.awssdk.util.StringUtils;

/**
 * AddPermissionRequest Marshaller
 */

@Generated("software.amazon.awssdk:aws-java-sdk-code-generator")
public class AddPermissionRequestMarshaller implements Marshaller<Request<AddPermissionRequest>, AddPermissionRequest> {

    public Request<AddPermissionRequest> marshall(AddPermissionRequest addPermissionRequest) {

        if (addPermissionRequest == null) {
            throw new SdkClientException("Invalid argument passed to marshall(...)");
        }

        Request<AddPermissionRequest> request = new DefaultRequest<AddPermissionRequest>(addPermissionRequest, "SNSClient");
        request.addParameter("Action", "AddPermission");
        request.addParameter("Version", "2010-03-31");
        request.setHttpMethod(HttpMethodName.POST);

        if (addPermissionRequest.topicArn() != null) {
            request.addParameter("TopicArn", StringUtils.fromString(addPermissionRequest.topicArn()));
        }

        if (addPermissionRequest.label() != null) {
            request.addParameter("Label", StringUtils.fromString(addPermissionRequest.label()));
        }

        java.util.List<String> aWSAccountIdsList = addPermissionRequest.awsAccountIds();

        if (aWSAccountIdsList != null) {
            if (!aWSAccountIdsList.isEmpty()) {
                int aWSAccountIdsListIndex = 1;

                for (String aWSAccountIdsListValue : aWSAccountIdsList) {
                    if (aWSAccountIdsListValue != null) {
                        request.addParameter("AWSAccountId.member." + aWSAccountIdsListIndex,
                                StringUtils.fromString(aWSAccountIdsListValue));
                    }
                    aWSAccountIdsListIndex++;
                }
            } else {
                request.addParameter("AWSAccountId", "");
            }
        }

        java.util.List<String> actionNamesList = addPermissionRequest.actionNames();

        if (actionNamesList != null) {
            if (!actionNamesList.isEmpty()) {
                int actionNamesListIndex = 1;

                for (String actionNamesListValue : actionNamesList) {
                    if (actionNamesListValue != null) {
                        request.addParameter("ActionName.member." + actionNamesListIndex,
                                StringUtils.fromString(actionNamesListValue));
                    }
                    actionNamesListIndex++;
                }
            } else {
                request.addParameter("ActionName", "");
            }
        }

        return request;
    }

}
