/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.sns.model;

import java.util.Arrays;
import java.util.Collection;
import java.util.List;
import software.amazon.awssdk.AmazonWebServiceResult;
import software.amazon.awssdk.ResponseMetadata;
import software.amazon.awssdk.services.sns.model.Topic;
import software.amazon.awssdk.services.sns.model.TopicsListCopier;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

public class ListTopicsResponse
extends AmazonWebServiceResult<ResponseMetadata>
implements ToCopyableBuilder<Builder, ListTopicsResponse> {
    private final List<Topic> topics;
    private final String nextToken;

    private ListTopicsResponse(BuilderImpl builder) {
        this.topics = builder.topics;
        this.nextToken = builder.nextToken;
    }

    public List<Topic> topics() {
        return this.topics;
    }

    public String nextToken() {
        return this.nextToken;
    }

    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    public int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + (this.topics() == null ? 0 : this.topics().hashCode());
        hashCode = 31 * hashCode + (this.nextToken() == null ? 0 : this.nextToken().hashCode());
        return hashCode;
    }

    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof ListTopicsResponse)) {
            return false;
        }
        ListTopicsResponse other = (ListTopicsResponse)((Object)obj);
        if (other.topics() == null ^ this.topics() == null) {
            return false;
        }
        if (other.topics() != null && !other.topics().equals(this.topics())) {
            return false;
        }
        if (other.nextToken() == null ^ this.nextToken() == null) {
            return false;
        }
        return other.nextToken() == null || other.nextToken().equals(this.nextToken());
    }

    public String toString() {
        StringBuilder sb = new StringBuilder();
        sb.append("{");
        if (this.topics() != null) {
            sb.append("Topics: ").append(this.topics()).append(",");
        }
        if (this.nextToken() != null) {
            sb.append("NextToken: ").append(this.nextToken()).append(",");
        }
        sb.append("}");
        return sb.toString();
    }

    private static final class BuilderImpl
    implements Builder {
        private List<Topic> topics;
        private String nextToken;

        private BuilderImpl() {
        }

        private BuilderImpl(ListTopicsResponse model) {
            this.setTopics(model.topics);
            this.setNextToken(model.nextToken);
        }

        public final Collection<Topic> getTopics() {
            return this.topics;
        }

        @Override
        public final Builder topics(Collection<Topic> topics) {
            this.topics = TopicsListCopier.copy(topics);
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder topics(Topic ... topics) {
            this.topics(Arrays.asList(topics));
            return this;
        }

        public final void setTopics(Collection<Topic> topics) {
            this.topics = TopicsListCopier.copy(topics);
        }

        public final String getNextToken() {
            return this.nextToken;
        }

        @Override
        public final Builder nextToken(String nextToken) {
            this.nextToken = nextToken;
            return this;
        }

        public final void setNextToken(String nextToken) {
            this.nextToken = nextToken;
        }

        public ListTopicsResponse build() {
            return new ListTopicsResponse(this);
        }
    }

    public static interface Builder
    extends CopyableBuilder<Builder, ListTopicsResponse> {
        public Builder topics(Collection<Topic> var1);

        public Builder topics(Topic ... var1);

        public Builder nextToken(String var1);
    }
}

