/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.sns.transform;

import java.util.ArrayList;
import javax.xml.stream.events.XMLEvent;
import software.amazon.awssdk.runtime.transform.SimpleTypeStaxUnmarshallers;
import software.amazon.awssdk.runtime.transform.StaxUnmarshallerContext;
import software.amazon.awssdk.runtime.transform.Unmarshaller;
import software.amazon.awssdk.services.sns.model.ListTopicsResponse;
import software.amazon.awssdk.services.sns.model.Topic;
import software.amazon.awssdk.services.sns.transform.TopicUnmarshaller;

public class ListTopicsResponseUnmarshaller
implements Unmarshaller<ListTopicsResponse, StaxUnmarshallerContext> {
    private static final ListTopicsResponseUnmarshaller INSTANCE = new ListTopicsResponseUnmarshaller();

    public ListTopicsResponse unmarshall(StaxUnmarshallerContext context) throws Exception {
        ListTopicsResponse.Builder listTopicsResponse;
        block6: {
            listTopicsResponse = ListTopicsResponse.builder();
            int originalDepth = context.getCurrentDepth();
            int targetDepth = originalDepth + 1;
            if (context.isStartOfDocument()) {
                targetDepth += 2;
            }
            ArrayList<Topic> topics = null;
            while (true) {
                XMLEvent xmlEvent;
                if ((xmlEvent = context.nextEvent()).isEndDocument()) {
                    listTopicsResponse.topics(topics);
                    break block6;
                }
                if (xmlEvent.isAttribute() || xmlEvent.isStartElement()) {
                    if (context.testExpression("Topics", targetDepth)) {
                        topics = new ArrayList<Topic>();
                        continue;
                    }
                    if (context.testExpression("Topics/member", targetDepth)) {
                        topics.add(TopicUnmarshaller.getInstance().unmarshall(context));
                        continue;
                    }
                    if (!context.testExpression("NextToken", targetDepth)) continue;
                    listTopicsResponse.nextToken(SimpleTypeStaxUnmarshallers.StringUnmarshaller.getInstance().unmarshall(context));
                    continue;
                }
                if (xmlEvent.isEndElement() && context.getCurrentDepth() < originalDepth) break;
            }
            listTopicsResponse.topics(topics);
        }
        return (ListTopicsResponse)((Object)listTopicsResponse.build());
    }

    public static ListTopicsResponseUnmarshaller getInstance() {
        return INSTANCE;
    }
}

