/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.sns.transform;

import javax.xml.stream.events.XMLEvent;
import software.amazon.awssdk.runtime.transform.SimpleTypeStaxUnmarshallers;
import software.amazon.awssdk.runtime.transform.StaxUnmarshallerContext;
import software.amazon.awssdk.runtime.transform.Unmarshaller;
import software.amazon.awssdk.services.sns.model.MessageAttributeValue;

public class MessageAttributeValueUnmarshaller
implements Unmarshaller<MessageAttributeValue, StaxUnmarshallerContext> {
    private static final MessageAttributeValueUnmarshaller INSTANCE = new MessageAttributeValueUnmarshaller();

    public MessageAttributeValue unmarshall(StaxUnmarshallerContext context) throws Exception {
        XMLEvent xmlEvent;
        MessageAttributeValue.Builder messageAttributeValue = MessageAttributeValue.builder();
        int originalDepth = context.getCurrentDepth();
        int targetDepth = originalDepth + 1;
        if (context.isStartOfDocument()) {
            ++targetDepth;
        }
        while (!(xmlEvent = context.nextEvent()).isEndDocument()) {
            if (xmlEvent.isAttribute() || xmlEvent.isStartElement()) {
                if (context.testExpression("DataType", targetDepth)) {
                    messageAttributeValue.dataType(SimpleTypeStaxUnmarshallers.StringUnmarshaller.getInstance().unmarshall(context));
                    continue;
                }
                if (context.testExpression("StringValue", targetDepth)) {
                    messageAttributeValue.stringValue(SimpleTypeStaxUnmarshallers.StringUnmarshaller.getInstance().unmarshall(context));
                    continue;
                }
                if (!context.testExpression("BinaryValue", targetDepth)) continue;
                messageAttributeValue.binaryValue(SimpleTypeStaxUnmarshallers.ByteBufferUnmarshaller.getInstance().unmarshall(context));
                continue;
            }
            if (!xmlEvent.isEndElement() || context.getCurrentDepth() >= originalDepth) continue;
            break;
        }
        return (MessageAttributeValue)messageAttributeValue.build();
    }

    public static MessageAttributeValueUnmarshaller getInstance() {
        return INSTANCE;
    }
}

