/*
 * Copyright 2012-2017 Amazon.com, Inc. or its affiliates. All Rights Reserved.
 * 
 * Licensed under the Apache License, Version 2.0 (the "License"). You may not use this file except in compliance with
 * the License. A copy of the License is located at
 * 
 * http://aws.amazon.com/apache2.0
 * 
 * or in the "license" file accompanying this file. This file is distributed on an "AS IS" BASIS, WITHOUT WARRANTIES OR
 * CONDITIONS OF ANY KIND, either express or implied. See the License for the specific language governing permissions
 * and limitations under the License.
 */

package software.amazon.awssdk.services.sns.model;

import java.util.Map;
import javax.annotation.Generated;
import software.amazon.awssdk.AmazonWebServiceRequest;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

/**
 * <p>
 * Input for CreatePlatformEndpoint action.
 * </p>
 */
@Generated("software.amazon.awssdk:codegen")
public class CreatePlatformEndpointRequest extends AmazonWebServiceRequest implements
        ToCopyableBuilder<CreatePlatformEndpointRequest.Builder, CreatePlatformEndpointRequest> {
    private final String platformApplicationArn;

    private final String token;

    private final String customUserData;

    private final Map<String, String> attributes;

    private CreatePlatformEndpointRequest(BuilderImpl builder) {
        this.platformApplicationArn = builder.platformApplicationArn;
        this.token = builder.token;
        this.customUserData = builder.customUserData;
        this.attributes = builder.attributes;
    }

    /**
     * <p>
     * PlatformApplicationArn returned from CreatePlatformApplication is used to create a an endpoint.
     * </p>
     * 
     * @return PlatformApplicationArn returned from CreatePlatformApplication is used to create a an endpoint.
     */
    public String platformApplicationArn() {
        return platformApplicationArn;
    }

    /**
     * <p>
     * Unique identifier created by the notification service for an app on a device. The specific name for Token will
     * vary, depending on which notification service is being used. For example, when using APNS as the notification
     * service, you need the device token. Alternatively, when using GCM or ADM, the device token equivalent is called
     * the registration ID.
     * </p>
     * 
     * @return Unique identifier created by the notification service for an app on a device. The specific name for Token
     *         will vary, depending on which notification service is being used. For example, when using APNS as the
     *         notification service, you need the device token. Alternatively, when using GCM or ADM, the device token
     *         equivalent is called the registration ID.
     */
    public String token() {
        return token;
    }

    /**
     * <p>
     * Arbitrary user data to associate with the endpoint. Amazon SNS does not use this data. The data must be in UTF-8
     * format and less than 2KB.
     * </p>
     * 
     * @return Arbitrary user data to associate with the endpoint. Amazon SNS does not use this data. The data must be
     *         in UTF-8 format and less than 2KB.
     */
    public String customUserData() {
        return customUserData;
    }

    /**
     * <p>
     * For a list of attributes, see <a
     * href="http://docs.aws.amazon.com/sns/latest/api/API_SetEndpointAttributes.html">SetEndpointAttributes</a>.
     * </p>
     * <p>
     * Attempts to modify the collection returned by this method will result in an UnsupportedOperationException.
     * </p>
     * 
     * @return For a list of attributes, see <a
     *         href="http://docs.aws.amazon.com/sns/latest/api/API_SetEndpointAttributes.html"
     *         >SetEndpointAttributes</a>.
     */
    public Map<String, String> attributes() {
        return attributes;
    }

    @Override
    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    @Override
    public int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + ((platformApplicationArn() == null) ? 0 : platformApplicationArn().hashCode());
        hashCode = 31 * hashCode + ((token() == null) ? 0 : token().hashCode());
        hashCode = 31 * hashCode + ((customUserData() == null) ? 0 : customUserData().hashCode());
        hashCode = 31 * hashCode + ((attributes() == null) ? 0 : attributes().hashCode());
        return hashCode;
    }

    @Override
    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof CreatePlatformEndpointRequest)) {
            return false;
        }
        CreatePlatformEndpointRequest other = (CreatePlatformEndpointRequest) obj;
        if (other.platformApplicationArn() == null ^ this.platformApplicationArn() == null) {
            return false;
        }
        if (other.platformApplicationArn() != null && !other.platformApplicationArn().equals(this.platformApplicationArn())) {
            return false;
        }
        if (other.token() == null ^ this.token() == null) {
            return false;
        }
        if (other.token() != null && !other.token().equals(this.token())) {
            return false;
        }
        if (other.customUserData() == null ^ this.customUserData() == null) {
            return false;
        }
        if (other.customUserData() != null && !other.customUserData().equals(this.customUserData())) {
            return false;
        }
        if (other.attributes() == null ^ this.attributes() == null) {
            return false;
        }
        if (other.attributes() != null && !other.attributes().equals(this.attributes())) {
            return false;
        }
        return true;
    }

    @Override
    public String toString() {
        StringBuilder sb = new StringBuilder();
        sb.append("{");
        if (platformApplicationArn() != null) {
            sb.append("PlatformApplicationArn: ").append(platformApplicationArn()).append(",");
        }
        if (token() != null) {
            sb.append("Token: ").append(token()).append(",");
        }
        if (customUserData() != null) {
            sb.append("CustomUserData: ").append(customUserData()).append(",");
        }
        if (attributes() != null) {
            sb.append("Attributes: ").append(attributes()).append(",");
        }
        sb.append("}");
        return sb.toString();
    }

    public interface Builder extends CopyableBuilder<Builder, CreatePlatformEndpointRequest> {
        /**
         * <p>
         * PlatformApplicationArn returned from CreatePlatformApplication is used to create a an endpoint.
         * </p>
         * 
         * @param platformApplicationArn
         *        PlatformApplicationArn returned from CreatePlatformApplication is used to create a an endpoint.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder platformApplicationArn(String platformApplicationArn);

        /**
         * <p>
         * Unique identifier created by the notification service for an app on a device. The specific name for Token
         * will vary, depending on which notification service is being used. For example, when using APNS as the
         * notification service, you need the device token. Alternatively, when using GCM or ADM, the device token
         * equivalent is called the registration ID.
         * </p>
         * 
         * @param token
         *        Unique identifier created by the notification service for an app on a device. The specific name for
         *        Token will vary, depending on which notification service is being used. For example, when using APNS
         *        as the notification service, you need the device token. Alternatively, when using GCM or ADM, the
         *        device token equivalent is called the registration ID.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder token(String token);

        /**
         * <p>
         * Arbitrary user data to associate with the endpoint. Amazon SNS does not use this data. The data must be in
         * UTF-8 format and less than 2KB.
         * </p>
         * 
         * @param customUserData
         *        Arbitrary user data to associate with the endpoint. Amazon SNS does not use this data. The data must
         *        be in UTF-8 format and less than 2KB.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder customUserData(String customUserData);

        /**
         * <p>
         * For a list of attributes, see <a
         * href="http://docs.aws.amazon.com/sns/latest/api/API_SetEndpointAttributes.html">SetEndpointAttributes</a>.
         * </p>
         * 
         * @param attributes
         *        For a list of attributes, see <a
         *        href="http://docs.aws.amazon.com/sns/latest/api/API_SetEndpointAttributes.html"
         *        >SetEndpointAttributes</a>.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder attributes(Map<String, String> attributes);
    }

    private static final class BuilderImpl implements Builder {
        private String platformApplicationArn;

        private String token;

        private String customUserData;

        private Map<String, String> attributes;

        private BuilderImpl() {
        }

        private BuilderImpl(CreatePlatformEndpointRequest model) {
            setPlatformApplicationArn(model.platformApplicationArn);
            setToken(model.token);
            setCustomUserData(model.customUserData);
            setAttributes(model.attributes);
        }

        public final String getPlatformApplicationArn() {
            return platformApplicationArn;
        }

        @Override
        public final Builder platformApplicationArn(String platformApplicationArn) {
            this.platformApplicationArn = platformApplicationArn;
            return this;
        }

        public final void setPlatformApplicationArn(String platformApplicationArn) {
            this.platformApplicationArn = platformApplicationArn;
        }

        public final String getToken() {
            return token;
        }

        @Override
        public final Builder token(String token) {
            this.token = token;
            return this;
        }

        public final void setToken(String token) {
            this.token = token;
        }

        public final String getCustomUserData() {
            return customUserData;
        }

        @Override
        public final Builder customUserData(String customUserData) {
            this.customUserData = customUserData;
            return this;
        }

        public final void setCustomUserData(String customUserData) {
            this.customUserData = customUserData;
        }

        public final Map<String, String> getAttributes() {
            return attributes;
        }

        @Override
        public final Builder attributes(Map<String, String> attributes) {
            this.attributes = MapStringToStringCopier.copy(attributes);
            return this;
        }

        public final void setAttributes(Map<String, String> attributes) {
            this.attributes = MapStringToStringCopier.copy(attributes);
        }

        @Override
        public CreatePlatformEndpointRequest build() {
            return new CreatePlatformEndpointRequest(this);
        }
    }
}
