/*
 * Copyright 2012-2017 Amazon.com, Inc. or its affiliates. All Rights Reserved.
 * 
 * Licensed under the Apache License, Version 2.0 (the "License"). You may not use this file except in compliance with
 * the License. A copy of the License is located at
 * 
 * http://aws.amazon.com/apache2.0
 * 
 * or in the "license" file accompanying this file. This file is distributed on an "AS IS" BASIS, WITHOUT WARRANTIES OR
 * CONDITIONS OF ANY KIND, either express or implied. See the License for the specific language governing permissions
 * and limitations under the License.
 */

package software.amazon.awssdk.services.sns.model;

import javax.annotation.Generated;
import software.amazon.awssdk.AmazonWebServiceResult;
import software.amazon.awssdk.ResponseMetadata;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

/**
 * <p>
 * Response for Publish action.
 * </p>
 */
@Generated("software.amazon.awssdk:codegen")
public class PublishResponse extends AmazonWebServiceResult<ResponseMetadata> implements
        ToCopyableBuilder<PublishResponse.Builder, PublishResponse> {
    private final String messageId;

    private PublishResponse(BuilderImpl builder) {
        this.messageId = builder.messageId;
    }

    /**
     * <p>
     * Unique identifier assigned to the published message.
     * </p>
     * <p>
     * Length Constraint: Maximum 100 characters
     * </p>
     * 
     * @return Unique identifier assigned to the published message.</p>
     *         <p>
     *         Length Constraint: Maximum 100 characters
     */
    public String messageId() {
        return messageId;
    }

    @Override
    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    @Override
    public int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + ((messageId() == null) ? 0 : messageId().hashCode());
        return hashCode;
    }

    @Override
    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof PublishResponse)) {
            return false;
        }
        PublishResponse other = (PublishResponse) obj;
        if (other.messageId() == null ^ this.messageId() == null) {
            return false;
        }
        if (other.messageId() != null && !other.messageId().equals(this.messageId())) {
            return false;
        }
        return true;
    }

    @Override
    public String toString() {
        StringBuilder sb = new StringBuilder();
        sb.append("{");
        if (messageId() != null) {
            sb.append("MessageId: ").append(messageId()).append(",");
        }
        sb.append("}");
        return sb.toString();
    }

    public interface Builder extends CopyableBuilder<Builder, PublishResponse> {
        /**
         * <p>
         * Unique identifier assigned to the published message.
         * </p>
         * <p>
         * Length Constraint: Maximum 100 characters
         * </p>
         * 
         * @param messageId
         *        Unique identifier assigned to the published message.</p>
         *        <p>
         *        Length Constraint: Maximum 100 characters
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder messageId(String messageId);
    }

    private static final class BuilderImpl implements Builder {
        private String messageId;

        private BuilderImpl() {
        }

        private BuilderImpl(PublishResponse model) {
            setMessageId(model.messageId);
        }

        public final String getMessageId() {
            return messageId;
        }

        @Override
        public final Builder messageId(String messageId) {
            this.messageId = messageId;
            return this;
        }

        public final void setMessageId(String messageId) {
            this.messageId = messageId;
        }

        @Override
        public PublishResponse build() {
            return new PublishResponse(this);
        }
    }
}
