/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.auth.policy.conditions;

import software.amazon.awssdk.auth.policy.Condition;
import software.amazon.awssdk.auth.policy.conditions.StringCondition;

public class SnsConditionFactory {
    public static final String ENDPOINT_CONDITION_KEY = "sns:Endpoint";
    public static final String PROTOCOL_CONDITION_KEY = "sns:Protocol";

    private SnsConditionFactory() {
    }

    public static Condition newEndpointCondition(String endpointPattern) {
        return new StringCondition(StringCondition.StringComparisonType.StringLike, ENDPOINT_CONDITION_KEY, endpointPattern);
    }

    public static Condition newProtocolCondition(String protocol) {
        return new StringCondition(StringCondition.StringComparisonType.StringEquals, PROTOCOL_CONDITION_KEY, protocol);
    }
}

