/*
 * Copyright 2012-2017 Amazon.com, Inc. or its affiliates. All Rights Reserved.
 * 
 * Licensed under the Apache License, Version 2.0 (the "License"). You may not use this file except in compliance with
 * the License. A copy of the License is located at
 * 
 * http://aws.amazon.com/apache2.0
 * 
 * or in the "license" file accompanying this file. This file is distributed on an "AS IS" BASIS, WITHOUT WARRANTIES OR
 * CONDITIONS OF ANY KIND, either express or implied. See the License for the specific language governing permissions
 * and limitations under the License.
 */

package software.amazon.awssdk.services.sns.model;

import java.util.Optional;
import javax.annotation.Generated;
import software.amazon.awssdk.core.AmazonWebServiceResult;
import software.amazon.awssdk.core.ResponseMetadata;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

/**
 * <p>
 * The response from the <code>CheckIfPhoneNumberIsOptedOut</code> action.
 * </p>
 */
@Generated("software.amazon.awssdk:codegen")
public class CheckIfPhoneNumberIsOptedOutResponse extends AmazonWebServiceResult<ResponseMetadata> implements
        ToCopyableBuilder<CheckIfPhoneNumberIsOptedOutResponse.Builder, CheckIfPhoneNumberIsOptedOutResponse> {
    private final Boolean isOptedOut;

    private CheckIfPhoneNumberIsOptedOutResponse(BuilderImpl builder) {
        this.isOptedOut = builder.isOptedOut;
    }

    /**
     * <p>
     * Indicates whether the phone number is opted out:
     * </p>
     * <ul>
     * <li>
     * <p>
     * <code>true</code> – The phone number is opted out, meaning you cannot publish SMS messages to it.
     * </p>
     * </li>
     * <li>
     * <p>
     * <code>false</code> – The phone number is opted in, meaning you can publish SMS messages to it.
     * </p>
     * </li>
     * </ul>
     * 
     * @return Indicates whether the phone number is opted out:</p>
     *         <ul>
     *         <li>
     *         <p>
     *         <code>true</code> – The phone number is opted out, meaning you cannot publish SMS messages to it.
     *         </p>
     *         </li>
     *         <li>
     *         <p>
     *         <code>false</code> – The phone number is opted in, meaning you can publish SMS messages to it.
     *         </p>
     *         </li>
     */
    public Boolean isOptedOut() {
        return isOptedOut;
    }

    @Override
    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    @Override
    public int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + ((isOptedOut() == null) ? 0 : isOptedOut().hashCode());
        return hashCode;
    }

    @Override
    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof CheckIfPhoneNumberIsOptedOutResponse)) {
            return false;
        }
        CheckIfPhoneNumberIsOptedOutResponse other = (CheckIfPhoneNumberIsOptedOutResponse) obj;
        if (other.isOptedOut() == null ^ this.isOptedOut() == null) {
            return false;
        }
        if (other.isOptedOut() != null && !other.isOptedOut().equals(this.isOptedOut())) {
            return false;
        }
        return true;
    }

    @Override
    public String toString() {
        StringBuilder sb = new StringBuilder("{");
        if (isOptedOut() != null) {
            sb.append("IsOptedOut: ").append(isOptedOut()).append(",");
        }
        if (sb.length() > 1) {
            sb.setLength(sb.length() - 1);
        }
        sb.append("}");
        return sb.toString();
    }

    public <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
        case "isOptedOut":
            return Optional.of(clazz.cast(isOptedOut()));
        default:
            return Optional.empty();
        }
    }

    public interface Builder extends CopyableBuilder<Builder, CheckIfPhoneNumberIsOptedOutResponse> {
        /**
         * <p>
         * Indicates whether the phone number is opted out:
         * </p>
         * <ul>
         * <li>
         * <p>
         * <code>true</code> – The phone number is opted out, meaning you cannot publish SMS messages to it.
         * </p>
         * </li>
         * <li>
         * <p>
         * <code>false</code> – The phone number is opted in, meaning you can publish SMS messages to it.
         * </p>
         * </li>
         * </ul>
         * 
         * @param isOptedOut
         *        Indicates whether the phone number is opted out:</p>
         *        <ul>
         *        <li>
         *        <p>
         *        <code>true</code> – The phone number is opted out, meaning you cannot publish SMS messages to it.
         *        </p>
         *        </li>
         *        <li>
         *        <p>
         *        <code>false</code> – The phone number is opted in, meaning you can publish SMS messages to it.
         *        </p>
         *        </li>
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder isOptedOut(Boolean isOptedOut);
    }

    static final class BuilderImpl implements Builder {
        private Boolean isOptedOut;

        private BuilderImpl() {
        }

        private BuilderImpl(CheckIfPhoneNumberIsOptedOutResponse model) {
            isOptedOut(model.isOptedOut);
        }

        public final Boolean getIsOptedOut() {
            return isOptedOut;
        }

        @Override
        public final Builder isOptedOut(Boolean isOptedOut) {
            this.isOptedOut = isOptedOut;
            return this;
        }

        public final void setIsOptedOut(Boolean isOptedOut) {
            this.isOptedOut = isOptedOut;
        }

        @Override
        public CheckIfPhoneNumberIsOptedOutResponse build() {
            return new CheckIfPhoneNumberIsOptedOutResponse(this);
        }
    }
}
