/*
 * Copyright 2012-2017 Amazon.com, Inc. or its affiliates. All Rights Reserved.
 * 
 * Licensed under the Apache License, Version 2.0 (the "License"). You may not use this file except in compliance with
 * the License. A copy of the License is located at
 * 
 * http://aws.amazon.com/apache2.0
 * 
 * or in the "license" file accompanying this file. This file is distributed on an "AS IS" BASIS, WITHOUT WARRANTIES OR
 * CONDITIONS OF ANY KIND, either express or implied. See the License for the specific language governing permissions
 * and limitations under the License.
 */

package software.amazon.awssdk.services.sns.model;

import java.util.Arrays;
import java.util.Collection;
import java.util.List;
import java.util.Optional;
import java.util.stream.Collectors;
import javax.annotation.Generated;
import software.amazon.awssdk.core.AmazonWebServiceResult;
import software.amazon.awssdk.core.ResponseMetadata;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

/**
 * <p>
 * Response for ListPlatformApplications action.
 * </p>
 */
@Generated("software.amazon.awssdk:codegen")
public class ListPlatformApplicationsResponse extends AmazonWebServiceResult<ResponseMetadata> implements
        ToCopyableBuilder<ListPlatformApplicationsResponse.Builder, ListPlatformApplicationsResponse> {
    private final List<PlatformApplication> platformApplications;

    private final String nextToken;

    private ListPlatformApplicationsResponse(BuilderImpl builder) {
        this.platformApplications = builder.platformApplications;
        this.nextToken = builder.nextToken;
    }

    /**
     * <p>
     * Platform applications returned when calling ListPlatformApplications action.
     * </p>
     * <p>
     * Attempts to modify the collection returned by this method will result in an UnsupportedOperationException.
     * </p>
     * 
     * @return Platform applications returned when calling ListPlatformApplications action.
     */
    public List<PlatformApplication> platformApplications() {
        return platformApplications;
    }

    /**
     * <p>
     * NextToken string is returned when calling ListPlatformApplications action if additional records are available
     * after the first page results.
     * </p>
     * 
     * @return NextToken string is returned when calling ListPlatformApplications action if additional records are
     *         available after the first page results.
     */
    public String nextToken() {
        return nextToken;
    }

    @Override
    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    @Override
    public int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + ((platformApplications() == null) ? 0 : platformApplications().hashCode());
        hashCode = 31 * hashCode + ((nextToken() == null) ? 0 : nextToken().hashCode());
        return hashCode;
    }

    @Override
    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof ListPlatformApplicationsResponse)) {
            return false;
        }
        ListPlatformApplicationsResponse other = (ListPlatformApplicationsResponse) obj;
        if (other.platformApplications() == null ^ this.platformApplications() == null) {
            return false;
        }
        if (other.platformApplications() != null && !other.platformApplications().equals(this.platformApplications())) {
            return false;
        }
        if (other.nextToken() == null ^ this.nextToken() == null) {
            return false;
        }
        if (other.nextToken() != null && !other.nextToken().equals(this.nextToken())) {
            return false;
        }
        return true;
    }

    @Override
    public String toString() {
        StringBuilder sb = new StringBuilder("{");
        if (platformApplications() != null) {
            sb.append("PlatformApplications: ").append(platformApplications()).append(",");
        }
        if (nextToken() != null) {
            sb.append("NextToken: ").append(nextToken()).append(",");
        }
        if (sb.length() > 1) {
            sb.setLength(sb.length() - 1);
        }
        sb.append("}");
        return sb.toString();
    }

    public <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
        case "PlatformApplications":
            return Optional.of(clazz.cast(platformApplications()));
        case "NextToken":
            return Optional.of(clazz.cast(nextToken()));
        default:
            return Optional.empty();
        }
    }

    public interface Builder extends CopyableBuilder<Builder, ListPlatformApplicationsResponse> {
        /**
         * <p>
         * Platform applications returned when calling ListPlatformApplications action.
         * </p>
         * 
         * @param platformApplications
         *        Platform applications returned when calling ListPlatformApplications action.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder platformApplications(Collection<PlatformApplication> platformApplications);

        /**
         * <p>
         * Platform applications returned when calling ListPlatformApplications action.
         * </p>
         * 
         * @param platformApplications
         *        Platform applications returned when calling ListPlatformApplications action.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder platformApplications(PlatformApplication... platformApplications);

        /**
         * <p>
         * NextToken string is returned when calling ListPlatformApplications action if additional records are available
         * after the first page results.
         * </p>
         * 
         * @param nextToken
         *        NextToken string is returned when calling ListPlatformApplications action if additional records are
         *        available after the first page results.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder nextToken(String nextToken);
    }

    static final class BuilderImpl implements Builder {
        private List<PlatformApplication> platformApplications;

        private String nextToken;

        private BuilderImpl() {
        }

        private BuilderImpl(ListPlatformApplicationsResponse model) {
            platformApplications(model.platformApplications);
            nextToken(model.nextToken);
        }

        public final Collection<PlatformApplication.Builder> getPlatformApplications() {
            return platformApplications != null ? platformApplications.stream().map(PlatformApplication::toBuilder)
                    .collect(Collectors.toList()) : null;
        }

        @Override
        public final Builder platformApplications(Collection<PlatformApplication> platformApplications) {
            this.platformApplications = ListOfPlatformApplicationsCopier.copy(platformApplications);
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder platformApplications(PlatformApplication... platformApplications) {
            platformApplications(Arrays.asList(platformApplications));
            return this;
        }

        public final void setPlatformApplications(Collection<PlatformApplication.BuilderImpl> platformApplications) {
            this.platformApplications = ListOfPlatformApplicationsCopier.copyFromBuilder(platformApplications);
        }

        public final String getNextToken() {
            return nextToken;
        }

        @Override
        public final Builder nextToken(String nextToken) {
            this.nextToken = nextToken;
            return this;
        }

        public final void setNextToken(String nextToken) {
            this.nextToken = nextToken;
        }

        @Override
        public ListPlatformApplicationsResponse build() {
            return new ListPlatformApplicationsResponse(this);
        }
    }
}
