/*
 * Copyright 2012-2017 Amazon.com, Inc. or its affiliates. All Rights Reserved.
 * 
 * Licensed under the Apache License, Version 2.0 (the "License"). You may not use this file except in compliance with
 * the License. A copy of the License is located at
 * 
 * http://aws.amazon.com/apache2.0
 * 
 * or in the "license" file accompanying this file. This file is distributed on an "AS IS" BASIS, WITHOUT WARRANTIES OR
 * CONDITIONS OF ANY KIND, either express or implied. See the License for the specific language governing permissions
 * and limitations under the License.
 */

package software.amazon.awssdk.services.sns.model;

import java.util.Optional;
import javax.annotation.Generated;
import software.amazon.awssdk.core.AmazonWebServiceRequest;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

/**
 * <p>
 * Input for SetTopicAttributes action.
 * </p>
 */
@Generated("software.amazon.awssdk:codegen")
public class SetTopicAttributesRequest extends AmazonWebServiceRequest implements
        ToCopyableBuilder<SetTopicAttributesRequest.Builder, SetTopicAttributesRequest> {
    private final String topicArn;

    private final String attributeName;

    private final String attributeValue;

    private SetTopicAttributesRequest(BuilderImpl builder) {
        this.topicArn = builder.topicArn;
        this.attributeName = builder.attributeName;
        this.attributeValue = builder.attributeValue;
    }

    /**
     * <p>
     * The ARN of the topic to modify.
     * </p>
     * 
     * @return The ARN of the topic to modify.
     */
    public String topicArn() {
        return topicArn;
    }

    /**
     * <p>
     * The name of the attribute you want to set. Only a subset of the topic's attributes are mutable.
     * </p>
     * <p>
     * Valid values: <code>Policy</code> | <code>DisplayName</code> | <code>DeliveryPolicy</code>
     * </p>
     * 
     * @return The name of the attribute you want to set. Only a subset of the topic's attributes are mutable.</p>
     *         <p>
     *         Valid values: <code>Policy</code> | <code>DisplayName</code> | <code>DeliveryPolicy</code>
     */
    public String attributeName() {
        return attributeName;
    }

    /**
     * <p>
     * The new value for the attribute.
     * </p>
     * 
     * @return The new value for the attribute.
     */
    public String attributeValue() {
        return attributeValue;
    }

    @Override
    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    @Override
    public int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + ((topicArn() == null) ? 0 : topicArn().hashCode());
        hashCode = 31 * hashCode + ((attributeName() == null) ? 0 : attributeName().hashCode());
        hashCode = 31 * hashCode + ((attributeValue() == null) ? 0 : attributeValue().hashCode());
        return hashCode;
    }

    @Override
    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof SetTopicAttributesRequest)) {
            return false;
        }
        SetTopicAttributesRequest other = (SetTopicAttributesRequest) obj;
        if (other.topicArn() == null ^ this.topicArn() == null) {
            return false;
        }
        if (other.topicArn() != null && !other.topicArn().equals(this.topicArn())) {
            return false;
        }
        if (other.attributeName() == null ^ this.attributeName() == null) {
            return false;
        }
        if (other.attributeName() != null && !other.attributeName().equals(this.attributeName())) {
            return false;
        }
        if (other.attributeValue() == null ^ this.attributeValue() == null) {
            return false;
        }
        if (other.attributeValue() != null && !other.attributeValue().equals(this.attributeValue())) {
            return false;
        }
        return true;
    }

    @Override
    public String toString() {
        StringBuilder sb = new StringBuilder("{");
        if (topicArn() != null) {
            sb.append("TopicArn: ").append(topicArn()).append(",");
        }
        if (attributeName() != null) {
            sb.append("AttributeName: ").append(attributeName()).append(",");
        }
        if (attributeValue() != null) {
            sb.append("AttributeValue: ").append(attributeValue()).append(",");
        }
        if (sb.length() > 1) {
            sb.setLength(sb.length() - 1);
        }
        sb.append("}");
        return sb.toString();
    }

    public <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
        case "TopicArn":
            return Optional.of(clazz.cast(topicArn()));
        case "AttributeName":
            return Optional.of(clazz.cast(attributeName()));
        case "AttributeValue":
            return Optional.of(clazz.cast(attributeValue()));
        default:
            return Optional.empty();
        }
    }

    public interface Builder extends CopyableBuilder<Builder, SetTopicAttributesRequest> {
        /**
         * <p>
         * The ARN of the topic to modify.
         * </p>
         * 
         * @param topicArn
         *        The ARN of the topic to modify.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder topicArn(String topicArn);

        /**
         * <p>
         * The name of the attribute you want to set. Only a subset of the topic's attributes are mutable.
         * </p>
         * <p>
         * Valid values: <code>Policy</code> | <code>DisplayName</code> | <code>DeliveryPolicy</code>
         * </p>
         * 
         * @param attributeName
         *        The name of the attribute you want to set. Only a subset of the topic's attributes are mutable.</p>
         *        <p>
         *        Valid values: <code>Policy</code> | <code>DisplayName</code> | <code>DeliveryPolicy</code>
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder attributeName(String attributeName);

        /**
         * <p>
         * The new value for the attribute.
         * </p>
         * 
         * @param attributeValue
         *        The new value for the attribute.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder attributeValue(String attributeValue);
    }

    static final class BuilderImpl implements Builder {
        private String topicArn;

        private String attributeName;

        private String attributeValue;

        private BuilderImpl() {
        }

        private BuilderImpl(SetTopicAttributesRequest model) {
            topicArn(model.topicArn);
            attributeName(model.attributeName);
            attributeValue(model.attributeValue);
        }

        public final String getTopicArn() {
            return topicArn;
        }

        @Override
        public final Builder topicArn(String topicArn) {
            this.topicArn = topicArn;
            return this;
        }

        public final void setTopicArn(String topicArn) {
            this.topicArn = topicArn;
        }

        public final String getAttributeName() {
            return attributeName;
        }

        @Override
        public final Builder attributeName(String attributeName) {
            this.attributeName = attributeName;
            return this;
        }

        public final void setAttributeName(String attributeName) {
            this.attributeName = attributeName;
        }

        public final String getAttributeValue() {
            return attributeValue;
        }

        @Override
        public final Builder attributeValue(String attributeValue) {
            this.attributeValue = attributeValue;
            return this;
        }

        public final void setAttributeValue(String attributeValue) {
            this.attributeValue = attributeValue;
        }

        @Override
        public SetTopicAttributesRequest build() {
            return new SetTopicAttributesRequest(this);
        }
    }
}
