/*
 * Copyright 2012-2017 Amazon.com, Inc. or its affiliates. All Rights Reserved.
 * 
 * Licensed under the Apache License, Version 2.0 (the "License"). You may not use this file except in compliance with
 * the License. A copy of the License is located at
 * 
 * http://aws.amazon.com/apache2.0
 * 
 * or in the "license" file accompanying this file. This file is distributed on an "AS IS" BASIS, WITHOUT WARRANTIES OR
 * CONDITIONS OF ANY KIND, either express or implied. See the License for the specific language governing permissions
 * and limitations under the License.
 */

package software.amazon.awssdk.services.sns.transform;

import java.util.ArrayList;

import javax.xml.stream.events.XMLEvent;
import javax.annotation.Generated;

import software.amazon.awssdk.services.sns.model.*;
import software.amazon.awssdk.core.runtime.transform.Unmarshaller;

import software.amazon.awssdk.core.runtime.transform.StaxUnmarshallerContext;
import software.amazon.awssdk.core.runtime.transform.SimpleTypeStaxUnmarshallers.*;

/**
 * ListPlatformApplicationsResponse StAX Unmarshaller
 */

@Generated("software.amazon.awssdk:aws-java-sdk-code-generator")
public class ListPlatformApplicationsResponseUnmarshaller implements
        Unmarshaller<ListPlatformApplicationsResponse, StaxUnmarshallerContext> {

    public ListPlatformApplicationsResponse unmarshall(StaxUnmarshallerContext context) throws Exception {
        ListPlatformApplicationsResponse.Builder listPlatformApplicationsResponse = ListPlatformApplicationsResponse.builder();
        int originalDepth = context.getCurrentDepth();
        int targetDepth = originalDepth + 1;

        if (context.isStartOfDocument())
            targetDepth += 2;

        java.util.List<PlatformApplication> platformApplications = null;

        while (true) {
            XMLEvent xmlEvent = context.nextEvent();
            if (xmlEvent.isEndDocument()) {
                listPlatformApplicationsResponse.platformApplications(platformApplications);
                break;
            }

            if (xmlEvent.isAttribute() || xmlEvent.isStartElement()) {

                if (context.testExpression("PlatformApplications", targetDepth)) {
                    platformApplications = new ArrayList<PlatformApplication>();
                    continue;
                }

                if (context.testExpression("PlatformApplications/member", targetDepth)) {
                    platformApplications.add(PlatformApplicationUnmarshaller.getInstance().unmarshall(context));
                    continue;
                }

                if (context.testExpression("NextToken", targetDepth)) {
                    listPlatformApplicationsResponse.nextToken(StringUnmarshaller.getInstance().unmarshall(context));
                    continue;
                }
            } else if (xmlEvent.isEndElement()) {
                if (context.getCurrentDepth() < originalDepth) {
                    listPlatformApplicationsResponse.platformApplications(platformApplications);
                    break;
                }
            }
        }
        return listPlatformApplicationsResponse.build();
    }

    private static final ListPlatformApplicationsResponseUnmarshaller INSTANCE = new ListPlatformApplicationsResponseUnmarshaller();

    public static ListPlatformApplicationsResponseUnmarshaller getInstance() {
        return INSTANCE;
    }
}
