/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.sns.model;

import java.util.Arrays;
import java.util.Collection;
import java.util.List;
import java.util.Optional;
import software.amazon.awssdk.core.AmazonWebServiceRequest;
import software.amazon.awssdk.services.sns.model.ActionsListCopier;
import software.amazon.awssdk.services.sns.model.DelegatesListCopier;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

public class AddPermissionRequest
extends AmazonWebServiceRequest
implements ToCopyableBuilder<Builder, AddPermissionRequest> {
    private final String topicArn;
    private final String label;
    private final List<String> awsAccountIds;
    private final List<String> actionNames;

    private AddPermissionRequest(BuilderImpl builder) {
        this.topicArn = builder.topicArn;
        this.label = builder.label;
        this.awsAccountIds = builder.awsAccountIds;
        this.actionNames = builder.actionNames;
    }

    public String topicArn() {
        return this.topicArn;
    }

    public String label() {
        return this.label;
    }

    public List<String> awsAccountIds() {
        return this.awsAccountIds;
    }

    public List<String> actionNames() {
        return this.actionNames;
    }

    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    public int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + (this.topicArn() == null ? 0 : this.topicArn().hashCode());
        hashCode = 31 * hashCode + (this.label() == null ? 0 : this.label().hashCode());
        hashCode = 31 * hashCode + (this.awsAccountIds() == null ? 0 : this.awsAccountIds().hashCode());
        hashCode = 31 * hashCode + (this.actionNames() == null ? 0 : this.actionNames().hashCode());
        return hashCode;
    }

    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof AddPermissionRequest)) {
            return false;
        }
        AddPermissionRequest other = (AddPermissionRequest)((Object)obj);
        if (other.topicArn() == null ^ this.topicArn() == null) {
            return false;
        }
        if (other.topicArn() != null && !other.topicArn().equals(this.topicArn())) {
            return false;
        }
        if (other.label() == null ^ this.label() == null) {
            return false;
        }
        if (other.label() != null && !other.label().equals(this.label())) {
            return false;
        }
        if (other.awsAccountIds() == null ^ this.awsAccountIds() == null) {
            return false;
        }
        if (other.awsAccountIds() != null && !other.awsAccountIds().equals(this.awsAccountIds())) {
            return false;
        }
        if (other.actionNames() == null ^ this.actionNames() == null) {
            return false;
        }
        return other.actionNames() == null || other.actionNames().equals(this.actionNames());
    }

    public String toString() {
        StringBuilder sb = new StringBuilder("{");
        if (this.topicArn() != null) {
            sb.append("TopicArn: ").append(this.topicArn()).append(",");
        }
        if (this.label() != null) {
            sb.append("Label: ").append(this.label()).append(",");
        }
        if (this.awsAccountIds() != null) {
            sb.append("AWSAccountIds: ").append(this.awsAccountIds()).append(",");
        }
        if (this.actionNames() != null) {
            sb.append("ActionNames: ").append(this.actionNames()).append(",");
        }
        if (sb.length() > 1) {
            sb.setLength(sb.length() - 1);
        }
        sb.append("}");
        return sb.toString();
    }

    public <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
            case "TopicArn": {
                return Optional.of(clazz.cast(this.topicArn()));
            }
            case "Label": {
                return Optional.of(clazz.cast(this.label()));
            }
            case "AWSAccountIds": {
                return Optional.of(clazz.cast(this.awsAccountIds()));
            }
            case "ActionNames": {
                return Optional.of(clazz.cast(this.actionNames()));
            }
        }
        return Optional.empty();
    }

    static final class BuilderImpl
    implements Builder {
        private String topicArn;
        private String label;
        private List<String> awsAccountIds;
        private List<String> actionNames;

        private BuilderImpl() {
        }

        private BuilderImpl(AddPermissionRequest model) {
            this.topicArn(model.topicArn);
            this.label(model.label);
            this.awsAccountIds(model.awsAccountIds);
            this.actionNames(model.actionNames);
        }

        public final String getTopicArn() {
            return this.topicArn;
        }

        @Override
        public final Builder topicArn(String topicArn) {
            this.topicArn = topicArn;
            return this;
        }

        public final void setTopicArn(String topicArn) {
            this.topicArn = topicArn;
        }

        public final String getLabel() {
            return this.label;
        }

        @Override
        public final Builder label(String label) {
            this.label = label;
            return this;
        }

        public final void setLabel(String label) {
            this.label = label;
        }

        public final Collection<String> getAWSAccountIds() {
            return this.awsAccountIds;
        }

        @Override
        public final Builder awsAccountIds(Collection<String> awsAccountIds) {
            this.awsAccountIds = DelegatesListCopier.copy(awsAccountIds);
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder awsAccountIds(String ... awsAccountIds) {
            this.awsAccountIds(Arrays.asList(awsAccountIds));
            return this;
        }

        public final void setAWSAccountIds(Collection<String> awsAccountIds) {
            this.awsAccountIds = DelegatesListCopier.copy(awsAccountIds);
        }

        public final Collection<String> getActionNames() {
            return this.actionNames;
        }

        @Override
        public final Builder actionNames(Collection<String> actionNames) {
            this.actionNames = ActionsListCopier.copy(actionNames);
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder actionNames(String ... actionNames) {
            this.actionNames(Arrays.asList(actionNames));
            return this;
        }

        public final void setActionNames(Collection<String> actionNames) {
            this.actionNames = ActionsListCopier.copy(actionNames);
        }

        public AddPermissionRequest build() {
            return new AddPermissionRequest(this);
        }
    }

    public static interface Builder
    extends CopyableBuilder<Builder, AddPermissionRequest> {
        public Builder topicArn(String var1);

        public Builder label(String var1);

        public Builder awsAccountIds(Collection<String> var1);

        public Builder awsAccountIds(String ... var1);

        public Builder actionNames(Collection<String> var1);

        public Builder actionNames(String ... var1);
    }
}

