/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.sns.model;

import java.nio.ByteBuffer;
import java.util.Optional;
import software.amazon.awssdk.core.runtime.StandardMemberCopier;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

public class MessageAttributeValue
implements ToCopyableBuilder<Builder, MessageAttributeValue> {
    private final String dataType;
    private final String stringValue;
    private final ByteBuffer binaryValue;

    private MessageAttributeValue(BuilderImpl builder) {
        this.dataType = builder.dataType;
        this.stringValue = builder.stringValue;
        this.binaryValue = builder.binaryValue;
    }

    public String dataType() {
        return this.dataType;
    }

    public String stringValue() {
        return this.stringValue;
    }

    public ByteBuffer binaryValue() {
        return this.binaryValue == null ? null : this.binaryValue.asReadOnlyBuffer();
    }

    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    public int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + (this.dataType() == null ? 0 : this.dataType().hashCode());
        hashCode = 31 * hashCode + (this.stringValue() == null ? 0 : this.stringValue().hashCode());
        hashCode = 31 * hashCode + (this.binaryValue() == null ? 0 : this.binaryValue().hashCode());
        return hashCode;
    }

    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof MessageAttributeValue)) {
            return false;
        }
        MessageAttributeValue other = (MessageAttributeValue)obj;
        if (other.dataType() == null ^ this.dataType() == null) {
            return false;
        }
        if (other.dataType() != null && !other.dataType().equals(this.dataType())) {
            return false;
        }
        if (other.stringValue() == null ^ this.stringValue() == null) {
            return false;
        }
        if (other.stringValue() != null && !other.stringValue().equals(this.stringValue())) {
            return false;
        }
        if (other.binaryValue() == null ^ this.binaryValue() == null) {
            return false;
        }
        return other.binaryValue() == null || other.binaryValue().equals(this.binaryValue());
    }

    public String toString() {
        StringBuilder sb = new StringBuilder("{");
        if (this.dataType() != null) {
            sb.append("DataType: ").append(this.dataType()).append(",");
        }
        if (this.stringValue() != null) {
            sb.append("StringValue: ").append(this.stringValue()).append(",");
        }
        if (this.binaryValue() != null) {
            sb.append("BinaryValue: ").append(this.binaryValue()).append(",");
        }
        if (sb.length() > 1) {
            sb.setLength(sb.length() - 1);
        }
        sb.append("}");
        return sb.toString();
    }

    public <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
            case "DataType": {
                return Optional.of(clazz.cast(this.dataType()));
            }
            case "StringValue": {
                return Optional.of(clazz.cast(this.stringValue()));
            }
            case "BinaryValue": {
                return Optional.of(clazz.cast(this.binaryValue()));
            }
        }
        return Optional.empty();
    }

    static final class BuilderImpl
    implements Builder {
        private String dataType;
        private String stringValue;
        private ByteBuffer binaryValue;

        private BuilderImpl() {
        }

        private BuilderImpl(MessageAttributeValue model) {
            this.dataType(model.dataType);
            this.stringValue(model.stringValue);
            this.binaryValue(model.binaryValue);
        }

        public final String getDataType() {
            return this.dataType;
        }

        @Override
        public final Builder dataType(String dataType) {
            this.dataType = dataType;
            return this;
        }

        public final void setDataType(String dataType) {
            this.dataType = dataType;
        }

        public final String getStringValue() {
            return this.stringValue;
        }

        @Override
        public final Builder stringValue(String stringValue) {
            this.stringValue = stringValue;
            return this;
        }

        public final void setStringValue(String stringValue) {
            this.stringValue = stringValue;
        }

        public final ByteBuffer getBinaryValue() {
            return this.binaryValue;
        }

        @Override
        public final Builder binaryValue(ByteBuffer binaryValue) {
            this.binaryValue = StandardMemberCopier.copy((ByteBuffer)binaryValue);
            return this;
        }

        public final void setBinaryValue(ByteBuffer binaryValue) {
            this.binaryValue = StandardMemberCopier.copy((ByteBuffer)binaryValue);
        }

        public MessageAttributeValue build() {
            return new MessageAttributeValue(this);
        }
    }

    public static interface Builder
    extends CopyableBuilder<Builder, MessageAttributeValue> {
        public Builder dataType(String var1);

        public Builder stringValue(String var1);

        public Builder binaryValue(ByteBuffer var1);
    }
}

