/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.sns.model;

import java.util.Map;
import java.util.Optional;
import software.amazon.awssdk.core.AmazonWebServiceRequest;
import software.amazon.awssdk.services.sns.model.MessageAttributeMapCopier;
import software.amazon.awssdk.services.sns.model.MessageAttributeValue;
import software.amazon.awssdk.utils.CollectionUtils;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

public class PublishRequest
extends AmazonWebServiceRequest
implements ToCopyableBuilder<Builder, PublishRequest> {
    private final String topicArn;
    private final String targetArn;
    private final String phoneNumber;
    private final String message;
    private final String subject;
    private final String messageStructure;
    private final Map<String, MessageAttributeValue> messageAttributes;

    private PublishRequest(BuilderImpl builder) {
        this.topicArn = builder.topicArn;
        this.targetArn = builder.targetArn;
        this.phoneNumber = builder.phoneNumber;
        this.message = builder.message;
        this.subject = builder.subject;
        this.messageStructure = builder.messageStructure;
        this.messageAttributes = builder.messageAttributes;
    }

    public String topicArn() {
        return this.topicArn;
    }

    public String targetArn() {
        return this.targetArn;
    }

    public String phoneNumber() {
        return this.phoneNumber;
    }

    public String message() {
        return this.message;
    }

    public String subject() {
        return this.subject;
    }

    public String messageStructure() {
        return this.messageStructure;
    }

    public Map<String, MessageAttributeValue> messageAttributes() {
        return this.messageAttributes;
    }

    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    public int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + (this.topicArn() == null ? 0 : this.topicArn().hashCode());
        hashCode = 31 * hashCode + (this.targetArn() == null ? 0 : this.targetArn().hashCode());
        hashCode = 31 * hashCode + (this.phoneNumber() == null ? 0 : this.phoneNumber().hashCode());
        hashCode = 31 * hashCode + (this.message() == null ? 0 : this.message().hashCode());
        hashCode = 31 * hashCode + (this.subject() == null ? 0 : this.subject().hashCode());
        hashCode = 31 * hashCode + (this.messageStructure() == null ? 0 : this.messageStructure().hashCode());
        hashCode = 31 * hashCode + (this.messageAttributes() == null ? 0 : this.messageAttributes().hashCode());
        return hashCode;
    }

    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof PublishRequest)) {
            return false;
        }
        PublishRequest other = (PublishRequest)((Object)obj);
        if (other.topicArn() == null ^ this.topicArn() == null) {
            return false;
        }
        if (other.topicArn() != null && !other.topicArn().equals(this.topicArn())) {
            return false;
        }
        if (other.targetArn() == null ^ this.targetArn() == null) {
            return false;
        }
        if (other.targetArn() != null && !other.targetArn().equals(this.targetArn())) {
            return false;
        }
        if (other.phoneNumber() == null ^ this.phoneNumber() == null) {
            return false;
        }
        if (other.phoneNumber() != null && !other.phoneNumber().equals(this.phoneNumber())) {
            return false;
        }
        if (other.message() == null ^ this.message() == null) {
            return false;
        }
        if (other.message() != null && !other.message().equals(this.message())) {
            return false;
        }
        if (other.subject() == null ^ this.subject() == null) {
            return false;
        }
        if (other.subject() != null && !other.subject().equals(this.subject())) {
            return false;
        }
        if (other.messageStructure() == null ^ this.messageStructure() == null) {
            return false;
        }
        if (other.messageStructure() != null && !other.messageStructure().equals(this.messageStructure())) {
            return false;
        }
        if (other.messageAttributes() == null ^ this.messageAttributes() == null) {
            return false;
        }
        return other.messageAttributes() == null || other.messageAttributes().equals(this.messageAttributes());
    }

    public String toString() {
        StringBuilder sb = new StringBuilder("{");
        if (this.topicArn() != null) {
            sb.append("TopicArn: ").append(this.topicArn()).append(",");
        }
        if (this.targetArn() != null) {
            sb.append("TargetArn: ").append(this.targetArn()).append(",");
        }
        if (this.phoneNumber() != null) {
            sb.append("PhoneNumber: ").append(this.phoneNumber()).append(",");
        }
        if (this.message() != null) {
            sb.append("Message: ").append(this.message()).append(",");
        }
        if (this.subject() != null) {
            sb.append("Subject: ").append(this.subject()).append(",");
        }
        if (this.messageStructure() != null) {
            sb.append("MessageStructure: ").append(this.messageStructure()).append(",");
        }
        if (this.messageAttributes() != null) {
            sb.append("MessageAttributes: ").append(this.messageAttributes()).append(",");
        }
        if (sb.length() > 1) {
            sb.setLength(sb.length() - 1);
        }
        sb.append("}");
        return sb.toString();
    }

    public <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
            case "TopicArn": {
                return Optional.of(clazz.cast(this.topicArn()));
            }
            case "TargetArn": {
                return Optional.of(clazz.cast(this.targetArn()));
            }
            case "PhoneNumber": {
                return Optional.of(clazz.cast(this.phoneNumber()));
            }
            case "Message": {
                return Optional.of(clazz.cast(this.message()));
            }
            case "Subject": {
                return Optional.of(clazz.cast(this.subject()));
            }
            case "MessageStructure": {
                return Optional.of(clazz.cast(this.messageStructure()));
            }
            case "MessageAttributes": {
                return Optional.of(clazz.cast(this.messageAttributes()));
            }
        }
        return Optional.empty();
    }

    static final class BuilderImpl
    implements Builder {
        private String topicArn;
        private String targetArn;
        private String phoneNumber;
        private String message;
        private String subject;
        private String messageStructure;
        private Map<String, MessageAttributeValue> messageAttributes;

        private BuilderImpl() {
        }

        private BuilderImpl(PublishRequest model) {
            this.topicArn(model.topicArn);
            this.targetArn(model.targetArn);
            this.phoneNumber(model.phoneNumber);
            this.message(model.message);
            this.subject(model.subject);
            this.messageStructure(model.messageStructure);
            this.messageAttributes(model.messageAttributes);
        }

        public final String getTopicArn() {
            return this.topicArn;
        }

        @Override
        public final Builder topicArn(String topicArn) {
            this.topicArn = topicArn;
            return this;
        }

        public final void setTopicArn(String topicArn) {
            this.topicArn = topicArn;
        }

        public final String getTargetArn() {
            return this.targetArn;
        }

        @Override
        public final Builder targetArn(String targetArn) {
            this.targetArn = targetArn;
            return this;
        }

        public final void setTargetArn(String targetArn) {
            this.targetArn = targetArn;
        }

        public final String getPhoneNumber() {
            return this.phoneNumber;
        }

        @Override
        public final Builder phoneNumber(String phoneNumber) {
            this.phoneNumber = phoneNumber;
            return this;
        }

        public final void setPhoneNumber(String phoneNumber) {
            this.phoneNumber = phoneNumber;
        }

        public final String getMessage() {
            return this.message;
        }

        @Override
        public final Builder message(String message) {
            this.message = message;
            return this;
        }

        public final void setMessage(String message) {
            this.message = message;
        }

        public final String getSubject() {
            return this.subject;
        }

        @Override
        public final Builder subject(String subject) {
            this.subject = subject;
            return this;
        }

        public final void setSubject(String subject) {
            this.subject = subject;
        }

        public final String getMessageStructure() {
            return this.messageStructure;
        }

        @Override
        public final Builder messageStructure(String messageStructure) {
            this.messageStructure = messageStructure;
            return this;
        }

        public final void setMessageStructure(String messageStructure) {
            this.messageStructure = messageStructure;
        }

        public final Map<String, MessageAttributeValue.Builder> getMessageAttributes() {
            return this.messageAttributes != null ? CollectionUtils.mapValues(this.messageAttributes, MessageAttributeValue::toBuilder) : null;
        }

        @Override
        public final Builder messageAttributes(Map<String, MessageAttributeValue> messageAttributes) {
            this.messageAttributes = MessageAttributeMapCopier.copy(messageAttributes);
            return this;
        }

        public final void setMessageAttributes(Map<String, MessageAttributeValue.BuilderImpl> messageAttributes) {
            this.messageAttributes = MessageAttributeMapCopier.copyFromBuilder(messageAttributes);
        }

        public PublishRequest build() {
            return new PublishRequest(this);
        }
    }

    public static interface Builder
    extends CopyableBuilder<Builder, PublishRequest> {
        public Builder topicArn(String var1);

        public Builder targetArn(String var1);

        public Builder phoneNumber(String var1);

        public Builder message(String var1);

        public Builder subject(String var1);

        public Builder messageStructure(String var1);

        public Builder messageAttributes(Map<String, MessageAttributeValue> var1);
    }
}

