/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.sns.transform;

import software.amazon.awssdk.core.AmazonWebServiceRequest;
import software.amazon.awssdk.core.DefaultRequest;
import software.amazon.awssdk.core.Request;
import software.amazon.awssdk.core.SdkClientException;
import software.amazon.awssdk.core.http.HttpMethodName;
import software.amazon.awssdk.core.runtime.transform.Marshaller;
import software.amazon.awssdk.core.util.StringUtils;
import software.amazon.awssdk.services.sns.model.GetTopicAttributesRequest;

public class GetTopicAttributesRequestMarshaller
implements Marshaller<Request<GetTopicAttributesRequest>, GetTopicAttributesRequest> {
    public Request<GetTopicAttributesRequest> marshall(GetTopicAttributesRequest getTopicAttributesRequest) {
        if (getTopicAttributesRequest == null) {
            throw new SdkClientException("Invalid argument passed to marshall(...)");
        }
        DefaultRequest request = new DefaultRequest((AmazonWebServiceRequest)getTopicAttributesRequest, "SNSClient");
        request.addParameter("Action", "GetTopicAttributes");
        request.addParameter("Version", "2010-03-31");
        request.setHttpMethod(HttpMethodName.POST);
        if (getTopicAttributesRequest.topicArn() != null) {
            request.addParameter("TopicArn", StringUtils.fromString((String)getTopicAttributesRequest.topicArn()));
        }
        return request;
    }
}

