/*
 * Copyright 2012-2017 Amazon.com, Inc. or its affiliates. All Rights Reserved.
 * 
 * Licensed under the Apache License, Version 2.0 (the "License"). You may not use this file except in compliance with
 * the License. A copy of the License is located at
 * 
 * http://aws.amazon.com/apache2.0
 * 
 * or in the "license" file accompanying this file. This file is distributed on an "AS IS" BASIS, WITHOUT WARRANTIES OR
 * CONDITIONS OF ANY KIND, either express or implied. See the License for the specific language governing permissions
 * and limitations under the License.
 */

package software.amazon.awssdk.services.sns.model;

import java.util.Objects;
import java.util.Optional;
import javax.annotation.Generated;
import software.amazon.awssdk.core.AmazonWebServiceRequest;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

/**
 * <p>
 * Input for ConfirmSubscription action.
 * </p>
 */
@Generated("software.amazon.awssdk:codegen")
public class ConfirmSubscriptionRequest extends AmazonWebServiceRequest implements
        ToCopyableBuilder<ConfirmSubscriptionRequest.Builder, ConfirmSubscriptionRequest> {
    private final String topicArn;

    private final String token;

    private final String authenticateOnUnsubscribe;

    private ConfirmSubscriptionRequest(BuilderImpl builder) {
        this.topicArn = builder.topicArn;
        this.token = builder.token;
        this.authenticateOnUnsubscribe = builder.authenticateOnUnsubscribe;
    }

    /**
     * <p>
     * The ARN of the topic for which you wish to confirm a subscription.
     * </p>
     * 
     * @return The ARN of the topic for which you wish to confirm a subscription.
     */
    public String topicArn() {
        return topicArn;
    }

    /**
     * <p>
     * Short-lived token sent to an endpoint during the <code>Subscribe</code> action.
     * </p>
     * 
     * @return Short-lived token sent to an endpoint during the <code>Subscribe</code> action.
     */
    public String token() {
        return token;
    }

    /**
     * <p>
     * Disallows unauthenticated unsubscribes of the subscription. If the value of this parameter is <code>true</code>
     * and the request has an AWS signature, then only the topic owner and the subscription owner can unsubscribe the
     * endpoint. The unsubscribe action requires AWS authentication.
     * </p>
     * 
     * @return Disallows unauthenticated unsubscribes of the subscription. If the value of this parameter is
     *         <code>true</code> and the request has an AWS signature, then only the topic owner and the subscription
     *         owner can unsubscribe the endpoint. The unsubscribe action requires AWS authentication.
     */
    public String authenticateOnUnsubscribe() {
        return authenticateOnUnsubscribe;
    }

    @Override
    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    @Override
    public int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + Objects.hashCode(topicArn());
        hashCode = 31 * hashCode + Objects.hashCode(token());
        hashCode = 31 * hashCode + Objects.hashCode(authenticateOnUnsubscribe());
        return hashCode;
    }

    @Override
    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof ConfirmSubscriptionRequest)) {
            return false;
        }
        ConfirmSubscriptionRequest other = (ConfirmSubscriptionRequest) obj;
        return Objects.equals(topicArn(), other.topicArn()) && Objects.equals(token(), other.token())
                && Objects.equals(authenticateOnUnsubscribe(), other.authenticateOnUnsubscribe());
    }

    @Override
    public String toString() {
        StringBuilder sb = new StringBuilder("{");
        if (topicArn() != null) {
            sb.append("TopicArn: ").append(topicArn()).append(",");
        }
        if (token() != null) {
            sb.append("Token: ").append(token()).append(",");
        }
        if (authenticateOnUnsubscribe() != null) {
            sb.append("AuthenticateOnUnsubscribe: ").append(authenticateOnUnsubscribe()).append(",");
        }
        if (sb.length() > 1) {
            sb.setLength(sb.length() - 1);
        }
        sb.append("}");
        return sb.toString();
    }

    public <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
        case "TopicArn":
            return Optional.of(clazz.cast(topicArn()));
        case "Token":
            return Optional.of(clazz.cast(token()));
        case "AuthenticateOnUnsubscribe":
            return Optional.of(clazz.cast(authenticateOnUnsubscribe()));
        default:
            return Optional.empty();
        }
    }

    public interface Builder extends CopyableBuilder<Builder, ConfirmSubscriptionRequest> {
        /**
         * <p>
         * The ARN of the topic for which you wish to confirm a subscription.
         * </p>
         * 
         * @param topicArn
         *        The ARN of the topic for which you wish to confirm a subscription.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder topicArn(String topicArn);

        /**
         * <p>
         * Short-lived token sent to an endpoint during the <code>Subscribe</code> action.
         * </p>
         * 
         * @param token
         *        Short-lived token sent to an endpoint during the <code>Subscribe</code> action.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder token(String token);

        /**
         * <p>
         * Disallows unauthenticated unsubscribes of the subscription. If the value of this parameter is
         * <code>true</code> and the request has an AWS signature, then only the topic owner and the subscription owner
         * can unsubscribe the endpoint. The unsubscribe action requires AWS authentication.
         * </p>
         * 
         * @param authenticateOnUnsubscribe
         *        Disallows unauthenticated unsubscribes of the subscription. If the value of this parameter is
         *        <code>true</code> and the request has an AWS signature, then only the topic owner and the subscription
         *        owner can unsubscribe the endpoint. The unsubscribe action requires AWS authentication.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder authenticateOnUnsubscribe(String authenticateOnUnsubscribe);
    }

    static final class BuilderImpl implements Builder {
        private String topicArn;

        private String token;

        private String authenticateOnUnsubscribe;

        private BuilderImpl() {
        }

        private BuilderImpl(ConfirmSubscriptionRequest model) {
            topicArn(model.topicArn);
            token(model.token);
            authenticateOnUnsubscribe(model.authenticateOnUnsubscribe);
        }

        public final String getTopicArn() {
            return topicArn;
        }

        @Override
        public final Builder topicArn(String topicArn) {
            this.topicArn = topicArn;
            return this;
        }

        public final void setTopicArn(String topicArn) {
            this.topicArn = topicArn;
        }

        public final String getToken() {
            return token;
        }

        @Override
        public final Builder token(String token) {
            this.token = token;
            return this;
        }

        public final void setToken(String token) {
            this.token = token;
        }

        public final String getAuthenticateOnUnsubscribe() {
            return authenticateOnUnsubscribe;
        }

        @Override
        public final Builder authenticateOnUnsubscribe(String authenticateOnUnsubscribe) {
            this.authenticateOnUnsubscribe = authenticateOnUnsubscribe;
            return this;
        }

        public final void setAuthenticateOnUnsubscribe(String authenticateOnUnsubscribe) {
            this.authenticateOnUnsubscribe = authenticateOnUnsubscribe;
        }

        @Override
        public ConfirmSubscriptionRequest build() {
            return new ConfirmSubscriptionRequest(this);
        }
    }
}
