/*
 * Copyright 2012-2017 Amazon.com, Inc. or its affiliates. All Rights Reserved.
 * 
 * Licensed under the Apache License, Version 2.0 (the "License"). You may not use this file except in compliance with
 * the License. A copy of the License is located at
 * 
 * http://aws.amazon.com/apache2.0
 * 
 * or in the "license" file accompanying this file. This file is distributed on an "AS IS" BASIS, WITHOUT WARRANTIES OR
 * CONDITIONS OF ANY KIND, either express or implied. See the License for the specific language governing permissions
 * and limitations under the License.
 */

package software.amazon.awssdk.services.sns.model;

import java.util.Objects;
import java.util.Optional;
import javax.annotation.Generated;
import software.amazon.awssdk.core.AmazonWebServiceResult;
import software.amazon.awssdk.core.ResponseMetadata;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

/**
 * <p>
 * Response from CreatePlatformApplication action.
 * </p>
 */
@Generated("software.amazon.awssdk:codegen")
public class CreatePlatformApplicationResponse extends AmazonWebServiceResult<ResponseMetadata> implements
        ToCopyableBuilder<CreatePlatformApplicationResponse.Builder, CreatePlatformApplicationResponse> {
    private final String platformApplicationArn;

    private CreatePlatformApplicationResponse(BuilderImpl builder) {
        this.platformApplicationArn = builder.platformApplicationArn;
    }

    /**
     * <p>
     * PlatformApplicationArn is returned.
     * </p>
     * 
     * @return PlatformApplicationArn is returned.
     */
    public String platformApplicationArn() {
        return platformApplicationArn;
    }

    @Override
    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    @Override
    public int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + Objects.hashCode(platformApplicationArn());
        return hashCode;
    }

    @Override
    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof CreatePlatformApplicationResponse)) {
            return false;
        }
        CreatePlatformApplicationResponse other = (CreatePlatformApplicationResponse) obj;
        return Objects.equals(platformApplicationArn(), other.platformApplicationArn());
    }

    @Override
    public String toString() {
        StringBuilder sb = new StringBuilder("{");
        if (platformApplicationArn() != null) {
            sb.append("PlatformApplicationArn: ").append(platformApplicationArn()).append(",");
        }
        if (sb.length() > 1) {
            sb.setLength(sb.length() - 1);
        }
        sb.append("}");
        return sb.toString();
    }

    public <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
        case "PlatformApplicationArn":
            return Optional.of(clazz.cast(platformApplicationArn()));
        default:
            return Optional.empty();
        }
    }

    public interface Builder extends CopyableBuilder<Builder, CreatePlatformApplicationResponse> {
        /**
         * <p>
         * PlatformApplicationArn is returned.
         * </p>
         * 
         * @param platformApplicationArn
         *        PlatformApplicationArn is returned.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder platformApplicationArn(String platformApplicationArn);
    }

    static final class BuilderImpl implements Builder {
        private String platformApplicationArn;

        private BuilderImpl() {
        }

        private BuilderImpl(CreatePlatformApplicationResponse model) {
            platformApplicationArn(model.platformApplicationArn);
        }

        public final String getPlatformApplicationArn() {
            return platformApplicationArn;
        }

        @Override
        public final Builder platformApplicationArn(String platformApplicationArn) {
            this.platformApplicationArn = platformApplicationArn;
            return this;
        }

        public final void setPlatformApplicationArn(String platformApplicationArn) {
            this.platformApplicationArn = platformApplicationArn;
        }

        @Override
        public CreatePlatformApplicationResponse build() {
            return new CreatePlatformApplicationResponse(this);
        }
    }
}
