/*
 * Copyright 2012-2017 Amazon.com, Inc. or its affiliates. All Rights Reserved.
 * 
 * Licensed under the Apache License, Version 2.0 (the "License"). You may not use this file except in compliance with
 * the License. A copy of the License is located at
 * 
 * http://aws.amazon.com/apache2.0
 * 
 * or in the "license" file accompanying this file. This file is distributed on an "AS IS" BASIS, WITHOUT WARRANTIES OR
 * CONDITIONS OF ANY KIND, either express or implied. See the License for the specific language governing permissions
 * and limitations under the License.
 */

package software.amazon.awssdk.services.sns.model;

import java.util.Objects;
import java.util.Optional;
import javax.annotation.Generated;
import software.amazon.awssdk.core.AmazonWebServiceResult;
import software.amazon.awssdk.core.ResponseMetadata;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

/**
 * <p>
 * Response from CreateEndpoint action.
 * </p>
 */
@Generated("software.amazon.awssdk:codegen")
public class CreatePlatformEndpointResponse extends AmazonWebServiceResult<ResponseMetadata> implements
        ToCopyableBuilder<CreatePlatformEndpointResponse.Builder, CreatePlatformEndpointResponse> {
    private final String endpointArn;

    private CreatePlatformEndpointResponse(BuilderImpl builder) {
        this.endpointArn = builder.endpointArn;
    }

    /**
     * <p>
     * EndpointArn returned from CreateEndpoint action.
     * </p>
     * 
     * @return EndpointArn returned from CreateEndpoint action.
     */
    public String endpointArn() {
        return endpointArn;
    }

    @Override
    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    @Override
    public int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + Objects.hashCode(endpointArn());
        return hashCode;
    }

    @Override
    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof CreatePlatformEndpointResponse)) {
            return false;
        }
        CreatePlatformEndpointResponse other = (CreatePlatformEndpointResponse) obj;
        return Objects.equals(endpointArn(), other.endpointArn());
    }

    @Override
    public String toString() {
        StringBuilder sb = new StringBuilder("{");
        if (endpointArn() != null) {
            sb.append("EndpointArn: ").append(endpointArn()).append(",");
        }
        if (sb.length() > 1) {
            sb.setLength(sb.length() - 1);
        }
        sb.append("}");
        return sb.toString();
    }

    public <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
        case "EndpointArn":
            return Optional.of(clazz.cast(endpointArn()));
        default:
            return Optional.empty();
        }
    }

    public interface Builder extends CopyableBuilder<Builder, CreatePlatformEndpointResponse> {
        /**
         * <p>
         * EndpointArn returned from CreateEndpoint action.
         * </p>
         * 
         * @param endpointArn
         *        EndpointArn returned from CreateEndpoint action.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder endpointArn(String endpointArn);
    }

    static final class BuilderImpl implements Builder {
        private String endpointArn;

        private BuilderImpl() {
        }

        private BuilderImpl(CreatePlatformEndpointResponse model) {
            endpointArn(model.endpointArn);
        }

        public final String getEndpointArn() {
            return endpointArn;
        }

        @Override
        public final Builder endpointArn(String endpointArn) {
            this.endpointArn = endpointArn;
            return this;
        }

        public final void setEndpointArn(String endpointArn) {
            this.endpointArn = endpointArn;
        }

        @Override
        public CreatePlatformEndpointResponse build() {
            return new CreatePlatformEndpointResponse(this);
        }
    }
}
