/*
 * Copyright 2012-2017 Amazon.com, Inc. or its affiliates. All Rights Reserved.
 * 
 * Licensed under the Apache License, Version 2.0 (the "License"). You may not use this file except in compliance with
 * the License. A copy of the License is located at
 * 
 * http://aws.amazon.com/apache2.0
 * 
 * or in the "license" file accompanying this file. This file is distributed on an "AS IS" BASIS, WITHOUT WARRANTIES OR
 * CONDITIONS OF ANY KIND, either express or implied. See the License for the specific language governing permissions
 * and limitations under the License.
 */

package software.amazon.awssdk.services.sns.model;

import java.util.Arrays;
import java.util.Collection;
import java.util.List;
import java.util.Objects;
import java.util.Optional;
import javax.annotation.Generated;
import software.amazon.awssdk.core.AmazonWebServiceResult;
import software.amazon.awssdk.core.ResponseMetadata;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

/**
 * <p>
 * The response from the <code>ListPhoneNumbersOptedOut</code> action.
 * </p>
 */
@Generated("software.amazon.awssdk:codegen")
public class ListPhoneNumbersOptedOutResponse extends AmazonWebServiceResult<ResponseMetadata> implements
        ToCopyableBuilder<ListPhoneNumbersOptedOutResponse.Builder, ListPhoneNumbersOptedOutResponse> {
    private final List<String> phoneNumbers;

    private final String nextToken;

    private ListPhoneNumbersOptedOutResponse(BuilderImpl builder) {
        this.phoneNumbers = builder.phoneNumbers;
        this.nextToken = builder.nextToken;
    }

    /**
     * <p>
     * A list of phone numbers that are opted out of receiving SMS messages. The list is paginated, and each page can
     * contain up to 100 phone numbers.
     * </p>
     * <p>
     * Attempts to modify the collection returned by this method will result in an UnsupportedOperationException.
     * </p>
     * 
     * @return A list of phone numbers that are opted out of receiving SMS messages. The list is paginated, and each
     *         page can contain up to 100 phone numbers.
     */
    public List<String> phoneNumbers() {
        return phoneNumbers;
    }

    /**
     * <p>
     * A <code>NextToken</code> string is returned when you call the <code>ListPhoneNumbersOptedOut</code> action if
     * additional records are available after the first page of results.
     * </p>
     * 
     * @return A <code>NextToken</code> string is returned when you call the <code>ListPhoneNumbersOptedOut</code>
     *         action if additional records are available after the first page of results.
     */
    public String nextToken() {
        return nextToken;
    }

    @Override
    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    @Override
    public int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + Objects.hashCode(phoneNumbers());
        hashCode = 31 * hashCode + Objects.hashCode(nextToken());
        return hashCode;
    }

    @Override
    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof ListPhoneNumbersOptedOutResponse)) {
            return false;
        }
        ListPhoneNumbersOptedOutResponse other = (ListPhoneNumbersOptedOutResponse) obj;
        return Objects.equals(phoneNumbers(), other.phoneNumbers()) && Objects.equals(nextToken(), other.nextToken());
    }

    @Override
    public String toString() {
        StringBuilder sb = new StringBuilder("{");
        if (phoneNumbers() != null) {
            sb.append("PhoneNumbers: ").append(phoneNumbers()).append(",");
        }
        if (nextToken() != null) {
            sb.append("NextToken: ").append(nextToken()).append(",");
        }
        if (sb.length() > 1) {
            sb.setLength(sb.length() - 1);
        }
        sb.append("}");
        return sb.toString();
    }

    public <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
        case "phoneNumbers":
            return Optional.of(clazz.cast(phoneNumbers()));
        case "nextToken":
            return Optional.of(clazz.cast(nextToken()));
        default:
            return Optional.empty();
        }
    }

    public interface Builder extends CopyableBuilder<Builder, ListPhoneNumbersOptedOutResponse> {
        /**
         * <p>
         * A list of phone numbers that are opted out of receiving SMS messages. The list is paginated, and each page
         * can contain up to 100 phone numbers.
         * </p>
         * 
         * @param phoneNumbers
         *        A list of phone numbers that are opted out of receiving SMS messages. The list is paginated, and each
         *        page can contain up to 100 phone numbers.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder phoneNumbers(Collection<String> phoneNumbers);

        /**
         * <p>
         * A list of phone numbers that are opted out of receiving SMS messages. The list is paginated, and each page
         * can contain up to 100 phone numbers.
         * </p>
         * 
         * @param phoneNumbers
         *        A list of phone numbers that are opted out of receiving SMS messages. The list is paginated, and each
         *        page can contain up to 100 phone numbers.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder phoneNumbers(String... phoneNumbers);

        /**
         * <p>
         * A <code>NextToken</code> string is returned when you call the <code>ListPhoneNumbersOptedOut</code> action if
         * additional records are available after the first page of results.
         * </p>
         * 
         * @param nextToken
         *        A <code>NextToken</code> string is returned when you call the <code>ListPhoneNumbersOptedOut</code>
         *        action if additional records are available after the first page of results.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder nextToken(String nextToken);
    }

    static final class BuilderImpl implements Builder {
        private List<String> phoneNumbers;

        private String nextToken;

        private BuilderImpl() {
        }

        private BuilderImpl(ListPhoneNumbersOptedOutResponse model) {
            phoneNumbers(model.phoneNumbers);
            nextToken(model.nextToken);
        }

        public final Collection<String> getPhoneNumbers() {
            return phoneNumbers;
        }

        @Override
        public final Builder phoneNumbers(Collection<String> phoneNumbers) {
            this.phoneNumbers = PhoneNumberListCopier.copy(phoneNumbers);
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder phoneNumbers(String... phoneNumbers) {
            phoneNumbers(Arrays.asList(phoneNumbers));
            return this;
        }

        public final void setPhoneNumbers(Collection<String> phoneNumbers) {
            this.phoneNumbers = PhoneNumberListCopier.copy(phoneNumbers);
        }

        public final String getNextToken() {
            return nextToken;
        }

        @Override
        public final Builder nextToken(String nextToken) {
            this.nextToken = nextToken;
            return this;
        }

        public final void setNextToken(String nextToken) {
            this.nextToken = nextToken;
        }

        @Override
        public ListPhoneNumbersOptedOutResponse build() {
            return new ListPhoneNumbersOptedOutResponse(this);
        }
    }
}
