/*
 * Copyright 2012-2017 Amazon.com, Inc. or its affiliates. All Rights Reserved.
 * 
 * Licensed under the Apache License, Version 2.0 (the "License"). You may not use this file except in compliance with
 * the License. A copy of the License is located at
 * 
 * http://aws.amazon.com/apache2.0
 * 
 * or in the "license" file accompanying this file. This file is distributed on an "AS IS" BASIS, WITHOUT WARRANTIES OR
 * CONDITIONS OF ANY KIND, either express or implied. See the License for the specific language governing permissions
 * and limitations under the License.
 */

package software.amazon.awssdk.services.sns.model;

import java.util.Arrays;
import java.util.Collection;
import java.util.List;
import java.util.Objects;
import java.util.Optional;
import java.util.stream.Collectors;
import javax.annotation.Generated;
import software.amazon.awssdk.core.AmazonWebServiceResult;
import software.amazon.awssdk.core.ResponseMetadata;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

/**
 * <p>
 * Response for ListSubscriptions action
 * </p>
 */
@Generated("software.amazon.awssdk:codegen")
public class ListSubscriptionsResponse extends AmazonWebServiceResult<ResponseMetadata> implements
        ToCopyableBuilder<ListSubscriptionsResponse.Builder, ListSubscriptionsResponse> {
    private final List<Subscription> subscriptions;

    private final String nextToken;

    private ListSubscriptionsResponse(BuilderImpl builder) {
        this.subscriptions = builder.subscriptions;
        this.nextToken = builder.nextToken;
    }

    /**
     * <p>
     * A list of subscriptions.
     * </p>
     * <p>
     * Attempts to modify the collection returned by this method will result in an UnsupportedOperationException.
     * </p>
     * 
     * @return A list of subscriptions.
     */
    public List<Subscription> subscriptions() {
        return subscriptions;
    }

    /**
     * <p>
     * Token to pass along to the next <code>ListSubscriptions</code> request. This element is returned if there are
     * more subscriptions to retrieve.
     * </p>
     * 
     * @return Token to pass along to the next <code>ListSubscriptions</code> request. This element is returned if there
     *         are more subscriptions to retrieve.
     */
    public String nextToken() {
        return nextToken;
    }

    @Override
    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    @Override
    public int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + Objects.hashCode(subscriptions());
        hashCode = 31 * hashCode + Objects.hashCode(nextToken());
        return hashCode;
    }

    @Override
    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof ListSubscriptionsResponse)) {
            return false;
        }
        ListSubscriptionsResponse other = (ListSubscriptionsResponse) obj;
        return Objects.equals(subscriptions(), other.subscriptions()) && Objects.equals(nextToken(), other.nextToken());
    }

    @Override
    public String toString() {
        StringBuilder sb = new StringBuilder("{");
        if (subscriptions() != null) {
            sb.append("Subscriptions: ").append(subscriptions()).append(",");
        }
        if (nextToken() != null) {
            sb.append("NextToken: ").append(nextToken()).append(",");
        }
        if (sb.length() > 1) {
            sb.setLength(sb.length() - 1);
        }
        sb.append("}");
        return sb.toString();
    }

    public <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
        case "Subscriptions":
            return Optional.of(clazz.cast(subscriptions()));
        case "NextToken":
            return Optional.of(clazz.cast(nextToken()));
        default:
            return Optional.empty();
        }
    }

    public interface Builder extends CopyableBuilder<Builder, ListSubscriptionsResponse> {
        /**
         * <p>
         * A list of subscriptions.
         * </p>
         * 
         * @param subscriptions
         *        A list of subscriptions.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder subscriptions(Collection<Subscription> subscriptions);

        /**
         * <p>
         * A list of subscriptions.
         * </p>
         * 
         * @param subscriptions
         *        A list of subscriptions.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder subscriptions(Subscription... subscriptions);

        /**
         * <p>
         * Token to pass along to the next <code>ListSubscriptions</code> request. This element is returned if there are
         * more subscriptions to retrieve.
         * </p>
         * 
         * @param nextToken
         *        Token to pass along to the next <code>ListSubscriptions</code> request. This element is returned if
         *        there are more subscriptions to retrieve.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder nextToken(String nextToken);
    }

    static final class BuilderImpl implements Builder {
        private List<Subscription> subscriptions;

        private String nextToken;

        private BuilderImpl() {
        }

        private BuilderImpl(ListSubscriptionsResponse model) {
            subscriptions(model.subscriptions);
            nextToken(model.nextToken);
        }

        public final Collection<Subscription.Builder> getSubscriptions() {
            return subscriptions != null ? subscriptions.stream().map(Subscription::toBuilder).collect(Collectors.toList())
                    : null;
        }

        @Override
        public final Builder subscriptions(Collection<Subscription> subscriptions) {
            this.subscriptions = SubscriptionsListCopier.copy(subscriptions);
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder subscriptions(Subscription... subscriptions) {
            subscriptions(Arrays.asList(subscriptions));
            return this;
        }

        public final void setSubscriptions(Collection<Subscription.BuilderImpl> subscriptions) {
            this.subscriptions = SubscriptionsListCopier.copyFromBuilder(subscriptions);
        }

        public final String getNextToken() {
            return nextToken;
        }

        @Override
        public final Builder nextToken(String nextToken) {
            this.nextToken = nextToken;
            return this;
        }

        public final void setNextToken(String nextToken) {
            this.nextToken = nextToken;
        }

        @Override
        public ListSubscriptionsResponse build() {
            return new ListSubscriptionsResponse(this);
        }
    }
}
