/*
 * Copyright 2012-2017 Amazon.com, Inc. or its affiliates. All Rights Reserved.
 * 
 * Licensed under the Apache License, Version 2.0 (the "License"). You may not use this file except in compliance with
 * the License. A copy of the License is located at
 * 
 * http://aws.amazon.com/apache2.0
 * 
 * or in the "license" file accompanying this file. This file is distributed on an "AS IS" BASIS, WITHOUT WARRANTIES OR
 * CONDITIONS OF ANY KIND, either express or implied. See the License for the specific language governing permissions
 * and limitations under the License.
 */

package software.amazon.awssdk.services.sns.model;

import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import javax.annotation.Generated;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

/**
 * <p>
 * Platform application object.
 * </p>
 */
@Generated("software.amazon.awssdk:codegen")
public class PlatformApplication implements ToCopyableBuilder<PlatformApplication.Builder, PlatformApplication> {
    private final String platformApplicationArn;

    private final Map<String, String> attributes;

    private PlatformApplication(BuilderImpl builder) {
        this.platformApplicationArn = builder.platformApplicationArn;
        this.attributes = builder.attributes;
    }

    /**
     * <p>
     * PlatformApplicationArn for platform application object.
     * </p>
     * 
     * @return PlatformApplicationArn for platform application object.
     */
    public String platformApplicationArn() {
        return platformApplicationArn;
    }

    /**
     * <p>
     * Attributes for platform application object.
     * </p>
     * <p>
     * Attempts to modify the collection returned by this method will result in an UnsupportedOperationException.
     * </p>
     * 
     * @return Attributes for platform application object.
     */
    public Map<String, String> attributes() {
        return attributes;
    }

    @Override
    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    @Override
    public int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + Objects.hashCode(platformApplicationArn());
        hashCode = 31 * hashCode + Objects.hashCode(attributes());
        return hashCode;
    }

    @Override
    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof PlatformApplication)) {
            return false;
        }
        PlatformApplication other = (PlatformApplication) obj;
        return Objects.equals(platformApplicationArn(), other.platformApplicationArn())
                && Objects.equals(attributes(), other.attributes());
    }

    @Override
    public String toString() {
        StringBuilder sb = new StringBuilder("{");
        if (platformApplicationArn() != null) {
            sb.append("PlatformApplicationArn: ").append(platformApplicationArn()).append(",");
        }
        if (attributes() != null) {
            sb.append("Attributes: ").append(attributes()).append(",");
        }
        if (sb.length() > 1) {
            sb.setLength(sb.length() - 1);
        }
        sb.append("}");
        return sb.toString();
    }

    public <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
        case "PlatformApplicationArn":
            return Optional.of(clazz.cast(platformApplicationArn()));
        case "Attributes":
            return Optional.of(clazz.cast(attributes()));
        default:
            return Optional.empty();
        }
    }

    public interface Builder extends CopyableBuilder<Builder, PlatformApplication> {
        /**
         * <p>
         * PlatformApplicationArn for platform application object.
         * </p>
         * 
         * @param platformApplicationArn
         *        PlatformApplicationArn for platform application object.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder platformApplicationArn(String platformApplicationArn);

        /**
         * <p>
         * Attributes for platform application object.
         * </p>
         * 
         * @param attributes
         *        Attributes for platform application object.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder attributes(Map<String, String> attributes);
    }

    static final class BuilderImpl implements Builder {
        private String platformApplicationArn;

        private Map<String, String> attributes;

        private BuilderImpl() {
        }

        private BuilderImpl(PlatformApplication model) {
            platformApplicationArn(model.platformApplicationArn);
            attributes(model.attributes);
        }

        public final String getPlatformApplicationArn() {
            return platformApplicationArn;
        }

        @Override
        public final Builder platformApplicationArn(String platformApplicationArn) {
            this.platformApplicationArn = platformApplicationArn;
            return this;
        }

        public final void setPlatformApplicationArn(String platformApplicationArn) {
            this.platformApplicationArn = platformApplicationArn;
        }

        public final Map<String, String> getAttributes() {
            return attributes;
        }

        @Override
        public final Builder attributes(Map<String, String> attributes) {
            this.attributes = MapStringToStringCopier.copy(attributes);
            return this;
        }

        public final void setAttributes(Map<String, String> attributes) {
            this.attributes = MapStringToStringCopier.copy(attributes);
        }

        @Override
        public PlatformApplication build() {
            return new PlatformApplication(this);
        }
    }
}
