/*
 * Copyright 2012-2017 Amazon.com, Inc. or its affiliates. All Rights Reserved.
 * 
 * Licensed under the Apache License, Version 2.0 (the "License"). You may not use this file except in compliance with
 * the License. A copy of the License is located at
 * 
 * http://aws.amazon.com/apache2.0
 * 
 * or in the "license" file accompanying this file. This file is distributed on an "AS IS" BASIS, WITHOUT WARRANTIES OR
 * CONDITIONS OF ANY KIND, either express or implied. See the License for the specific language governing permissions
 * and limitations under the License.
 */

package software.amazon.awssdk.services.sns.model;

import java.util.Objects;
import java.util.Optional;
import javax.annotation.Generated;
import software.amazon.awssdk.core.AmazonWebServiceRequest;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

/**
 * <p>
 * Input for SetSubscriptionAttributes action.
 * </p>
 */
@Generated("software.amazon.awssdk:codegen")
public class SetSubscriptionAttributesRequest extends AmazonWebServiceRequest implements
        ToCopyableBuilder<SetSubscriptionAttributesRequest.Builder, SetSubscriptionAttributesRequest> {
    private final String subscriptionArn;

    private final String attributeName;

    private final String attributeValue;

    private SetSubscriptionAttributesRequest(BuilderImpl builder) {
        this.subscriptionArn = builder.subscriptionArn;
        this.attributeName = builder.attributeName;
        this.attributeValue = builder.attributeValue;
    }

    /**
     * <p>
     * The ARN of the subscription to modify.
     * </p>
     * 
     * @return The ARN of the subscription to modify.
     */
    public String subscriptionArn() {
        return subscriptionArn;
    }

    /**
     * <p>
     * The name of the attribute you want to set. Only a subset of the subscriptions attributes are mutable.
     * </p>
     * <p>
     * Valid values: <code>DeliveryPolicy</code> | <code>RawMessageDelivery</code>
     * </p>
     * 
     * @return The name of the attribute you want to set. Only a subset of the subscriptions attributes are mutable.</p>
     *         <p>
     *         Valid values: <code>DeliveryPolicy</code> | <code>RawMessageDelivery</code>
     */
    public String attributeName() {
        return attributeName;
    }

    /**
     * <p>
     * The new value for the attribute in JSON format.
     * </p>
     * 
     * @return The new value for the attribute in JSON format.
     */
    public String attributeValue() {
        return attributeValue;
    }

    @Override
    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    @Override
    public int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + Objects.hashCode(subscriptionArn());
        hashCode = 31 * hashCode + Objects.hashCode(attributeName());
        hashCode = 31 * hashCode + Objects.hashCode(attributeValue());
        return hashCode;
    }

    @Override
    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof SetSubscriptionAttributesRequest)) {
            return false;
        }
        SetSubscriptionAttributesRequest other = (SetSubscriptionAttributesRequest) obj;
        return Objects.equals(subscriptionArn(), other.subscriptionArn())
                && Objects.equals(attributeName(), other.attributeName())
                && Objects.equals(attributeValue(), other.attributeValue());
    }

    @Override
    public String toString() {
        StringBuilder sb = new StringBuilder("{");
        if (subscriptionArn() != null) {
            sb.append("SubscriptionArn: ").append(subscriptionArn()).append(",");
        }
        if (attributeName() != null) {
            sb.append("AttributeName: ").append(attributeName()).append(",");
        }
        if (attributeValue() != null) {
            sb.append("AttributeValue: ").append(attributeValue()).append(",");
        }
        if (sb.length() > 1) {
            sb.setLength(sb.length() - 1);
        }
        sb.append("}");
        return sb.toString();
    }

    public <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
        case "SubscriptionArn":
            return Optional.of(clazz.cast(subscriptionArn()));
        case "AttributeName":
            return Optional.of(clazz.cast(attributeName()));
        case "AttributeValue":
            return Optional.of(clazz.cast(attributeValue()));
        default:
            return Optional.empty();
        }
    }

    public interface Builder extends CopyableBuilder<Builder, SetSubscriptionAttributesRequest> {
        /**
         * <p>
         * The ARN of the subscription to modify.
         * </p>
         * 
         * @param subscriptionArn
         *        The ARN of the subscription to modify.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder subscriptionArn(String subscriptionArn);

        /**
         * <p>
         * The name of the attribute you want to set. Only a subset of the subscriptions attributes are mutable.
         * </p>
         * <p>
         * Valid values: <code>DeliveryPolicy</code> | <code>RawMessageDelivery</code>
         * </p>
         * 
         * @param attributeName
         *        The name of the attribute you want to set. Only a subset of the subscriptions attributes are
         *        mutable.</p>
         *        <p>
         *        Valid values: <code>DeliveryPolicy</code> | <code>RawMessageDelivery</code>
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder attributeName(String attributeName);

        /**
         * <p>
         * The new value for the attribute in JSON format.
         * </p>
         * 
         * @param attributeValue
         *        The new value for the attribute in JSON format.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder attributeValue(String attributeValue);
    }

    static final class BuilderImpl implements Builder {
        private String subscriptionArn;

        private String attributeName;

        private String attributeValue;

        private BuilderImpl() {
        }

        private BuilderImpl(SetSubscriptionAttributesRequest model) {
            subscriptionArn(model.subscriptionArn);
            attributeName(model.attributeName);
            attributeValue(model.attributeValue);
        }

        public final String getSubscriptionArn() {
            return subscriptionArn;
        }

        @Override
        public final Builder subscriptionArn(String subscriptionArn) {
            this.subscriptionArn = subscriptionArn;
            return this;
        }

        public final void setSubscriptionArn(String subscriptionArn) {
            this.subscriptionArn = subscriptionArn;
        }

        public final String getAttributeName() {
            return attributeName;
        }

        @Override
        public final Builder attributeName(String attributeName) {
            this.attributeName = attributeName;
            return this;
        }

        public final void setAttributeName(String attributeName) {
            this.attributeName = attributeName;
        }

        public final String getAttributeValue() {
            return attributeValue;
        }

        @Override
        public final Builder attributeValue(String attributeValue) {
            this.attributeValue = attributeValue;
            return this;
        }

        public final void setAttributeValue(String attributeValue) {
            this.attributeValue = attributeValue;
        }

        @Override
        public SetSubscriptionAttributesRequest build() {
            return new SetSubscriptionAttributesRequest(this);
        }
    }
}
