/*
 * Copyright 2012-2017 Amazon.com, Inc. or its affiliates. All Rights Reserved.
 * 
 * Licensed under the Apache License, Version 2.0 (the "License"). You may not use this file except in compliance with
 * the License. A copy of the License is located at
 * 
 * http://aws.amazon.com/apache2.0
 * 
 * or in the "license" file accompanying this file. This file is distributed on an "AS IS" BASIS, WITHOUT WARRANTIES OR
 * CONDITIONS OF ANY KIND, either express or implied. See the License for the specific language governing permissions
 * and limitations under the License.
 */

package software.amazon.awssdk.services.sns.transform;

import javax.annotation.Generated;

import software.amazon.awssdk.core.SdkClientException;
import software.amazon.awssdk.core.Request;
import software.amazon.awssdk.core.DefaultRequest;
import software.amazon.awssdk.core.http.HttpMethodName;
import software.amazon.awssdk.services.sns.model.*;
import software.amazon.awssdk.core.runtime.transform.Marshaller;
import software.amazon.awssdk.core.util.StringUtils;

/**
 * SetSubscriptionAttributesRequest Marshaller
 */

@Generated("software.amazon.awssdk:aws-java-sdk-code-generator")
public class SetSubscriptionAttributesRequestMarshaller implements
        Marshaller<Request<SetSubscriptionAttributesRequest>, SetSubscriptionAttributesRequest> {

    public Request<SetSubscriptionAttributesRequest> marshall(SetSubscriptionAttributesRequest setSubscriptionAttributesRequest) {

        if (setSubscriptionAttributesRequest == null) {
            throw new SdkClientException("Invalid argument passed to marshall(...)");
        }

        Request<SetSubscriptionAttributesRequest> request = new DefaultRequest<SetSubscriptionAttributesRequest>(
                setSubscriptionAttributesRequest, "SNSClient");
        request.addParameter("Action", "SetSubscriptionAttributes");
        request.addParameter("Version", "2010-03-31");
        request.setHttpMethod(HttpMethodName.POST);

        if (setSubscriptionAttributesRequest.subscriptionArn() != null) {
            request.addParameter("SubscriptionArn", StringUtils.fromString(setSubscriptionAttributesRequest.subscriptionArn()));
        }

        if (setSubscriptionAttributesRequest.attributeName() != null) {
            request.addParameter("AttributeName", StringUtils.fromString(setSubscriptionAttributesRequest.attributeName()));
        }

        if (setSubscriptionAttributesRequest.attributeValue() != null) {
            request.addParameter("AttributeValue", StringUtils.fromString(setSubscriptionAttributesRequest.attributeValue()));
        }

        return request;
    }

}
