/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.sns;

import java.util.ArrayList;
import java.util.List;
import java.util.concurrent.CompletableFuture;
import org.w3c.dom.Node;
import software.amazon.awssdk.annotations.SdkInternalApi;
import software.amazon.awssdk.core.AmazonServiceException;
import software.amazon.awssdk.core.SdkRequest;
import software.amazon.awssdk.core.client.AsyncClientHandler;
import software.amazon.awssdk.core.client.ClientExecutionParams;
import software.amazon.awssdk.core.client.SdkAsyncClientHandler;
import software.amazon.awssdk.core.config.AsyncClientConfiguration;
import software.amazon.awssdk.core.http.DefaultErrorResponseHandler;
import software.amazon.awssdk.core.http.HttpResponseHandler;
import software.amazon.awssdk.core.http.StaxResponseHandler;
import software.amazon.awssdk.core.runtime.transform.Marshaller;
import software.amazon.awssdk.core.runtime.transform.StandardErrorUnmarshaller;
import software.amazon.awssdk.core.runtime.transform.Unmarshaller;
import software.amazon.awssdk.services.sns.SNSAsyncClient;
import software.amazon.awssdk.services.sns.model.AddPermissionRequest;
import software.amazon.awssdk.services.sns.model.AddPermissionResponse;
import software.amazon.awssdk.services.sns.model.CheckIfPhoneNumberIsOptedOutRequest;
import software.amazon.awssdk.services.sns.model.CheckIfPhoneNumberIsOptedOutResponse;
import software.amazon.awssdk.services.sns.model.ConfirmSubscriptionRequest;
import software.amazon.awssdk.services.sns.model.ConfirmSubscriptionResponse;
import software.amazon.awssdk.services.sns.model.CreatePlatformApplicationRequest;
import software.amazon.awssdk.services.sns.model.CreatePlatformApplicationResponse;
import software.amazon.awssdk.services.sns.model.CreatePlatformEndpointRequest;
import software.amazon.awssdk.services.sns.model.CreatePlatformEndpointResponse;
import software.amazon.awssdk.services.sns.model.CreateTopicRequest;
import software.amazon.awssdk.services.sns.model.CreateTopicResponse;
import software.amazon.awssdk.services.sns.model.DeleteEndpointRequest;
import software.amazon.awssdk.services.sns.model.DeleteEndpointResponse;
import software.amazon.awssdk.services.sns.model.DeletePlatformApplicationRequest;
import software.amazon.awssdk.services.sns.model.DeletePlatformApplicationResponse;
import software.amazon.awssdk.services.sns.model.DeleteTopicRequest;
import software.amazon.awssdk.services.sns.model.DeleteTopicResponse;
import software.amazon.awssdk.services.sns.model.GetEndpointAttributesRequest;
import software.amazon.awssdk.services.sns.model.GetEndpointAttributesResponse;
import software.amazon.awssdk.services.sns.model.GetPlatformApplicationAttributesRequest;
import software.amazon.awssdk.services.sns.model.GetPlatformApplicationAttributesResponse;
import software.amazon.awssdk.services.sns.model.GetSMSAttributesRequest;
import software.amazon.awssdk.services.sns.model.GetSMSAttributesResponse;
import software.amazon.awssdk.services.sns.model.GetSubscriptionAttributesRequest;
import software.amazon.awssdk.services.sns.model.GetSubscriptionAttributesResponse;
import software.amazon.awssdk.services.sns.model.GetTopicAttributesRequest;
import software.amazon.awssdk.services.sns.model.GetTopicAttributesResponse;
import software.amazon.awssdk.services.sns.model.ListEndpointsByPlatformApplicationRequest;
import software.amazon.awssdk.services.sns.model.ListEndpointsByPlatformApplicationResponse;
import software.amazon.awssdk.services.sns.model.ListPhoneNumbersOptedOutRequest;
import software.amazon.awssdk.services.sns.model.ListPhoneNumbersOptedOutResponse;
import software.amazon.awssdk.services.sns.model.ListPlatformApplicationsRequest;
import software.amazon.awssdk.services.sns.model.ListPlatformApplicationsResponse;
import software.amazon.awssdk.services.sns.model.ListSubscriptionsByTopicRequest;
import software.amazon.awssdk.services.sns.model.ListSubscriptionsByTopicResponse;
import software.amazon.awssdk.services.sns.model.ListSubscriptionsRequest;
import software.amazon.awssdk.services.sns.model.ListSubscriptionsResponse;
import software.amazon.awssdk.services.sns.model.ListTopicsRequest;
import software.amazon.awssdk.services.sns.model.ListTopicsResponse;
import software.amazon.awssdk.services.sns.model.OptInPhoneNumberRequest;
import software.amazon.awssdk.services.sns.model.OptInPhoneNumberResponse;
import software.amazon.awssdk.services.sns.model.PublishRequest;
import software.amazon.awssdk.services.sns.model.PublishResponse;
import software.amazon.awssdk.services.sns.model.RemovePermissionRequest;
import software.amazon.awssdk.services.sns.model.RemovePermissionResponse;
import software.amazon.awssdk.services.sns.model.SNSException;
import software.amazon.awssdk.services.sns.model.SetEndpointAttributesRequest;
import software.amazon.awssdk.services.sns.model.SetEndpointAttributesResponse;
import software.amazon.awssdk.services.sns.model.SetPlatformApplicationAttributesRequest;
import software.amazon.awssdk.services.sns.model.SetPlatformApplicationAttributesResponse;
import software.amazon.awssdk.services.sns.model.SetSMSAttributesRequest;
import software.amazon.awssdk.services.sns.model.SetSMSAttributesResponse;
import software.amazon.awssdk.services.sns.model.SetSubscriptionAttributesRequest;
import software.amazon.awssdk.services.sns.model.SetSubscriptionAttributesResponse;
import software.amazon.awssdk.services.sns.model.SetTopicAttributesRequest;
import software.amazon.awssdk.services.sns.model.SetTopicAttributesResponse;
import software.amazon.awssdk.services.sns.model.SubscribeRequest;
import software.amazon.awssdk.services.sns.model.SubscribeResponse;
import software.amazon.awssdk.services.sns.model.UnsubscribeRequest;
import software.amazon.awssdk.services.sns.model.UnsubscribeResponse;
import software.amazon.awssdk.services.sns.transform.AddPermissionRequestMarshaller;
import software.amazon.awssdk.services.sns.transform.AddPermissionResponseUnmarshaller;
import software.amazon.awssdk.services.sns.transform.AuthorizationErrorExceptionUnmarshaller;
import software.amazon.awssdk.services.sns.transform.CheckIfPhoneNumberIsOptedOutRequestMarshaller;
import software.amazon.awssdk.services.sns.transform.CheckIfPhoneNumberIsOptedOutResponseUnmarshaller;
import software.amazon.awssdk.services.sns.transform.ConfirmSubscriptionRequestMarshaller;
import software.amazon.awssdk.services.sns.transform.ConfirmSubscriptionResponseUnmarshaller;
import software.amazon.awssdk.services.sns.transform.CreatePlatformApplicationRequestMarshaller;
import software.amazon.awssdk.services.sns.transform.CreatePlatformApplicationResponseUnmarshaller;
import software.amazon.awssdk.services.sns.transform.CreatePlatformEndpointRequestMarshaller;
import software.amazon.awssdk.services.sns.transform.CreatePlatformEndpointResponseUnmarshaller;
import software.amazon.awssdk.services.sns.transform.CreateTopicRequestMarshaller;
import software.amazon.awssdk.services.sns.transform.CreateTopicResponseUnmarshaller;
import software.amazon.awssdk.services.sns.transform.DeleteEndpointRequestMarshaller;
import software.amazon.awssdk.services.sns.transform.DeleteEndpointResponseUnmarshaller;
import software.amazon.awssdk.services.sns.transform.DeletePlatformApplicationRequestMarshaller;
import software.amazon.awssdk.services.sns.transform.DeletePlatformApplicationResponseUnmarshaller;
import software.amazon.awssdk.services.sns.transform.DeleteTopicRequestMarshaller;
import software.amazon.awssdk.services.sns.transform.DeleteTopicResponseUnmarshaller;
import software.amazon.awssdk.services.sns.transform.EndpointDisabledExceptionUnmarshaller;
import software.amazon.awssdk.services.sns.transform.GetEndpointAttributesRequestMarshaller;
import software.amazon.awssdk.services.sns.transform.GetEndpointAttributesResponseUnmarshaller;
import software.amazon.awssdk.services.sns.transform.GetPlatformApplicationAttributesRequestMarshaller;
import software.amazon.awssdk.services.sns.transform.GetPlatformApplicationAttributesResponseUnmarshaller;
import software.amazon.awssdk.services.sns.transform.GetSMSAttributesRequestMarshaller;
import software.amazon.awssdk.services.sns.transform.GetSMSAttributesResponseUnmarshaller;
import software.amazon.awssdk.services.sns.transform.GetSubscriptionAttributesRequestMarshaller;
import software.amazon.awssdk.services.sns.transform.GetSubscriptionAttributesResponseUnmarshaller;
import software.amazon.awssdk.services.sns.transform.GetTopicAttributesRequestMarshaller;
import software.amazon.awssdk.services.sns.transform.GetTopicAttributesResponseUnmarshaller;
import software.amazon.awssdk.services.sns.transform.InternalErrorExceptionUnmarshaller;
import software.amazon.awssdk.services.sns.transform.InvalidParameterExceptionUnmarshaller;
import software.amazon.awssdk.services.sns.transform.InvalidParameterValueExceptionUnmarshaller;
import software.amazon.awssdk.services.sns.transform.ListEndpointsByPlatformApplicationRequestMarshaller;
import software.amazon.awssdk.services.sns.transform.ListEndpointsByPlatformApplicationResponseUnmarshaller;
import software.amazon.awssdk.services.sns.transform.ListPhoneNumbersOptedOutRequestMarshaller;
import software.amazon.awssdk.services.sns.transform.ListPhoneNumbersOptedOutResponseUnmarshaller;
import software.amazon.awssdk.services.sns.transform.ListPlatformApplicationsRequestMarshaller;
import software.amazon.awssdk.services.sns.transform.ListPlatformApplicationsResponseUnmarshaller;
import software.amazon.awssdk.services.sns.transform.ListSubscriptionsByTopicRequestMarshaller;
import software.amazon.awssdk.services.sns.transform.ListSubscriptionsByTopicResponseUnmarshaller;
import software.amazon.awssdk.services.sns.transform.ListSubscriptionsRequestMarshaller;
import software.amazon.awssdk.services.sns.transform.ListSubscriptionsResponseUnmarshaller;
import software.amazon.awssdk.services.sns.transform.ListTopicsRequestMarshaller;
import software.amazon.awssdk.services.sns.transform.ListTopicsResponseUnmarshaller;
import software.amazon.awssdk.services.sns.transform.NotFoundExceptionUnmarshaller;
import software.amazon.awssdk.services.sns.transform.OptInPhoneNumberRequestMarshaller;
import software.amazon.awssdk.services.sns.transform.OptInPhoneNumberResponseUnmarshaller;
import software.amazon.awssdk.services.sns.transform.PlatformApplicationDisabledExceptionUnmarshaller;
import software.amazon.awssdk.services.sns.transform.PublishRequestMarshaller;
import software.amazon.awssdk.services.sns.transform.PublishResponseUnmarshaller;
import software.amazon.awssdk.services.sns.transform.RemovePermissionRequestMarshaller;
import software.amazon.awssdk.services.sns.transform.RemovePermissionResponseUnmarshaller;
import software.amazon.awssdk.services.sns.transform.SetEndpointAttributesRequestMarshaller;
import software.amazon.awssdk.services.sns.transform.SetEndpointAttributesResponseUnmarshaller;
import software.amazon.awssdk.services.sns.transform.SetPlatformApplicationAttributesRequestMarshaller;
import software.amazon.awssdk.services.sns.transform.SetPlatformApplicationAttributesResponseUnmarshaller;
import software.amazon.awssdk.services.sns.transform.SetSMSAttributesRequestMarshaller;
import software.amazon.awssdk.services.sns.transform.SetSMSAttributesResponseUnmarshaller;
import software.amazon.awssdk.services.sns.transform.SetSubscriptionAttributesRequestMarshaller;
import software.amazon.awssdk.services.sns.transform.SetSubscriptionAttributesResponseUnmarshaller;
import software.amazon.awssdk.services.sns.transform.SetTopicAttributesRequestMarshaller;
import software.amazon.awssdk.services.sns.transform.SetTopicAttributesResponseUnmarshaller;
import software.amazon.awssdk.services.sns.transform.SubscribeRequestMarshaller;
import software.amazon.awssdk.services.sns.transform.SubscribeResponseUnmarshaller;
import software.amazon.awssdk.services.sns.transform.SubscriptionLimitExceededExceptionUnmarshaller;
import software.amazon.awssdk.services.sns.transform.ThrottledExceptionUnmarshaller;
import software.amazon.awssdk.services.sns.transform.TopicLimitExceededExceptionUnmarshaller;
import software.amazon.awssdk.services.sns.transform.UnsubscribeRequestMarshaller;
import software.amazon.awssdk.services.sns.transform.UnsubscribeResponseUnmarshaller;

@SdkInternalApi
final class DefaultSNSAsyncClient
implements SNSAsyncClient {
    private final AsyncClientHandler clientHandler;
    private final List<Unmarshaller<AmazonServiceException, Node>> exceptionUnmarshallers;

    protected DefaultSNSAsyncClient(AsyncClientConfiguration clientConfiguration) {
        this.clientHandler = new SdkAsyncClientHandler(clientConfiguration, null);
        this.exceptionUnmarshallers = this.init();
    }

    @Override
    public CompletableFuture<AddPermissionResponse> addPermission(AddPermissionRequest addPermissionRequest) {
        StaxResponseHandler responseHandler = new StaxResponseHandler((Unmarshaller)new AddPermissionResponseUnmarshaller());
        DefaultErrorResponseHandler errorResponseHandler = new DefaultErrorResponseHandler(this.exceptionUnmarshallers);
        return this.clientHandler.execute(new ClientExecutionParams().withMarshaller((Marshaller)new AddPermissionRequestMarshaller()).withResponseHandler((HttpResponseHandler)responseHandler).withErrorResponseHandler((HttpResponseHandler)errorResponseHandler).withInput((SdkRequest)addPermissionRequest));
    }

    @Override
    public CompletableFuture<CheckIfPhoneNumberIsOptedOutResponse> checkIfPhoneNumberIsOptedOut(CheckIfPhoneNumberIsOptedOutRequest checkIfPhoneNumberIsOptedOutRequest) {
        StaxResponseHandler responseHandler = new StaxResponseHandler((Unmarshaller)new CheckIfPhoneNumberIsOptedOutResponseUnmarshaller());
        DefaultErrorResponseHandler errorResponseHandler = new DefaultErrorResponseHandler(this.exceptionUnmarshallers);
        return this.clientHandler.execute(new ClientExecutionParams().withMarshaller((Marshaller)new CheckIfPhoneNumberIsOptedOutRequestMarshaller()).withResponseHandler((HttpResponseHandler)responseHandler).withErrorResponseHandler((HttpResponseHandler)errorResponseHandler).withInput((SdkRequest)checkIfPhoneNumberIsOptedOutRequest));
    }

    @Override
    public CompletableFuture<ConfirmSubscriptionResponse> confirmSubscription(ConfirmSubscriptionRequest confirmSubscriptionRequest) {
        StaxResponseHandler responseHandler = new StaxResponseHandler((Unmarshaller)new ConfirmSubscriptionResponseUnmarshaller());
        DefaultErrorResponseHandler errorResponseHandler = new DefaultErrorResponseHandler(this.exceptionUnmarshallers);
        return this.clientHandler.execute(new ClientExecutionParams().withMarshaller((Marshaller)new ConfirmSubscriptionRequestMarshaller()).withResponseHandler((HttpResponseHandler)responseHandler).withErrorResponseHandler((HttpResponseHandler)errorResponseHandler).withInput((SdkRequest)confirmSubscriptionRequest));
    }

    @Override
    public CompletableFuture<CreatePlatformApplicationResponse> createPlatformApplication(CreatePlatformApplicationRequest createPlatformApplicationRequest) {
        StaxResponseHandler responseHandler = new StaxResponseHandler((Unmarshaller)new CreatePlatformApplicationResponseUnmarshaller());
        DefaultErrorResponseHandler errorResponseHandler = new DefaultErrorResponseHandler(this.exceptionUnmarshallers);
        return this.clientHandler.execute(new ClientExecutionParams().withMarshaller((Marshaller)new CreatePlatformApplicationRequestMarshaller()).withResponseHandler((HttpResponseHandler)responseHandler).withErrorResponseHandler((HttpResponseHandler)errorResponseHandler).withInput((SdkRequest)createPlatformApplicationRequest));
    }

    @Override
    public CompletableFuture<CreatePlatformEndpointResponse> createPlatformEndpoint(CreatePlatformEndpointRequest createPlatformEndpointRequest) {
        StaxResponseHandler responseHandler = new StaxResponseHandler((Unmarshaller)new CreatePlatformEndpointResponseUnmarshaller());
        DefaultErrorResponseHandler errorResponseHandler = new DefaultErrorResponseHandler(this.exceptionUnmarshallers);
        return this.clientHandler.execute(new ClientExecutionParams().withMarshaller((Marshaller)new CreatePlatformEndpointRequestMarshaller()).withResponseHandler((HttpResponseHandler)responseHandler).withErrorResponseHandler((HttpResponseHandler)errorResponseHandler).withInput((SdkRequest)createPlatformEndpointRequest));
    }

    @Override
    public CompletableFuture<CreateTopicResponse> createTopic(CreateTopicRequest createTopicRequest) {
        StaxResponseHandler responseHandler = new StaxResponseHandler((Unmarshaller)new CreateTopicResponseUnmarshaller());
        DefaultErrorResponseHandler errorResponseHandler = new DefaultErrorResponseHandler(this.exceptionUnmarshallers);
        return this.clientHandler.execute(new ClientExecutionParams().withMarshaller((Marshaller)new CreateTopicRequestMarshaller()).withResponseHandler((HttpResponseHandler)responseHandler).withErrorResponseHandler((HttpResponseHandler)errorResponseHandler).withInput((SdkRequest)createTopicRequest));
    }

    @Override
    public CompletableFuture<DeleteEndpointResponse> deleteEndpoint(DeleteEndpointRequest deleteEndpointRequest) {
        StaxResponseHandler responseHandler = new StaxResponseHandler((Unmarshaller)new DeleteEndpointResponseUnmarshaller());
        DefaultErrorResponseHandler errorResponseHandler = new DefaultErrorResponseHandler(this.exceptionUnmarshallers);
        return this.clientHandler.execute(new ClientExecutionParams().withMarshaller((Marshaller)new DeleteEndpointRequestMarshaller()).withResponseHandler((HttpResponseHandler)responseHandler).withErrorResponseHandler((HttpResponseHandler)errorResponseHandler).withInput((SdkRequest)deleteEndpointRequest));
    }

    @Override
    public CompletableFuture<DeletePlatformApplicationResponse> deletePlatformApplication(DeletePlatformApplicationRequest deletePlatformApplicationRequest) {
        StaxResponseHandler responseHandler = new StaxResponseHandler((Unmarshaller)new DeletePlatformApplicationResponseUnmarshaller());
        DefaultErrorResponseHandler errorResponseHandler = new DefaultErrorResponseHandler(this.exceptionUnmarshallers);
        return this.clientHandler.execute(new ClientExecutionParams().withMarshaller((Marshaller)new DeletePlatformApplicationRequestMarshaller()).withResponseHandler((HttpResponseHandler)responseHandler).withErrorResponseHandler((HttpResponseHandler)errorResponseHandler).withInput((SdkRequest)deletePlatformApplicationRequest));
    }

    @Override
    public CompletableFuture<DeleteTopicResponse> deleteTopic(DeleteTopicRequest deleteTopicRequest) {
        StaxResponseHandler responseHandler = new StaxResponseHandler((Unmarshaller)new DeleteTopicResponseUnmarshaller());
        DefaultErrorResponseHandler errorResponseHandler = new DefaultErrorResponseHandler(this.exceptionUnmarshallers);
        return this.clientHandler.execute(new ClientExecutionParams().withMarshaller((Marshaller)new DeleteTopicRequestMarshaller()).withResponseHandler((HttpResponseHandler)responseHandler).withErrorResponseHandler((HttpResponseHandler)errorResponseHandler).withInput((SdkRequest)deleteTopicRequest));
    }

    @Override
    public CompletableFuture<GetEndpointAttributesResponse> getEndpointAttributes(GetEndpointAttributesRequest getEndpointAttributesRequest) {
        StaxResponseHandler responseHandler = new StaxResponseHandler((Unmarshaller)new GetEndpointAttributesResponseUnmarshaller());
        DefaultErrorResponseHandler errorResponseHandler = new DefaultErrorResponseHandler(this.exceptionUnmarshallers);
        return this.clientHandler.execute(new ClientExecutionParams().withMarshaller((Marshaller)new GetEndpointAttributesRequestMarshaller()).withResponseHandler((HttpResponseHandler)responseHandler).withErrorResponseHandler((HttpResponseHandler)errorResponseHandler).withInput((SdkRequest)getEndpointAttributesRequest));
    }

    @Override
    public CompletableFuture<GetPlatformApplicationAttributesResponse> getPlatformApplicationAttributes(GetPlatformApplicationAttributesRequest getPlatformApplicationAttributesRequest) {
        StaxResponseHandler responseHandler = new StaxResponseHandler((Unmarshaller)new GetPlatformApplicationAttributesResponseUnmarshaller());
        DefaultErrorResponseHandler errorResponseHandler = new DefaultErrorResponseHandler(this.exceptionUnmarshallers);
        return this.clientHandler.execute(new ClientExecutionParams().withMarshaller((Marshaller)new GetPlatformApplicationAttributesRequestMarshaller()).withResponseHandler((HttpResponseHandler)responseHandler).withErrorResponseHandler((HttpResponseHandler)errorResponseHandler).withInput((SdkRequest)getPlatformApplicationAttributesRequest));
    }

    @Override
    public CompletableFuture<GetSMSAttributesResponse> getSMSAttributes(GetSMSAttributesRequest getSMSAttributesRequest) {
        StaxResponseHandler responseHandler = new StaxResponseHandler((Unmarshaller)new GetSMSAttributesResponseUnmarshaller());
        DefaultErrorResponseHandler errorResponseHandler = new DefaultErrorResponseHandler(this.exceptionUnmarshallers);
        return this.clientHandler.execute(new ClientExecutionParams().withMarshaller((Marshaller)new GetSMSAttributesRequestMarshaller()).withResponseHandler((HttpResponseHandler)responseHandler).withErrorResponseHandler((HttpResponseHandler)errorResponseHandler).withInput((SdkRequest)getSMSAttributesRequest));
    }

    @Override
    public CompletableFuture<GetSubscriptionAttributesResponse> getSubscriptionAttributes(GetSubscriptionAttributesRequest getSubscriptionAttributesRequest) {
        StaxResponseHandler responseHandler = new StaxResponseHandler((Unmarshaller)new GetSubscriptionAttributesResponseUnmarshaller());
        DefaultErrorResponseHandler errorResponseHandler = new DefaultErrorResponseHandler(this.exceptionUnmarshallers);
        return this.clientHandler.execute(new ClientExecutionParams().withMarshaller((Marshaller)new GetSubscriptionAttributesRequestMarshaller()).withResponseHandler((HttpResponseHandler)responseHandler).withErrorResponseHandler((HttpResponseHandler)errorResponseHandler).withInput((SdkRequest)getSubscriptionAttributesRequest));
    }

    @Override
    public CompletableFuture<GetTopicAttributesResponse> getTopicAttributes(GetTopicAttributesRequest getTopicAttributesRequest) {
        StaxResponseHandler responseHandler = new StaxResponseHandler((Unmarshaller)new GetTopicAttributesResponseUnmarshaller());
        DefaultErrorResponseHandler errorResponseHandler = new DefaultErrorResponseHandler(this.exceptionUnmarshallers);
        return this.clientHandler.execute(new ClientExecutionParams().withMarshaller((Marshaller)new GetTopicAttributesRequestMarshaller()).withResponseHandler((HttpResponseHandler)responseHandler).withErrorResponseHandler((HttpResponseHandler)errorResponseHandler).withInput((SdkRequest)getTopicAttributesRequest));
    }

    @Override
    public CompletableFuture<ListEndpointsByPlatformApplicationResponse> listEndpointsByPlatformApplication(ListEndpointsByPlatformApplicationRequest listEndpointsByPlatformApplicationRequest) {
        StaxResponseHandler responseHandler = new StaxResponseHandler((Unmarshaller)new ListEndpointsByPlatformApplicationResponseUnmarshaller());
        DefaultErrorResponseHandler errorResponseHandler = new DefaultErrorResponseHandler(this.exceptionUnmarshallers);
        return this.clientHandler.execute(new ClientExecutionParams().withMarshaller((Marshaller)new ListEndpointsByPlatformApplicationRequestMarshaller()).withResponseHandler((HttpResponseHandler)responseHandler).withErrorResponseHandler((HttpResponseHandler)errorResponseHandler).withInput((SdkRequest)listEndpointsByPlatformApplicationRequest));
    }

    @Override
    public CompletableFuture<ListPhoneNumbersOptedOutResponse> listPhoneNumbersOptedOut(ListPhoneNumbersOptedOutRequest listPhoneNumbersOptedOutRequest) {
        StaxResponseHandler responseHandler = new StaxResponseHandler((Unmarshaller)new ListPhoneNumbersOptedOutResponseUnmarshaller());
        DefaultErrorResponseHandler errorResponseHandler = new DefaultErrorResponseHandler(this.exceptionUnmarshallers);
        return this.clientHandler.execute(new ClientExecutionParams().withMarshaller((Marshaller)new ListPhoneNumbersOptedOutRequestMarshaller()).withResponseHandler((HttpResponseHandler)responseHandler).withErrorResponseHandler((HttpResponseHandler)errorResponseHandler).withInput((SdkRequest)listPhoneNumbersOptedOutRequest));
    }

    @Override
    public CompletableFuture<ListPlatformApplicationsResponse> listPlatformApplications(ListPlatformApplicationsRequest listPlatformApplicationsRequest) {
        StaxResponseHandler responseHandler = new StaxResponseHandler((Unmarshaller)new ListPlatformApplicationsResponseUnmarshaller());
        DefaultErrorResponseHandler errorResponseHandler = new DefaultErrorResponseHandler(this.exceptionUnmarshallers);
        return this.clientHandler.execute(new ClientExecutionParams().withMarshaller((Marshaller)new ListPlatformApplicationsRequestMarshaller()).withResponseHandler((HttpResponseHandler)responseHandler).withErrorResponseHandler((HttpResponseHandler)errorResponseHandler).withInput((SdkRequest)listPlatformApplicationsRequest));
    }

    @Override
    public CompletableFuture<ListSubscriptionsResponse> listSubscriptions(ListSubscriptionsRequest listSubscriptionsRequest) {
        StaxResponseHandler responseHandler = new StaxResponseHandler((Unmarshaller)new ListSubscriptionsResponseUnmarshaller());
        DefaultErrorResponseHandler errorResponseHandler = new DefaultErrorResponseHandler(this.exceptionUnmarshallers);
        return this.clientHandler.execute(new ClientExecutionParams().withMarshaller((Marshaller)new ListSubscriptionsRequestMarshaller()).withResponseHandler((HttpResponseHandler)responseHandler).withErrorResponseHandler((HttpResponseHandler)errorResponseHandler).withInput((SdkRequest)listSubscriptionsRequest));
    }

    @Override
    public CompletableFuture<ListSubscriptionsByTopicResponse> listSubscriptionsByTopic(ListSubscriptionsByTopicRequest listSubscriptionsByTopicRequest) {
        StaxResponseHandler responseHandler = new StaxResponseHandler((Unmarshaller)new ListSubscriptionsByTopicResponseUnmarshaller());
        DefaultErrorResponseHandler errorResponseHandler = new DefaultErrorResponseHandler(this.exceptionUnmarshallers);
        return this.clientHandler.execute(new ClientExecutionParams().withMarshaller((Marshaller)new ListSubscriptionsByTopicRequestMarshaller()).withResponseHandler((HttpResponseHandler)responseHandler).withErrorResponseHandler((HttpResponseHandler)errorResponseHandler).withInput((SdkRequest)listSubscriptionsByTopicRequest));
    }

    @Override
    public CompletableFuture<ListTopicsResponse> listTopics(ListTopicsRequest listTopicsRequest) {
        StaxResponseHandler responseHandler = new StaxResponseHandler((Unmarshaller)new ListTopicsResponseUnmarshaller());
        DefaultErrorResponseHandler errorResponseHandler = new DefaultErrorResponseHandler(this.exceptionUnmarshallers);
        return this.clientHandler.execute(new ClientExecutionParams().withMarshaller((Marshaller)new ListTopicsRequestMarshaller()).withResponseHandler((HttpResponseHandler)responseHandler).withErrorResponseHandler((HttpResponseHandler)errorResponseHandler).withInput((SdkRequest)listTopicsRequest));
    }

    @Override
    public CompletableFuture<OptInPhoneNumberResponse> optInPhoneNumber(OptInPhoneNumberRequest optInPhoneNumberRequest) {
        StaxResponseHandler responseHandler = new StaxResponseHandler((Unmarshaller)new OptInPhoneNumberResponseUnmarshaller());
        DefaultErrorResponseHandler errorResponseHandler = new DefaultErrorResponseHandler(this.exceptionUnmarshallers);
        return this.clientHandler.execute(new ClientExecutionParams().withMarshaller((Marshaller)new OptInPhoneNumberRequestMarshaller()).withResponseHandler((HttpResponseHandler)responseHandler).withErrorResponseHandler((HttpResponseHandler)errorResponseHandler).withInput((SdkRequest)optInPhoneNumberRequest));
    }

    @Override
    public CompletableFuture<PublishResponse> publish(PublishRequest publishRequest) {
        StaxResponseHandler responseHandler = new StaxResponseHandler((Unmarshaller)new PublishResponseUnmarshaller());
        DefaultErrorResponseHandler errorResponseHandler = new DefaultErrorResponseHandler(this.exceptionUnmarshallers);
        return this.clientHandler.execute(new ClientExecutionParams().withMarshaller((Marshaller)new PublishRequestMarshaller()).withResponseHandler((HttpResponseHandler)responseHandler).withErrorResponseHandler((HttpResponseHandler)errorResponseHandler).withInput((SdkRequest)publishRequest));
    }

    @Override
    public CompletableFuture<RemovePermissionResponse> removePermission(RemovePermissionRequest removePermissionRequest) {
        StaxResponseHandler responseHandler = new StaxResponseHandler((Unmarshaller)new RemovePermissionResponseUnmarshaller());
        DefaultErrorResponseHandler errorResponseHandler = new DefaultErrorResponseHandler(this.exceptionUnmarshallers);
        return this.clientHandler.execute(new ClientExecutionParams().withMarshaller((Marshaller)new RemovePermissionRequestMarshaller()).withResponseHandler((HttpResponseHandler)responseHandler).withErrorResponseHandler((HttpResponseHandler)errorResponseHandler).withInput((SdkRequest)removePermissionRequest));
    }

    @Override
    public CompletableFuture<SetEndpointAttributesResponse> setEndpointAttributes(SetEndpointAttributesRequest setEndpointAttributesRequest) {
        StaxResponseHandler responseHandler = new StaxResponseHandler((Unmarshaller)new SetEndpointAttributesResponseUnmarshaller());
        DefaultErrorResponseHandler errorResponseHandler = new DefaultErrorResponseHandler(this.exceptionUnmarshallers);
        return this.clientHandler.execute(new ClientExecutionParams().withMarshaller((Marshaller)new SetEndpointAttributesRequestMarshaller()).withResponseHandler((HttpResponseHandler)responseHandler).withErrorResponseHandler((HttpResponseHandler)errorResponseHandler).withInput((SdkRequest)setEndpointAttributesRequest));
    }

    @Override
    public CompletableFuture<SetPlatformApplicationAttributesResponse> setPlatformApplicationAttributes(SetPlatformApplicationAttributesRequest setPlatformApplicationAttributesRequest) {
        StaxResponseHandler responseHandler = new StaxResponseHandler((Unmarshaller)new SetPlatformApplicationAttributesResponseUnmarshaller());
        DefaultErrorResponseHandler errorResponseHandler = new DefaultErrorResponseHandler(this.exceptionUnmarshallers);
        return this.clientHandler.execute(new ClientExecutionParams().withMarshaller((Marshaller)new SetPlatformApplicationAttributesRequestMarshaller()).withResponseHandler((HttpResponseHandler)responseHandler).withErrorResponseHandler((HttpResponseHandler)errorResponseHandler).withInput((SdkRequest)setPlatformApplicationAttributesRequest));
    }

    @Override
    public CompletableFuture<SetSMSAttributesResponse> setSMSAttributes(SetSMSAttributesRequest setSMSAttributesRequest) {
        StaxResponseHandler responseHandler = new StaxResponseHandler((Unmarshaller)new SetSMSAttributesResponseUnmarshaller());
        DefaultErrorResponseHandler errorResponseHandler = new DefaultErrorResponseHandler(this.exceptionUnmarshallers);
        return this.clientHandler.execute(new ClientExecutionParams().withMarshaller((Marshaller)new SetSMSAttributesRequestMarshaller()).withResponseHandler((HttpResponseHandler)responseHandler).withErrorResponseHandler((HttpResponseHandler)errorResponseHandler).withInput((SdkRequest)setSMSAttributesRequest));
    }

    @Override
    public CompletableFuture<SetSubscriptionAttributesResponse> setSubscriptionAttributes(SetSubscriptionAttributesRequest setSubscriptionAttributesRequest) {
        StaxResponseHandler responseHandler = new StaxResponseHandler((Unmarshaller)new SetSubscriptionAttributesResponseUnmarshaller());
        DefaultErrorResponseHandler errorResponseHandler = new DefaultErrorResponseHandler(this.exceptionUnmarshallers);
        return this.clientHandler.execute(new ClientExecutionParams().withMarshaller((Marshaller)new SetSubscriptionAttributesRequestMarshaller()).withResponseHandler((HttpResponseHandler)responseHandler).withErrorResponseHandler((HttpResponseHandler)errorResponseHandler).withInput((SdkRequest)setSubscriptionAttributesRequest));
    }

    @Override
    public CompletableFuture<SetTopicAttributesResponse> setTopicAttributes(SetTopicAttributesRequest setTopicAttributesRequest) {
        StaxResponseHandler responseHandler = new StaxResponseHandler((Unmarshaller)new SetTopicAttributesResponseUnmarshaller());
        DefaultErrorResponseHandler errorResponseHandler = new DefaultErrorResponseHandler(this.exceptionUnmarshallers);
        return this.clientHandler.execute(new ClientExecutionParams().withMarshaller((Marshaller)new SetTopicAttributesRequestMarshaller()).withResponseHandler((HttpResponseHandler)responseHandler).withErrorResponseHandler((HttpResponseHandler)errorResponseHandler).withInput((SdkRequest)setTopicAttributesRequest));
    }

    @Override
    public CompletableFuture<SubscribeResponse> subscribe(SubscribeRequest subscribeRequest) {
        StaxResponseHandler responseHandler = new StaxResponseHandler((Unmarshaller)new SubscribeResponseUnmarshaller());
        DefaultErrorResponseHandler errorResponseHandler = new DefaultErrorResponseHandler(this.exceptionUnmarshallers);
        return this.clientHandler.execute(new ClientExecutionParams().withMarshaller((Marshaller)new SubscribeRequestMarshaller()).withResponseHandler((HttpResponseHandler)responseHandler).withErrorResponseHandler((HttpResponseHandler)errorResponseHandler).withInput((SdkRequest)subscribeRequest));
    }

    @Override
    public CompletableFuture<UnsubscribeResponse> unsubscribe(UnsubscribeRequest unsubscribeRequest) {
        StaxResponseHandler responseHandler = new StaxResponseHandler((Unmarshaller)new UnsubscribeResponseUnmarshaller());
        DefaultErrorResponseHandler errorResponseHandler = new DefaultErrorResponseHandler(this.exceptionUnmarshallers);
        return this.clientHandler.execute(new ClientExecutionParams().withMarshaller((Marshaller)new UnsubscribeRequestMarshaller()).withResponseHandler((HttpResponseHandler)responseHandler).withErrorResponseHandler((HttpResponseHandler)errorResponseHandler).withInput((SdkRequest)unsubscribeRequest));
    }

    public void close() {
        this.clientHandler.close();
    }

    private List<Unmarshaller<AmazonServiceException, Node>> init() {
        ArrayList<Unmarshaller<AmazonServiceException, Node>> unmarshallers = new ArrayList<Unmarshaller<AmazonServiceException, Node>>();
        unmarshallers.add((Unmarshaller<AmazonServiceException, Node>)new SubscriptionLimitExceededExceptionUnmarshaller());
        unmarshallers.add((Unmarshaller<AmazonServiceException, Node>)new InvalidParameterExceptionUnmarshaller());
        unmarshallers.add((Unmarshaller<AmazonServiceException, Node>)new InvalidParameterValueExceptionUnmarshaller());
        unmarshallers.add((Unmarshaller<AmazonServiceException, Node>)new EndpointDisabledExceptionUnmarshaller());
        unmarshallers.add((Unmarshaller<AmazonServiceException, Node>)new NotFoundExceptionUnmarshaller());
        unmarshallers.add((Unmarshaller<AmazonServiceException, Node>)new TopicLimitExceededExceptionUnmarshaller());
        unmarshallers.add((Unmarshaller<AmazonServiceException, Node>)new ThrottledExceptionUnmarshaller());
        unmarshallers.add((Unmarshaller<AmazonServiceException, Node>)new PlatformApplicationDisabledExceptionUnmarshaller());
        unmarshallers.add((Unmarshaller<AmazonServiceException, Node>)new InternalErrorExceptionUnmarshaller());
        unmarshallers.add((Unmarshaller<AmazonServiceException, Node>)new AuthorizationErrorExceptionUnmarshaller());
        unmarshallers.add((Unmarshaller<AmazonServiceException, Node>)new StandardErrorUnmarshaller(SNSException.class));
        return unmarshallers;
    }
}

