/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.sns.paginators;

import java.util.Iterator;
import java.util.function.Function;
import software.amazon.awssdk.core.pagination.NextPageFetcher;
import software.amazon.awssdk.core.pagination.PaginatedItemsIterable;
import software.amazon.awssdk.core.pagination.PaginatedResponsesIterator;
import software.amazon.awssdk.core.pagination.SdkIterable;
import software.amazon.awssdk.services.sns.SNSClient;
import software.amazon.awssdk.services.sns.model.Endpoint;
import software.amazon.awssdk.services.sns.model.ListEndpointsByPlatformApplicationRequest;
import software.amazon.awssdk.services.sns.model.ListEndpointsByPlatformApplicationResponse;

public final class ListEndpointsByPlatformApplicationPaginator
implements SdkIterable<ListEndpointsByPlatformApplicationResponse> {
    private final SNSClient client;
    private final ListEndpointsByPlatformApplicationRequest firstRequest;
    private final NextPageFetcher nextPageFetcher;

    public ListEndpointsByPlatformApplicationPaginator(SNSClient client, ListEndpointsByPlatformApplicationRequest firstRequest) {
        this.client = client;
        this.firstRequest = firstRequest;
        this.nextPageFetcher = new ListEndpointsByPlatformApplicationResponseFetcher();
    }

    public Iterator<ListEndpointsByPlatformApplicationResponse> iterator() {
        return new PaginatedResponsesIterator(this.nextPageFetcher);
    }

    public SdkIterable<Endpoint> endpoints() {
        Function<ListEndpointsByPlatformApplicationResponse, Iterator> getIterator = response -> response != null ? response.endpoints().iterator() : null;
        return new PaginatedItemsIterable((SdkIterable)this, getIterator);
    }

    private class ListEndpointsByPlatformApplicationResponseFetcher
    implements NextPageFetcher<ListEndpointsByPlatformApplicationResponse> {
        private ListEndpointsByPlatformApplicationResponseFetcher() {
        }

        public boolean hasNextPage(ListEndpointsByPlatformApplicationResponse previousPage) {
            return previousPage.nextToken() != null;
        }

        public ListEndpointsByPlatformApplicationResponse nextPage(ListEndpointsByPlatformApplicationResponse previousPage) {
            if (previousPage == null) {
                return ListEndpointsByPlatformApplicationPaginator.this.client.listEndpointsByPlatformApplication(ListEndpointsByPlatformApplicationPaginator.this.firstRequest);
            }
            return ListEndpointsByPlatformApplicationPaginator.this.client.listEndpointsByPlatformApplication((ListEndpointsByPlatformApplicationRequest)((Object)ListEndpointsByPlatformApplicationPaginator.this.firstRequest.toBuilder().nextToken(previousPage.nextToken()).build()));
        }
    }
}

