/*
 * Copyright 2012-2017 Amazon.com, Inc. or its affiliates. All Rights Reserved.
 * 
 * Licensed under the Apache License, Version 2.0 (the "License"). You may not use this file except in compliance with
 * the License. A copy of the License is located at
 * 
 * http://aws.amazon.com/apache2.0
 * 
 * or in the "license" file accompanying this file. This file is distributed on an "AS IS" BASIS, WITHOUT WARRANTIES OR
 * CONDITIONS OF ANY KIND, either express or implied. See the License for the specific language governing permissions
 * and limitations under the License.
 */

package software.amazon.awssdk.services.sns;

import java.util.concurrent.CompletableFuture;
import java.util.function.Consumer;
import javax.annotation.Generated;
import software.amazon.awssdk.services.sns.model.AddPermissionRequest;
import software.amazon.awssdk.services.sns.model.AddPermissionResponse;
import software.amazon.awssdk.services.sns.model.CheckIfPhoneNumberIsOptedOutRequest;
import software.amazon.awssdk.services.sns.model.CheckIfPhoneNumberIsOptedOutResponse;
import software.amazon.awssdk.services.sns.model.ConfirmSubscriptionRequest;
import software.amazon.awssdk.services.sns.model.ConfirmSubscriptionResponse;
import software.amazon.awssdk.services.sns.model.CreatePlatformApplicationRequest;
import software.amazon.awssdk.services.sns.model.CreatePlatformApplicationResponse;
import software.amazon.awssdk.services.sns.model.CreatePlatformEndpointRequest;
import software.amazon.awssdk.services.sns.model.CreatePlatformEndpointResponse;
import software.amazon.awssdk.services.sns.model.CreateTopicRequest;
import software.amazon.awssdk.services.sns.model.CreateTopicResponse;
import software.amazon.awssdk.services.sns.model.DeleteEndpointRequest;
import software.amazon.awssdk.services.sns.model.DeleteEndpointResponse;
import software.amazon.awssdk.services.sns.model.DeletePlatformApplicationRequest;
import software.amazon.awssdk.services.sns.model.DeletePlatformApplicationResponse;
import software.amazon.awssdk.services.sns.model.DeleteTopicRequest;
import software.amazon.awssdk.services.sns.model.DeleteTopicResponse;
import software.amazon.awssdk.services.sns.model.GetEndpointAttributesRequest;
import software.amazon.awssdk.services.sns.model.GetEndpointAttributesResponse;
import software.amazon.awssdk.services.sns.model.GetPlatformApplicationAttributesRequest;
import software.amazon.awssdk.services.sns.model.GetPlatformApplicationAttributesResponse;
import software.amazon.awssdk.services.sns.model.GetSMSAttributesRequest;
import software.amazon.awssdk.services.sns.model.GetSMSAttributesResponse;
import software.amazon.awssdk.services.sns.model.GetSubscriptionAttributesRequest;
import software.amazon.awssdk.services.sns.model.GetSubscriptionAttributesResponse;
import software.amazon.awssdk.services.sns.model.GetTopicAttributesRequest;
import software.amazon.awssdk.services.sns.model.GetTopicAttributesResponse;
import software.amazon.awssdk.services.sns.model.ListEndpointsByPlatformApplicationRequest;
import software.amazon.awssdk.services.sns.model.ListEndpointsByPlatformApplicationResponse;
import software.amazon.awssdk.services.sns.model.ListPhoneNumbersOptedOutRequest;
import software.amazon.awssdk.services.sns.model.ListPhoneNumbersOptedOutResponse;
import software.amazon.awssdk.services.sns.model.ListPlatformApplicationsRequest;
import software.amazon.awssdk.services.sns.model.ListPlatformApplicationsResponse;
import software.amazon.awssdk.services.sns.model.ListSubscriptionsByTopicRequest;
import software.amazon.awssdk.services.sns.model.ListSubscriptionsByTopicResponse;
import software.amazon.awssdk.services.sns.model.ListSubscriptionsRequest;
import software.amazon.awssdk.services.sns.model.ListSubscriptionsResponse;
import software.amazon.awssdk.services.sns.model.ListTopicsRequest;
import software.amazon.awssdk.services.sns.model.ListTopicsResponse;
import software.amazon.awssdk.services.sns.model.OptInPhoneNumberRequest;
import software.amazon.awssdk.services.sns.model.OptInPhoneNumberResponse;
import software.amazon.awssdk.services.sns.model.PublishRequest;
import software.amazon.awssdk.services.sns.model.PublishResponse;
import software.amazon.awssdk.services.sns.model.RemovePermissionRequest;
import software.amazon.awssdk.services.sns.model.RemovePermissionResponse;
import software.amazon.awssdk.services.sns.model.SetEndpointAttributesRequest;
import software.amazon.awssdk.services.sns.model.SetEndpointAttributesResponse;
import software.amazon.awssdk.services.sns.model.SetPlatformApplicationAttributesRequest;
import software.amazon.awssdk.services.sns.model.SetPlatformApplicationAttributesResponse;
import software.amazon.awssdk.services.sns.model.SetSMSAttributesRequest;
import software.amazon.awssdk.services.sns.model.SetSMSAttributesResponse;
import software.amazon.awssdk.services.sns.model.SetSubscriptionAttributesRequest;
import software.amazon.awssdk.services.sns.model.SetSubscriptionAttributesResponse;
import software.amazon.awssdk.services.sns.model.SetTopicAttributesRequest;
import software.amazon.awssdk.services.sns.model.SetTopicAttributesResponse;
import software.amazon.awssdk.services.sns.model.SubscribeRequest;
import software.amazon.awssdk.services.sns.model.SubscribeResponse;
import software.amazon.awssdk.services.sns.model.UnsubscribeRequest;
import software.amazon.awssdk.services.sns.model.UnsubscribeResponse;
import software.amazon.awssdk.utils.SdkAutoCloseable;

/**
 * Service client for accessing Amazon SNS asynchronously. This can be created using the static {@link #builder()}
 * method.
 *
 * <fullname>Amazon Simple Notification Service</fullname>
 * <p>
 * Amazon Simple Notification Service (Amazon SNS) is a web service that enables you to build distributed web-enabled
 * applications. Applications can use Amazon SNS to easily push real-time notification messages to interested
 * subscribers over multiple delivery protocols. For more information about this product see <a
 * href="http://aws.amazon.com/sns/">http://aws.amazon.com/sns</a>. For detailed information about Amazon SNS features
 * and their associated API calls, see the <a href="http://docs.aws.amazon.com/sns/latest/dg/">Amazon SNS Developer
 * Guide</a>.
 * </p>
 * <p>
 * We also provide SDKs that enable you to access Amazon SNS from your preferred programming language. The SDKs contain
 * functionality that automatically takes care of tasks such as: cryptographically signing your service requests,
 * retrying requests, and handling error responses. For a list of available SDKs, go to <a
 * href="http://aws.amazon.com/tools/">Tools for Amazon Web Services</a>.
 * </p>
 */
@Generated("software.amazon.awssdk:codegen")
public interface SNSAsyncClient extends SdkAutoCloseable {
    /**
     * Create a {@link SNSAsyncClient} with the region loaded from the
     * {@link software.amazon.awssdk.core.regions.providers.DefaultAwsRegionProviderChain} and credentials loaded from
     * the {@link software.amazon.awssdk.core.auth.DefaultCredentialsProvider}.
     */
    static SNSAsyncClient create() {
        return builder().build();
    }

    /**
     * Create a builder that can be used to configure and create a {@link SNSAsyncClient}.
     */
    static SNSAsyncClientBuilder builder() {
        return new DefaultSNSAsyncClientBuilder();
    }

    /**
     * <p>
     * Adds a statement to a topic's access control policy, granting access for the specified AWS accounts to the
     * specified actions.
     * </p>
     *
     * @param addPermissionRequest
     * @return A Java Future containing the result of the AddPermission operation returned by the service.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions.
     *         <ul>
     *         <li>InvalidParameterException Indicates that a request parameter does not comply with the associated
     *         constraints.</li>
     *         <li>InternalErrorException Indicates an internal service error.</li>
     *         <li>AuthorizationErrorException Indicates that the user has been denied access to the requested resource.
     *         </li>
     *         <li>NotFoundException Indicates that the requested resource does not exist.</li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>SNSException Base class for all service exceptions. Unknown exceptions will be thrown as an instance
     *         of this type.</li>
     *         </ul>
     * @sample SNSAsyncClient.AddPermission
     * @see <a href="http://docs.aws.amazon.com/goto/WebAPI/sns-2010-03-31/AddPermission" target="_top">AWS API
     *      Documentation</a>
     */
    default CompletableFuture<AddPermissionResponse> addPermission(AddPermissionRequest addPermissionRequest) {
        throw new UnsupportedOperationException();
    }

    /**
     * <p>
     * Adds a statement to a topic's access control policy, granting access for the specified AWS accounts to the
     * specified actions.
     * </p>
     * <br/>
     * This is a convenience which creates an instance of the {@link AddPermissionRequest.Builder} avoiding the need to
     * create one manually via {@link AddPermissionRequest#builder()}
     *
     * @param addPermissionRequest
     *        a {@link Consumer} that will call methods on {@link AddPermissionInput.Builder}.
     * @return A Java Future containing the result of the AddPermission operation returned by the service.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions.
     *         <ul>
     *         <li>InvalidParameterException Indicates that a request parameter does not comply with the associated
     *         constraints.</li>
     *         <li>InternalErrorException Indicates an internal service error.</li>
     *         <li>AuthorizationErrorException Indicates that the user has been denied access to the requested resource.
     *         </li>
     *         <li>NotFoundException Indicates that the requested resource does not exist.</li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>SNSException Base class for all service exceptions. Unknown exceptions will be thrown as an instance
     *         of this type.</li>
     *         </ul>
     * @sample SNSAsyncClient.AddPermission
     * @see <a href="http://docs.aws.amazon.com/goto/WebAPI/sns-2010-03-31/AddPermission" target="_top">AWS API
     *      Documentation</a>
     */
    default CompletableFuture<AddPermissionResponse> addPermission(Consumer<AddPermissionRequest.Builder> addPermissionRequest) {
        return addPermission(AddPermissionRequest.builder().apply(addPermissionRequest).build());
    }

    /**
     * <p>
     * Accepts a phone number and indicates whether the phone holder has opted out of receiving SMS messages from your
     * account. You cannot send SMS messages to a number that is opted out.
     * </p>
     * <p>
     * To resume sending messages, you can opt in the number by using the <code>OptInPhoneNumber</code> action.
     * </p>
     *
     * @param checkIfPhoneNumberIsOptedOutRequest
     *        The input for the <code>CheckIfPhoneNumberIsOptedOut</code> action.
     * @return A Java Future containing the result of the CheckIfPhoneNumberIsOptedOut operation returned by the
     *         service.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions.
     *         <ul>
     *         <li>ThrottledException Indicates that the rate at which requests have been submitted for this action
     *         exceeds the limit for your account.</li>
     *         <li>InternalErrorException Indicates an internal service error.</li>
     *         <li>AuthorizationErrorException Indicates that the user has been denied access to the requested resource.
     *         </li>
     *         <li>InvalidParameterException Indicates that a request parameter does not comply with the associated
     *         constraints.</li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>SNSException Base class for all service exceptions. Unknown exceptions will be thrown as an instance
     *         of this type.</li>
     *         </ul>
     * @sample SNSAsyncClient.CheckIfPhoneNumberIsOptedOut
     * @see <a href="http://docs.aws.amazon.com/goto/WebAPI/sns-2010-03-31/CheckIfPhoneNumberIsOptedOut"
     *      target="_top">AWS API Documentation</a>
     */
    default CompletableFuture<CheckIfPhoneNumberIsOptedOutResponse> checkIfPhoneNumberIsOptedOut(
            CheckIfPhoneNumberIsOptedOutRequest checkIfPhoneNumberIsOptedOutRequest) {
        throw new UnsupportedOperationException();
    }

    /**
     * <p>
     * Accepts a phone number and indicates whether the phone holder has opted out of receiving SMS messages from your
     * account. You cannot send SMS messages to a number that is opted out.
     * </p>
     * <p>
     * To resume sending messages, you can opt in the number by using the <code>OptInPhoneNumber</code> action.
     * </p>
     * <br/>
     * This is a convenience which creates an instance of the {@link CheckIfPhoneNumberIsOptedOutRequest.Builder}
     * avoiding the need to create one manually via {@link CheckIfPhoneNumberIsOptedOutRequest#builder()}
     *
     * @param checkIfPhoneNumberIsOptedOutRequest
     *        a {@link Consumer} that will call methods on {@link CheckIfPhoneNumberIsOptedOutInput.Builder}.
     * @return A Java Future containing the result of the CheckIfPhoneNumberIsOptedOut operation returned by the
     *         service.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions.
     *         <ul>
     *         <li>ThrottledException Indicates that the rate at which requests have been submitted for this action
     *         exceeds the limit for your account.</li>
     *         <li>InternalErrorException Indicates an internal service error.</li>
     *         <li>AuthorizationErrorException Indicates that the user has been denied access to the requested resource.
     *         </li>
     *         <li>InvalidParameterException Indicates that a request parameter does not comply with the associated
     *         constraints.</li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>SNSException Base class for all service exceptions. Unknown exceptions will be thrown as an instance
     *         of this type.</li>
     *         </ul>
     * @sample SNSAsyncClient.CheckIfPhoneNumberIsOptedOut
     * @see <a href="http://docs.aws.amazon.com/goto/WebAPI/sns-2010-03-31/CheckIfPhoneNumberIsOptedOut"
     *      target="_top">AWS API Documentation</a>
     */
    default CompletableFuture<CheckIfPhoneNumberIsOptedOutResponse> checkIfPhoneNumberIsOptedOut(
            Consumer<CheckIfPhoneNumberIsOptedOutRequest.Builder> checkIfPhoneNumberIsOptedOutRequest) {
        return checkIfPhoneNumberIsOptedOut(CheckIfPhoneNumberIsOptedOutRequest.builder()
                .apply(checkIfPhoneNumberIsOptedOutRequest).build());
    }

    /**
     * <p>
     * Verifies an endpoint owner's intent to receive messages by validating the token sent to the endpoint by an
     * earlier <code>Subscribe</code> action. If the token is valid, the action creates a new subscription and returns
     * its Amazon Resource Name (ARN). This call requires an AWS signature only when the
     * <code>AuthenticateOnUnsubscribe</code> flag is set to "true".
     * </p>
     *
     * @param confirmSubscriptionRequest
     *        Input for ConfirmSubscription action.
     * @return A Java Future containing the result of the ConfirmSubscription operation returned by the service.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions.
     *         <ul>
     *         <li>SubscriptionLimitExceededException Indicates that the customer already owns the maximum allowed
     *         number of subscriptions.</li>
     *         <li>InvalidParameterException Indicates that a request parameter does not comply with the associated
     *         constraints.</li>
     *         <li>NotFoundException Indicates that the requested resource does not exist.</li>
     *         <li>InternalErrorException Indicates an internal service error.</li>
     *         <li>AuthorizationErrorException Indicates that the user has been denied access to the requested resource.
     *         </li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>SNSException Base class for all service exceptions. Unknown exceptions will be thrown as an instance
     *         of this type.</li>
     *         </ul>
     * @sample SNSAsyncClient.ConfirmSubscription
     * @see <a href="http://docs.aws.amazon.com/goto/WebAPI/sns-2010-03-31/ConfirmSubscription" target="_top">AWS API
     *      Documentation</a>
     */
    default CompletableFuture<ConfirmSubscriptionResponse> confirmSubscription(
            ConfirmSubscriptionRequest confirmSubscriptionRequest) {
        throw new UnsupportedOperationException();
    }

    /**
     * <p>
     * Verifies an endpoint owner's intent to receive messages by validating the token sent to the endpoint by an
     * earlier <code>Subscribe</code> action. If the token is valid, the action creates a new subscription and returns
     * its Amazon Resource Name (ARN). This call requires an AWS signature only when the
     * <code>AuthenticateOnUnsubscribe</code> flag is set to "true".
     * </p>
     * <br/>
     * This is a convenience which creates an instance of the {@link ConfirmSubscriptionRequest.Builder} avoiding the
     * need to create one manually via {@link ConfirmSubscriptionRequest#builder()}
     *
     * @param confirmSubscriptionRequest
     *        a {@link Consumer} that will call methods on {@link ConfirmSubscriptionInput.Builder}.
     * @return A Java Future containing the result of the ConfirmSubscription operation returned by the service.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions.
     *         <ul>
     *         <li>SubscriptionLimitExceededException Indicates that the customer already owns the maximum allowed
     *         number of subscriptions.</li>
     *         <li>InvalidParameterException Indicates that a request parameter does not comply with the associated
     *         constraints.</li>
     *         <li>NotFoundException Indicates that the requested resource does not exist.</li>
     *         <li>InternalErrorException Indicates an internal service error.</li>
     *         <li>AuthorizationErrorException Indicates that the user has been denied access to the requested resource.
     *         </li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>SNSException Base class for all service exceptions. Unknown exceptions will be thrown as an instance
     *         of this type.</li>
     *         </ul>
     * @sample SNSAsyncClient.ConfirmSubscription
     * @see <a href="http://docs.aws.amazon.com/goto/WebAPI/sns-2010-03-31/ConfirmSubscription" target="_top">AWS API
     *      Documentation</a>
     */
    default CompletableFuture<ConfirmSubscriptionResponse> confirmSubscription(
            Consumer<ConfirmSubscriptionRequest.Builder> confirmSubscriptionRequest) {
        return confirmSubscription(ConfirmSubscriptionRequest.builder().apply(confirmSubscriptionRequest).build());
    }

    /**
     * <p>
     * Creates a platform application object for one of the supported push notification services, such as APNS and GCM,
     * to which devices and mobile apps may register. You must specify PlatformPrincipal and PlatformCredential
     * attributes when using the <code>CreatePlatformApplication</code> action. The PlatformPrincipal is received from
     * the notification service. For APNS/APNS_SANDBOX, PlatformPrincipal is "SSL certificate". For GCM,
     * PlatformPrincipal is not applicable. For ADM, PlatformPrincipal is "client id". The PlatformCredential is also
     * received from the notification service. For WNS, PlatformPrincipal is "Package Security Identifier". For MPNS,
     * PlatformPrincipal is "TLS certificate". For Baidu, PlatformPrincipal is "API key".
     * </p>
     * <p>
     * For APNS/APNS_SANDBOX, PlatformCredential is "private key". For GCM, PlatformCredential is "API key". For ADM,
     * PlatformCredential is "client secret". For WNS, PlatformCredential is "secret key". For MPNS, PlatformCredential
     * is "private key". For Baidu, PlatformCredential is "secret key". The PlatformApplicationArn that is returned when
     * using <code>CreatePlatformApplication</code> is then used as an attribute for the
     * <code>CreatePlatformEndpoint</code> action. For more information, see <a
     * href="http://docs.aws.amazon.com/sns/latest/dg/SNSMobilePush.html">Using Amazon SNS Mobile Push
     * Notifications</a>. For more information about obtaining the PlatformPrincipal and PlatformCredential for each of
     * the supported push notification services, see <a
     * href="http://docs.aws.amazon.com/sns/latest/dg/mobile-push-apns.html">Getting Started with Apple Push
     * Notification Service</a>, <a href="http://docs.aws.amazon.com/sns/latest/dg/mobile-push-adm.html">Getting Started
     * with Amazon Device Messaging</a>, <a
     * href="http://docs.aws.amazon.com/sns/latest/dg/mobile-push-baidu.html">Getting Started with Baidu Cloud Push</a>,
     * <a href="http://docs.aws.amazon.com/sns/latest/dg/mobile-push-gcm.html">Getting Started with Google Cloud
     * Messaging for Android</a>, <a href="http://docs.aws.amazon.com/sns/latest/dg/mobile-push-mpns.html">Getting
     * Started with MPNS</a>, or <a href="http://docs.aws.amazon.com/sns/latest/dg/mobile-push-wns.html">Getting Started
     * with WNS</a>.
     * </p>
     *
     * @param createPlatformApplicationRequest
     *        Input for CreatePlatformApplication action.
     * @return A Java Future containing the result of the CreatePlatformApplication operation returned by the service.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions.
     *         <ul>
     *         <li>InvalidParameterException Indicates that a request parameter does not comply with the associated
     *         constraints.</li>
     *         <li>InternalErrorException Indicates an internal service error.</li>
     *         <li>AuthorizationErrorException Indicates that the user has been denied access to the requested resource.
     *         </li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>SNSException Base class for all service exceptions. Unknown exceptions will be thrown as an instance
     *         of this type.</li>
     *         </ul>
     * @sample SNSAsyncClient.CreatePlatformApplication
     * @see <a href="http://docs.aws.amazon.com/goto/WebAPI/sns-2010-03-31/CreatePlatformApplication" target="_top">AWS
     *      API Documentation</a>
     */
    default CompletableFuture<CreatePlatformApplicationResponse> createPlatformApplication(
            CreatePlatformApplicationRequest createPlatformApplicationRequest) {
        throw new UnsupportedOperationException();
    }

    /**
     * <p>
     * Creates a platform application object for one of the supported push notification services, such as APNS and GCM,
     * to which devices and mobile apps may register. You must specify PlatformPrincipal and PlatformCredential
     * attributes when using the <code>CreatePlatformApplication</code> action. The PlatformPrincipal is received from
     * the notification service. For APNS/APNS_SANDBOX, PlatformPrincipal is "SSL certificate". For GCM,
     * PlatformPrincipal is not applicable. For ADM, PlatformPrincipal is "client id". The PlatformCredential is also
     * received from the notification service. For WNS, PlatformPrincipal is "Package Security Identifier". For MPNS,
     * PlatformPrincipal is "TLS certificate". For Baidu, PlatformPrincipal is "API key".
     * </p>
     * <p>
     * For APNS/APNS_SANDBOX, PlatformCredential is "private key". For GCM, PlatformCredential is "API key". For ADM,
     * PlatformCredential is "client secret". For WNS, PlatformCredential is "secret key". For MPNS, PlatformCredential
     * is "private key". For Baidu, PlatformCredential is "secret key". The PlatformApplicationArn that is returned when
     * using <code>CreatePlatformApplication</code> is then used as an attribute for the
     * <code>CreatePlatformEndpoint</code> action. For more information, see <a
     * href="http://docs.aws.amazon.com/sns/latest/dg/SNSMobilePush.html">Using Amazon SNS Mobile Push
     * Notifications</a>. For more information about obtaining the PlatformPrincipal and PlatformCredential for each of
     * the supported push notification services, see <a
     * href="http://docs.aws.amazon.com/sns/latest/dg/mobile-push-apns.html">Getting Started with Apple Push
     * Notification Service</a>, <a href="http://docs.aws.amazon.com/sns/latest/dg/mobile-push-adm.html">Getting Started
     * with Amazon Device Messaging</a>, <a
     * href="http://docs.aws.amazon.com/sns/latest/dg/mobile-push-baidu.html">Getting Started with Baidu Cloud Push</a>,
     * <a href="http://docs.aws.amazon.com/sns/latest/dg/mobile-push-gcm.html">Getting Started with Google Cloud
     * Messaging for Android</a>, <a href="http://docs.aws.amazon.com/sns/latest/dg/mobile-push-mpns.html">Getting
     * Started with MPNS</a>, or <a href="http://docs.aws.amazon.com/sns/latest/dg/mobile-push-wns.html">Getting Started
     * with WNS</a>.
     * </p>
     * <br/>
     * This is a convenience which creates an instance of the {@link CreatePlatformApplicationRequest.Builder} avoiding
     * the need to create one manually via {@link CreatePlatformApplicationRequest#builder()}
     *
     * @param createPlatformApplicationRequest
     *        a {@link Consumer} that will call methods on {@link CreatePlatformApplicationInput.Builder}.
     * @return A Java Future containing the result of the CreatePlatformApplication operation returned by the service.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions.
     *         <ul>
     *         <li>InvalidParameterException Indicates that a request parameter does not comply with the associated
     *         constraints.</li>
     *         <li>InternalErrorException Indicates an internal service error.</li>
     *         <li>AuthorizationErrorException Indicates that the user has been denied access to the requested resource.
     *         </li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>SNSException Base class for all service exceptions. Unknown exceptions will be thrown as an instance
     *         of this type.</li>
     *         </ul>
     * @sample SNSAsyncClient.CreatePlatformApplication
     * @see <a href="http://docs.aws.amazon.com/goto/WebAPI/sns-2010-03-31/CreatePlatformApplication" target="_top">AWS
     *      API Documentation</a>
     */
    default CompletableFuture<CreatePlatformApplicationResponse> createPlatformApplication(
            Consumer<CreatePlatformApplicationRequest.Builder> createPlatformApplicationRequest) {
        return createPlatformApplication(CreatePlatformApplicationRequest.builder().apply(createPlatformApplicationRequest)
                .build());
    }

    /**
     * <p>
     * Creates an endpoint for a device and mobile app on one of the supported push notification services, such as GCM
     * and APNS. <code>CreatePlatformEndpoint</code> requires the PlatformApplicationArn that is returned from
     * <code>CreatePlatformApplication</code>. The EndpointArn that is returned when using
     * <code>CreatePlatformEndpoint</code> can then be used by the <code>Publish</code> action to send a message to a
     * mobile app or by the <code>Subscribe</code> action for subscription to a topic. The
     * <code>CreatePlatformEndpoint</code> action is idempotent, so if the requester already owns an endpoint with the
     * same device token and attributes, that endpoint's ARN is returned without creating a new endpoint. For more
     * information, see <a href="http://docs.aws.amazon.com/sns/latest/dg/SNSMobilePush.html">Using Amazon SNS Mobile
     * Push Notifications</a>.
     * </p>
     * <p>
     * When using <code>CreatePlatformEndpoint</code> with Baidu, two attributes must be provided: ChannelId and UserId.
     * The token field must also contain the ChannelId. For more information, see <a
     * href="http://docs.aws.amazon.com/sns/latest/dg/SNSMobilePushBaiduEndpoint.html">Creating an Amazon SNS Endpoint
     * for Baidu</a>.
     * </p>
     *
     * @param createPlatformEndpointRequest
     *        Input for CreatePlatformEndpoint action.
     * @return A Java Future containing the result of the CreatePlatformEndpoint operation returned by the service.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions.
     *         <ul>
     *         <li>InvalidParameterException Indicates that a request parameter does not comply with the associated
     *         constraints.</li>
     *         <li>InternalErrorException Indicates an internal service error.</li>
     *         <li>AuthorizationErrorException Indicates that the user has been denied access to the requested resource.
     *         </li>
     *         <li>NotFoundException Indicates that the requested resource does not exist.</li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>SNSException Base class for all service exceptions. Unknown exceptions will be thrown as an instance
     *         of this type.</li>
     *         </ul>
     * @sample SNSAsyncClient.CreatePlatformEndpoint
     * @see <a href="http://docs.aws.amazon.com/goto/WebAPI/sns-2010-03-31/CreatePlatformEndpoint" target="_top">AWS API
     *      Documentation</a>
     */
    default CompletableFuture<CreatePlatformEndpointResponse> createPlatformEndpoint(
            CreatePlatformEndpointRequest createPlatformEndpointRequest) {
        throw new UnsupportedOperationException();
    }

    /**
     * <p>
     * Creates an endpoint for a device and mobile app on one of the supported push notification services, such as GCM
     * and APNS. <code>CreatePlatformEndpoint</code> requires the PlatformApplicationArn that is returned from
     * <code>CreatePlatformApplication</code>. The EndpointArn that is returned when using
     * <code>CreatePlatformEndpoint</code> can then be used by the <code>Publish</code> action to send a message to a
     * mobile app or by the <code>Subscribe</code> action for subscription to a topic. The
     * <code>CreatePlatformEndpoint</code> action is idempotent, so if the requester already owns an endpoint with the
     * same device token and attributes, that endpoint's ARN is returned without creating a new endpoint. For more
     * information, see <a href="http://docs.aws.amazon.com/sns/latest/dg/SNSMobilePush.html">Using Amazon SNS Mobile
     * Push Notifications</a>.
     * </p>
     * <p>
     * When using <code>CreatePlatformEndpoint</code> with Baidu, two attributes must be provided: ChannelId and UserId.
     * The token field must also contain the ChannelId. For more information, see <a
     * href="http://docs.aws.amazon.com/sns/latest/dg/SNSMobilePushBaiduEndpoint.html">Creating an Amazon SNS Endpoint
     * for Baidu</a>.
     * </p>
     * <br/>
     * This is a convenience which creates an instance of the {@link CreatePlatformEndpointRequest.Builder} avoiding the
     * need to create one manually via {@link CreatePlatformEndpointRequest#builder()}
     *
     * @param createPlatformEndpointRequest
     *        a {@link Consumer} that will call methods on {@link CreatePlatformEndpointInput.Builder}.
     * @return A Java Future containing the result of the CreatePlatformEndpoint operation returned by the service.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions.
     *         <ul>
     *         <li>InvalidParameterException Indicates that a request parameter does not comply with the associated
     *         constraints.</li>
     *         <li>InternalErrorException Indicates an internal service error.</li>
     *         <li>AuthorizationErrorException Indicates that the user has been denied access to the requested resource.
     *         </li>
     *         <li>NotFoundException Indicates that the requested resource does not exist.</li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>SNSException Base class for all service exceptions. Unknown exceptions will be thrown as an instance
     *         of this type.</li>
     *         </ul>
     * @sample SNSAsyncClient.CreatePlatformEndpoint
     * @see <a href="http://docs.aws.amazon.com/goto/WebAPI/sns-2010-03-31/CreatePlatformEndpoint" target="_top">AWS API
     *      Documentation</a>
     */
    default CompletableFuture<CreatePlatformEndpointResponse> createPlatformEndpoint(
            Consumer<CreatePlatformEndpointRequest.Builder> createPlatformEndpointRequest) {
        return createPlatformEndpoint(CreatePlatformEndpointRequest.builder().apply(createPlatformEndpointRequest).build());
    }

    /**
     * <p>
     * Creates a topic to which notifications can be published. Users can create at most 100,000 topics. For more
     * information, see <a href="http://aws.amazon.com/sns/">http://aws.amazon.com/sns</a>. This action is idempotent,
     * so if the requester already owns a topic with the specified name, that topic's ARN is returned without creating a
     * new topic.
     * </p>
     *
     * @param createTopicRequest
     *        Input for CreateTopic action.
     * @return A Java Future containing the result of the CreateTopic operation returned by the service.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions.
     *         <ul>
     *         <li>InvalidParameterException Indicates that a request parameter does not comply with the associated
     *         constraints.</li>
     *         <li>TopicLimitExceededException Indicates that the customer already owns the maximum allowed number of
     *         topics.</li>
     *         <li>InternalErrorException Indicates an internal service error.</li>
     *         <li>AuthorizationErrorException Indicates that the user has been denied access to the requested resource.
     *         </li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>SNSException Base class for all service exceptions. Unknown exceptions will be thrown as an instance
     *         of this type.</li>
     *         </ul>
     * @sample SNSAsyncClient.CreateTopic
     * @see <a href="http://docs.aws.amazon.com/goto/WebAPI/sns-2010-03-31/CreateTopic" target="_top">AWS API
     *      Documentation</a>
     */
    default CompletableFuture<CreateTopicResponse> createTopic(CreateTopicRequest createTopicRequest) {
        throw new UnsupportedOperationException();
    }

    /**
     * <p>
     * Creates a topic to which notifications can be published. Users can create at most 100,000 topics. For more
     * information, see <a href="http://aws.amazon.com/sns/">http://aws.amazon.com/sns</a>. This action is idempotent,
     * so if the requester already owns a topic with the specified name, that topic's ARN is returned without creating a
     * new topic.
     * </p>
     * <br/>
     * This is a convenience which creates an instance of the {@link CreateTopicRequest.Builder} avoiding the need to
     * create one manually via {@link CreateTopicRequest#builder()}
     *
     * @param createTopicRequest
     *        a {@link Consumer} that will call methods on {@link CreateTopicInput.Builder}.
     * @return A Java Future containing the result of the CreateTopic operation returned by the service.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions.
     *         <ul>
     *         <li>InvalidParameterException Indicates that a request parameter does not comply with the associated
     *         constraints.</li>
     *         <li>TopicLimitExceededException Indicates that the customer already owns the maximum allowed number of
     *         topics.</li>
     *         <li>InternalErrorException Indicates an internal service error.</li>
     *         <li>AuthorizationErrorException Indicates that the user has been denied access to the requested resource.
     *         </li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>SNSException Base class for all service exceptions. Unknown exceptions will be thrown as an instance
     *         of this type.</li>
     *         </ul>
     * @sample SNSAsyncClient.CreateTopic
     * @see <a href="http://docs.aws.amazon.com/goto/WebAPI/sns-2010-03-31/CreateTopic" target="_top">AWS API
     *      Documentation</a>
     */
    default CompletableFuture<CreateTopicResponse> createTopic(Consumer<CreateTopicRequest.Builder> createTopicRequest) {
        return createTopic(CreateTopicRequest.builder().apply(createTopicRequest).build());
    }

    /**
     * <p>
     * Deletes the endpoint for a device and mobile app from Amazon SNS. This action is idempotent. For more
     * information, see <a href="http://docs.aws.amazon.com/sns/latest/dg/SNSMobilePush.html">Using Amazon SNS Mobile
     * Push Notifications</a>.
     * </p>
     * <p>
     * When you delete an endpoint that is also subscribed to a topic, then you must also unsubscribe the endpoint from
     * the topic.
     * </p>
     *
     * @param deleteEndpointRequest
     *        Input for DeleteEndpoint action.
     * @return A Java Future containing the result of the DeleteEndpoint operation returned by the service.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions.
     *         <ul>
     *         <li>InvalidParameterException Indicates that a request parameter does not comply with the associated
     *         constraints.</li>
     *         <li>InternalErrorException Indicates an internal service error.</li>
     *         <li>AuthorizationErrorException Indicates that the user has been denied access to the requested resource.
     *         </li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>SNSException Base class for all service exceptions. Unknown exceptions will be thrown as an instance
     *         of this type.</li>
     *         </ul>
     * @sample SNSAsyncClient.DeleteEndpoint
     * @see <a href="http://docs.aws.amazon.com/goto/WebAPI/sns-2010-03-31/DeleteEndpoint" target="_top">AWS API
     *      Documentation</a>
     */
    default CompletableFuture<DeleteEndpointResponse> deleteEndpoint(DeleteEndpointRequest deleteEndpointRequest) {
        throw new UnsupportedOperationException();
    }

    /**
     * <p>
     * Deletes the endpoint for a device and mobile app from Amazon SNS. This action is idempotent. For more
     * information, see <a href="http://docs.aws.amazon.com/sns/latest/dg/SNSMobilePush.html">Using Amazon SNS Mobile
     * Push Notifications</a>.
     * </p>
     * <p>
     * When you delete an endpoint that is also subscribed to a topic, then you must also unsubscribe the endpoint from
     * the topic.
     * </p>
     * <br/>
     * This is a convenience which creates an instance of the {@link DeleteEndpointRequest.Builder} avoiding the need to
     * create one manually via {@link DeleteEndpointRequest#builder()}
     *
     * @param deleteEndpointRequest
     *        a {@link Consumer} that will call methods on {@link DeleteEndpointInput.Builder}.
     * @return A Java Future containing the result of the DeleteEndpoint operation returned by the service.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions.
     *         <ul>
     *         <li>InvalidParameterException Indicates that a request parameter does not comply with the associated
     *         constraints.</li>
     *         <li>InternalErrorException Indicates an internal service error.</li>
     *         <li>AuthorizationErrorException Indicates that the user has been denied access to the requested resource.
     *         </li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>SNSException Base class for all service exceptions. Unknown exceptions will be thrown as an instance
     *         of this type.</li>
     *         </ul>
     * @sample SNSAsyncClient.DeleteEndpoint
     * @see <a href="http://docs.aws.amazon.com/goto/WebAPI/sns-2010-03-31/DeleteEndpoint" target="_top">AWS API
     *      Documentation</a>
     */
    default CompletableFuture<DeleteEndpointResponse> deleteEndpoint(Consumer<DeleteEndpointRequest.Builder> deleteEndpointRequest) {
        return deleteEndpoint(DeleteEndpointRequest.builder().apply(deleteEndpointRequest).build());
    }

    /**
     * <p>
     * Deletes a platform application object for one of the supported push notification services, such as APNS and GCM.
     * For more information, see <a href="http://docs.aws.amazon.com/sns/latest/dg/SNSMobilePush.html">Using Amazon SNS
     * Mobile Push Notifications</a>.
     * </p>
     *
     * @param deletePlatformApplicationRequest
     *        Input for DeletePlatformApplication action.
     * @return A Java Future containing the result of the DeletePlatformApplication operation returned by the service.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions.
     *         <ul>
     *         <li>InvalidParameterException Indicates that a request parameter does not comply with the associated
     *         constraints.</li>
     *         <li>InternalErrorException Indicates an internal service error.</li>
     *         <li>AuthorizationErrorException Indicates that the user has been denied access to the requested resource.
     *         </li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>SNSException Base class for all service exceptions. Unknown exceptions will be thrown as an instance
     *         of this type.</li>
     *         </ul>
     * @sample SNSAsyncClient.DeletePlatformApplication
     * @see <a href="http://docs.aws.amazon.com/goto/WebAPI/sns-2010-03-31/DeletePlatformApplication" target="_top">AWS
     *      API Documentation</a>
     */
    default CompletableFuture<DeletePlatformApplicationResponse> deletePlatformApplication(
            DeletePlatformApplicationRequest deletePlatformApplicationRequest) {
        throw new UnsupportedOperationException();
    }

    /**
     * <p>
     * Deletes a platform application object for one of the supported push notification services, such as APNS and GCM.
     * For more information, see <a href="http://docs.aws.amazon.com/sns/latest/dg/SNSMobilePush.html">Using Amazon SNS
     * Mobile Push Notifications</a>.
     * </p>
     * <br/>
     * This is a convenience which creates an instance of the {@link DeletePlatformApplicationRequest.Builder} avoiding
     * the need to create one manually via {@link DeletePlatformApplicationRequest#builder()}
     *
     * @param deletePlatformApplicationRequest
     *        a {@link Consumer} that will call methods on {@link DeletePlatformApplicationInput.Builder}.
     * @return A Java Future containing the result of the DeletePlatformApplication operation returned by the service.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions.
     *         <ul>
     *         <li>InvalidParameterException Indicates that a request parameter does not comply with the associated
     *         constraints.</li>
     *         <li>InternalErrorException Indicates an internal service error.</li>
     *         <li>AuthorizationErrorException Indicates that the user has been denied access to the requested resource.
     *         </li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>SNSException Base class for all service exceptions. Unknown exceptions will be thrown as an instance
     *         of this type.</li>
     *         </ul>
     * @sample SNSAsyncClient.DeletePlatformApplication
     * @see <a href="http://docs.aws.amazon.com/goto/WebAPI/sns-2010-03-31/DeletePlatformApplication" target="_top">AWS
     *      API Documentation</a>
     */
    default CompletableFuture<DeletePlatformApplicationResponse> deletePlatformApplication(
            Consumer<DeletePlatformApplicationRequest.Builder> deletePlatformApplicationRequest) {
        return deletePlatformApplication(DeletePlatformApplicationRequest.builder().apply(deletePlatformApplicationRequest)
                .build());
    }

    /**
     * <p>
     * Deletes a topic and all its subscriptions. Deleting a topic might prevent some messages previously sent to the
     * topic from being delivered to subscribers. This action is idempotent, so deleting a topic that does not exist
     * does not result in an error.
     * </p>
     *
     * @param deleteTopicRequest
     * @return A Java Future containing the result of the DeleteTopic operation returned by the service.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions.
     *         <ul>
     *         <li>InvalidParameterException Indicates that a request parameter does not comply with the associated
     *         constraints.</li>
     *         <li>InternalErrorException Indicates an internal service error.</li>
     *         <li>AuthorizationErrorException Indicates that the user has been denied access to the requested resource.
     *         </li>
     *         <li>NotFoundException Indicates that the requested resource does not exist.</li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>SNSException Base class for all service exceptions. Unknown exceptions will be thrown as an instance
     *         of this type.</li>
     *         </ul>
     * @sample SNSAsyncClient.DeleteTopic
     * @see <a href="http://docs.aws.amazon.com/goto/WebAPI/sns-2010-03-31/DeleteTopic" target="_top">AWS API
     *      Documentation</a>
     */
    default CompletableFuture<DeleteTopicResponse> deleteTopic(DeleteTopicRequest deleteTopicRequest) {
        throw new UnsupportedOperationException();
    }

    /**
     * <p>
     * Deletes a topic and all its subscriptions. Deleting a topic might prevent some messages previously sent to the
     * topic from being delivered to subscribers. This action is idempotent, so deleting a topic that does not exist
     * does not result in an error.
     * </p>
     * <br/>
     * This is a convenience which creates an instance of the {@link DeleteTopicRequest.Builder} avoiding the need to
     * create one manually via {@link DeleteTopicRequest#builder()}
     *
     * @param deleteTopicRequest
     *        a {@link Consumer} that will call methods on {@link DeleteTopicInput.Builder}.
     * @return A Java Future containing the result of the DeleteTopic operation returned by the service.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions.
     *         <ul>
     *         <li>InvalidParameterException Indicates that a request parameter does not comply with the associated
     *         constraints.</li>
     *         <li>InternalErrorException Indicates an internal service error.</li>
     *         <li>AuthorizationErrorException Indicates that the user has been denied access to the requested resource.
     *         </li>
     *         <li>NotFoundException Indicates that the requested resource does not exist.</li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>SNSException Base class for all service exceptions. Unknown exceptions will be thrown as an instance
     *         of this type.</li>
     *         </ul>
     * @sample SNSAsyncClient.DeleteTopic
     * @see <a href="http://docs.aws.amazon.com/goto/WebAPI/sns-2010-03-31/DeleteTopic" target="_top">AWS API
     *      Documentation</a>
     */
    default CompletableFuture<DeleteTopicResponse> deleteTopic(Consumer<DeleteTopicRequest.Builder> deleteTopicRequest) {
        return deleteTopic(DeleteTopicRequest.builder().apply(deleteTopicRequest).build());
    }

    /**
     * <p>
     * Retrieves the endpoint attributes for a device on one of the supported push notification services, such as GCM
     * and APNS. For more information, see <a href="http://docs.aws.amazon.com/sns/latest/dg/SNSMobilePush.html">Using
     * Amazon SNS Mobile Push Notifications</a>.
     * </p>
     *
     * @param getEndpointAttributesRequest
     *        Input for GetEndpointAttributes action.
     * @return A Java Future containing the result of the GetEndpointAttributes operation returned by the service.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions.
     *         <ul>
     *         <li>InvalidParameterException Indicates that a request parameter does not comply with the associated
     *         constraints.</li>
     *         <li>InternalErrorException Indicates an internal service error.</li>
     *         <li>AuthorizationErrorException Indicates that the user has been denied access to the requested resource.
     *         </li>
     *         <li>NotFoundException Indicates that the requested resource does not exist.</li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>SNSException Base class for all service exceptions. Unknown exceptions will be thrown as an instance
     *         of this type.</li>
     *         </ul>
     * @sample SNSAsyncClient.GetEndpointAttributes
     * @see <a href="http://docs.aws.amazon.com/goto/WebAPI/sns-2010-03-31/GetEndpointAttributes" target="_top">AWS API
     *      Documentation</a>
     */
    default CompletableFuture<GetEndpointAttributesResponse> getEndpointAttributes(
            GetEndpointAttributesRequest getEndpointAttributesRequest) {
        throw new UnsupportedOperationException();
    }

    /**
     * <p>
     * Retrieves the endpoint attributes for a device on one of the supported push notification services, such as GCM
     * and APNS. For more information, see <a href="http://docs.aws.amazon.com/sns/latest/dg/SNSMobilePush.html">Using
     * Amazon SNS Mobile Push Notifications</a>.
     * </p>
     * <br/>
     * This is a convenience which creates an instance of the {@link GetEndpointAttributesRequest.Builder} avoiding the
     * need to create one manually via {@link GetEndpointAttributesRequest#builder()}
     *
     * @param getEndpointAttributesRequest
     *        a {@link Consumer} that will call methods on {@link GetEndpointAttributesInput.Builder}.
     * @return A Java Future containing the result of the GetEndpointAttributes operation returned by the service.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions.
     *         <ul>
     *         <li>InvalidParameterException Indicates that a request parameter does not comply with the associated
     *         constraints.</li>
     *         <li>InternalErrorException Indicates an internal service error.</li>
     *         <li>AuthorizationErrorException Indicates that the user has been denied access to the requested resource.
     *         </li>
     *         <li>NotFoundException Indicates that the requested resource does not exist.</li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>SNSException Base class for all service exceptions. Unknown exceptions will be thrown as an instance
     *         of this type.</li>
     *         </ul>
     * @sample SNSAsyncClient.GetEndpointAttributes
     * @see <a href="http://docs.aws.amazon.com/goto/WebAPI/sns-2010-03-31/GetEndpointAttributes" target="_top">AWS API
     *      Documentation</a>
     */
    default CompletableFuture<GetEndpointAttributesResponse> getEndpointAttributes(
            Consumer<GetEndpointAttributesRequest.Builder> getEndpointAttributesRequest) {
        return getEndpointAttributes(GetEndpointAttributesRequest.builder().apply(getEndpointAttributesRequest).build());
    }

    /**
     * <p>
     * Retrieves the attributes of the platform application object for the supported push notification services, such as
     * APNS and GCM. For more information, see <a
     * href="http://docs.aws.amazon.com/sns/latest/dg/SNSMobilePush.html">Using Amazon SNS Mobile Push
     * Notifications</a>.
     * </p>
     *
     * @param getPlatformApplicationAttributesRequest
     *        Input for GetPlatformApplicationAttributes action.
     * @return A Java Future containing the result of the GetPlatformApplicationAttributes operation returned by the
     *         service.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions.
     *         <ul>
     *         <li>InvalidParameterException Indicates that a request parameter does not comply with the associated
     *         constraints.</li>
     *         <li>InternalErrorException Indicates an internal service error.</li>
     *         <li>AuthorizationErrorException Indicates that the user has been denied access to the requested resource.
     *         </li>
     *         <li>NotFoundException Indicates that the requested resource does not exist.</li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>SNSException Base class for all service exceptions. Unknown exceptions will be thrown as an instance
     *         of this type.</li>
     *         </ul>
     * @sample SNSAsyncClient.GetPlatformApplicationAttributes
     * @see <a href="http://docs.aws.amazon.com/goto/WebAPI/sns-2010-03-31/GetPlatformApplicationAttributes"
     *      target="_top">AWS API Documentation</a>
     */
    default CompletableFuture<GetPlatformApplicationAttributesResponse> getPlatformApplicationAttributes(
            GetPlatformApplicationAttributesRequest getPlatformApplicationAttributesRequest) {
        throw new UnsupportedOperationException();
    }

    /**
     * <p>
     * Retrieves the attributes of the platform application object for the supported push notification services, such as
     * APNS and GCM. For more information, see <a
     * href="http://docs.aws.amazon.com/sns/latest/dg/SNSMobilePush.html">Using Amazon SNS Mobile Push
     * Notifications</a>.
     * </p>
     * <br/>
     * This is a convenience which creates an instance of the {@link GetPlatformApplicationAttributesRequest.Builder}
     * avoiding the need to create one manually via {@link GetPlatformApplicationAttributesRequest#builder()}
     *
     * @param getPlatformApplicationAttributesRequest
     *        a {@link Consumer} that will call methods on {@link GetPlatformApplicationAttributesInput.Builder}.
     * @return A Java Future containing the result of the GetPlatformApplicationAttributes operation returned by the
     *         service.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions.
     *         <ul>
     *         <li>InvalidParameterException Indicates that a request parameter does not comply with the associated
     *         constraints.</li>
     *         <li>InternalErrorException Indicates an internal service error.</li>
     *         <li>AuthorizationErrorException Indicates that the user has been denied access to the requested resource.
     *         </li>
     *         <li>NotFoundException Indicates that the requested resource does not exist.</li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>SNSException Base class for all service exceptions. Unknown exceptions will be thrown as an instance
     *         of this type.</li>
     *         </ul>
     * @sample SNSAsyncClient.GetPlatformApplicationAttributes
     * @see <a href="http://docs.aws.amazon.com/goto/WebAPI/sns-2010-03-31/GetPlatformApplicationAttributes"
     *      target="_top">AWS API Documentation</a>
     */
    default CompletableFuture<GetPlatformApplicationAttributesResponse> getPlatformApplicationAttributes(
            Consumer<GetPlatformApplicationAttributesRequest.Builder> getPlatformApplicationAttributesRequest) {
        return getPlatformApplicationAttributes(GetPlatformApplicationAttributesRequest.builder()
                .apply(getPlatformApplicationAttributesRequest).build());
    }

    /**
     * <p>
     * Returns the settings for sending SMS messages from your account.
     * </p>
     * <p>
     * These settings are set with the <code>SetSMSAttributes</code> action.
     * </p>
     *
     * @param getSMSAttributesRequest
     *        The input for the <code>GetSMSAttributes</code> request.
     * @return A Java Future containing the result of the GetSMSAttributes operation returned by the service.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions.
     *         <ul>
     *         <li>ThrottledException Indicates that the rate at which requests have been submitted for this action
     *         exceeds the limit for your account.</li>
     *         <li>InternalErrorException Indicates an internal service error.</li>
     *         <li>AuthorizationErrorException Indicates that the user has been denied access to the requested resource.
     *         </li>
     *         <li>InvalidParameterException Indicates that a request parameter does not comply with the associated
     *         constraints.</li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>SNSException Base class for all service exceptions. Unknown exceptions will be thrown as an instance
     *         of this type.</li>
     *         </ul>
     * @sample SNSAsyncClient.GetSMSAttributes
     * @see <a href="http://docs.aws.amazon.com/goto/WebAPI/sns-2010-03-31/GetSMSAttributes" target="_top">AWS API
     *      Documentation</a>
     */
    default CompletableFuture<GetSMSAttributesResponse> getSMSAttributes(GetSMSAttributesRequest getSMSAttributesRequest) {
        throw new UnsupportedOperationException();
    }

    /**
     * <p>
     * Returns the settings for sending SMS messages from your account.
     * </p>
     * <p>
     * These settings are set with the <code>SetSMSAttributes</code> action.
     * </p>
     *
     * @return A Java Future containing the result of the GetSMSAttributes operation returned by the service.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions.
     *         <ul>
     *         <li>ThrottledException Indicates that the rate at which requests have been submitted for this action
     *         exceeds the limit for your account.</li>
     *         <li>InternalErrorException Indicates an internal service error.</li>
     *         <li>AuthorizationErrorException Indicates that the user has been denied access to the requested resource.
     *         </li>
     *         <li>InvalidParameterException Indicates that a request parameter does not comply with the associated
     *         constraints.</li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>SNSException Base class for all service exceptions. Unknown exceptions will be thrown as an instance
     *         of this type.</li>
     *         </ul>
     * @sample SNSAsyncClient.GetSMSAttributes
     * @see <a href="http://docs.aws.amazon.com/goto/WebAPI/sns-2010-03-31/GetSMSAttributes" target="_top">AWS API
     *      Documentation</a>
     */
    default CompletableFuture<GetSMSAttributesResponse> getSMSAttributes() {
        return getSMSAttributes(GetSMSAttributesRequest.builder().build());
    }

    /**
     * <p>
     * Returns the settings for sending SMS messages from your account.
     * </p>
     * <p>
     * These settings are set with the <code>SetSMSAttributes</code> action.
     * </p>
     * <br/>
     * This is a convenience which creates an instance of the {@link GetSMSAttributesRequest.Builder} avoiding the need
     * to create one manually via {@link GetSMSAttributesRequest#builder()}
     *
     * @param getSMSAttributesRequest
     *        a {@link Consumer} that will call methods on {@link GetSMSAttributesInput.Builder}.
     * @return A Java Future containing the result of the GetSMSAttributes operation returned by the service.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions.
     *         <ul>
     *         <li>ThrottledException Indicates that the rate at which requests have been submitted for this action
     *         exceeds the limit for your account.</li>
     *         <li>InternalErrorException Indicates an internal service error.</li>
     *         <li>AuthorizationErrorException Indicates that the user has been denied access to the requested resource.
     *         </li>
     *         <li>InvalidParameterException Indicates that a request parameter does not comply with the associated
     *         constraints.</li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>SNSException Base class for all service exceptions. Unknown exceptions will be thrown as an instance
     *         of this type.</li>
     *         </ul>
     * @sample SNSAsyncClient.GetSMSAttributes
     * @see <a href="http://docs.aws.amazon.com/goto/WebAPI/sns-2010-03-31/GetSMSAttributes" target="_top">AWS API
     *      Documentation</a>
     */
    default CompletableFuture<GetSMSAttributesResponse> getSMSAttributes(
            Consumer<GetSMSAttributesRequest.Builder> getSMSAttributesRequest) {
        return getSMSAttributes(GetSMSAttributesRequest.builder().apply(getSMSAttributesRequest).build());
    }

    /**
     * <p>
     * Returns all of the properties of a subscription.
     * </p>
     *
     * @param getSubscriptionAttributesRequest
     *        Input for GetSubscriptionAttributes.
     * @return A Java Future containing the result of the GetSubscriptionAttributes operation returned by the service.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions.
     *         <ul>
     *         <li>InvalidParameterException Indicates that a request parameter does not comply with the associated
     *         constraints.</li>
     *         <li>InternalErrorException Indicates an internal service error.</li>
     *         <li>NotFoundException Indicates that the requested resource does not exist.</li>
     *         <li>AuthorizationErrorException Indicates that the user has been denied access to the requested resource.
     *         </li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>SNSException Base class for all service exceptions. Unknown exceptions will be thrown as an instance
     *         of this type.</li>
     *         </ul>
     * @sample SNSAsyncClient.GetSubscriptionAttributes
     * @see <a href="http://docs.aws.amazon.com/goto/WebAPI/sns-2010-03-31/GetSubscriptionAttributes" target="_top">AWS
     *      API Documentation</a>
     */
    default CompletableFuture<GetSubscriptionAttributesResponse> getSubscriptionAttributes(
            GetSubscriptionAttributesRequest getSubscriptionAttributesRequest) {
        throw new UnsupportedOperationException();
    }

    /**
     * <p>
     * Returns all of the properties of a subscription.
     * </p>
     * <br/>
     * This is a convenience which creates an instance of the {@link GetSubscriptionAttributesRequest.Builder} avoiding
     * the need to create one manually via {@link GetSubscriptionAttributesRequest#builder()}
     *
     * @param getSubscriptionAttributesRequest
     *        a {@link Consumer} that will call methods on {@link GetSubscriptionAttributesInput.Builder}.
     * @return A Java Future containing the result of the GetSubscriptionAttributes operation returned by the service.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions.
     *         <ul>
     *         <li>InvalidParameterException Indicates that a request parameter does not comply with the associated
     *         constraints.</li>
     *         <li>InternalErrorException Indicates an internal service error.</li>
     *         <li>NotFoundException Indicates that the requested resource does not exist.</li>
     *         <li>AuthorizationErrorException Indicates that the user has been denied access to the requested resource.
     *         </li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>SNSException Base class for all service exceptions. Unknown exceptions will be thrown as an instance
     *         of this type.</li>
     *         </ul>
     * @sample SNSAsyncClient.GetSubscriptionAttributes
     * @see <a href="http://docs.aws.amazon.com/goto/WebAPI/sns-2010-03-31/GetSubscriptionAttributes" target="_top">AWS
     *      API Documentation</a>
     */
    default CompletableFuture<GetSubscriptionAttributesResponse> getSubscriptionAttributes(
            Consumer<GetSubscriptionAttributesRequest.Builder> getSubscriptionAttributesRequest) {
        return getSubscriptionAttributes(GetSubscriptionAttributesRequest.builder().apply(getSubscriptionAttributesRequest)
                .build());
    }

    /**
     * <p>
     * Returns all of the properties of a topic. Topic properties returned might differ based on the authorization of
     * the user.
     * </p>
     *
     * @param getTopicAttributesRequest
     *        Input for GetTopicAttributes action.
     * @return A Java Future containing the result of the GetTopicAttributes operation returned by the service.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions.
     *         <ul>
     *         <li>InvalidParameterException Indicates that a request parameter does not comply with the associated
     *         constraints.</li>
     *         <li>InternalErrorException Indicates an internal service error.</li>
     *         <li>NotFoundException Indicates that the requested resource does not exist.</li>
     *         <li>AuthorizationErrorException Indicates that the user has been denied access to the requested resource.
     *         </li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>SNSException Base class for all service exceptions. Unknown exceptions will be thrown as an instance
     *         of this type.</li>
     *         </ul>
     * @sample SNSAsyncClient.GetTopicAttributes
     * @see <a href="http://docs.aws.amazon.com/goto/WebAPI/sns-2010-03-31/GetTopicAttributes" target="_top">AWS API
     *      Documentation</a>
     */
    default CompletableFuture<GetTopicAttributesResponse> getTopicAttributes(GetTopicAttributesRequest getTopicAttributesRequest) {
        throw new UnsupportedOperationException();
    }

    /**
     * <p>
     * Returns all of the properties of a topic. Topic properties returned might differ based on the authorization of
     * the user.
     * </p>
     * <br/>
     * This is a convenience which creates an instance of the {@link GetTopicAttributesRequest.Builder} avoiding the
     * need to create one manually via {@link GetTopicAttributesRequest#builder()}
     *
     * @param getTopicAttributesRequest
     *        a {@link Consumer} that will call methods on {@link GetTopicAttributesInput.Builder}.
     * @return A Java Future containing the result of the GetTopicAttributes operation returned by the service.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions.
     *         <ul>
     *         <li>InvalidParameterException Indicates that a request parameter does not comply with the associated
     *         constraints.</li>
     *         <li>InternalErrorException Indicates an internal service error.</li>
     *         <li>NotFoundException Indicates that the requested resource does not exist.</li>
     *         <li>AuthorizationErrorException Indicates that the user has been denied access to the requested resource.
     *         </li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>SNSException Base class for all service exceptions. Unknown exceptions will be thrown as an instance
     *         of this type.</li>
     *         </ul>
     * @sample SNSAsyncClient.GetTopicAttributes
     * @see <a href="http://docs.aws.amazon.com/goto/WebAPI/sns-2010-03-31/GetTopicAttributes" target="_top">AWS API
     *      Documentation</a>
     */
    default CompletableFuture<GetTopicAttributesResponse> getTopicAttributes(
            Consumer<GetTopicAttributesRequest.Builder> getTopicAttributesRequest) {
        return getTopicAttributes(GetTopicAttributesRequest.builder().apply(getTopicAttributesRequest).build());
    }

    /**
     * <p>
     * Lists the endpoints and endpoint attributes for devices in a supported push notification service, such as GCM and
     * APNS. The results for <code>ListEndpointsByPlatformApplication</code> are paginated and return a limited list of
     * endpoints, up to 100. If additional records are available after the first page results, then a NextToken string
     * will be returned. To receive the next page, you call <code>ListEndpointsByPlatformApplication</code> again using
     * the NextToken string received from the previous call. When there are no more records to return, NextToken will be
     * null. For more information, see <a href="http://docs.aws.amazon.com/sns/latest/dg/SNSMobilePush.html">Using
     * Amazon SNS Mobile Push Notifications</a>.
     * </p>
     *
     * @param listEndpointsByPlatformApplicationRequest
     *        Input for ListEndpointsByPlatformApplication action.
     * @return A Java Future containing the result of the ListEndpointsByPlatformApplication operation returned by the
     *         service.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions.
     *         <ul>
     *         <li>InvalidParameterException Indicates that a request parameter does not comply with the associated
     *         constraints.</li>
     *         <li>InternalErrorException Indicates an internal service error.</li>
     *         <li>AuthorizationErrorException Indicates that the user has been denied access to the requested resource.
     *         </li>
     *         <li>NotFoundException Indicates that the requested resource does not exist.</li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>SNSException Base class for all service exceptions. Unknown exceptions will be thrown as an instance
     *         of this type.</li>
     *         </ul>
     * @sample SNSAsyncClient.ListEndpointsByPlatformApplication
     * @see <a href="http://docs.aws.amazon.com/goto/WebAPI/sns-2010-03-31/ListEndpointsByPlatformApplication"
     *      target="_top">AWS API Documentation</a>
     */
    default CompletableFuture<ListEndpointsByPlatformApplicationResponse> listEndpointsByPlatformApplication(
            ListEndpointsByPlatformApplicationRequest listEndpointsByPlatformApplicationRequest) {
        throw new UnsupportedOperationException();
    }

    /**
     * <p>
     * Lists the endpoints and endpoint attributes for devices in a supported push notification service, such as GCM and
     * APNS. The results for <code>ListEndpointsByPlatformApplication</code> are paginated and return a limited list of
     * endpoints, up to 100. If additional records are available after the first page results, then a NextToken string
     * will be returned. To receive the next page, you call <code>ListEndpointsByPlatformApplication</code> again using
     * the NextToken string received from the previous call. When there are no more records to return, NextToken will be
     * null. For more information, see <a href="http://docs.aws.amazon.com/sns/latest/dg/SNSMobilePush.html">Using
     * Amazon SNS Mobile Push Notifications</a>.
     * </p>
     * <br/>
     * This is a convenience which creates an instance of the {@link ListEndpointsByPlatformApplicationRequest.Builder}
     * avoiding the need to create one manually via {@link ListEndpointsByPlatformApplicationRequest#builder()}
     *
     * @param listEndpointsByPlatformApplicationRequest
     *        a {@link Consumer} that will call methods on {@link ListEndpointsByPlatformApplicationInput.Builder}.
     * @return A Java Future containing the result of the ListEndpointsByPlatformApplication operation returned by the
     *         service.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions.
     *         <ul>
     *         <li>InvalidParameterException Indicates that a request parameter does not comply with the associated
     *         constraints.</li>
     *         <li>InternalErrorException Indicates an internal service error.</li>
     *         <li>AuthorizationErrorException Indicates that the user has been denied access to the requested resource.
     *         </li>
     *         <li>NotFoundException Indicates that the requested resource does not exist.</li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>SNSException Base class for all service exceptions. Unknown exceptions will be thrown as an instance
     *         of this type.</li>
     *         </ul>
     * @sample SNSAsyncClient.ListEndpointsByPlatformApplication
     * @see <a href="http://docs.aws.amazon.com/goto/WebAPI/sns-2010-03-31/ListEndpointsByPlatformApplication"
     *      target="_top">AWS API Documentation</a>
     */
    default CompletableFuture<ListEndpointsByPlatformApplicationResponse> listEndpointsByPlatformApplication(
            Consumer<ListEndpointsByPlatformApplicationRequest.Builder> listEndpointsByPlatformApplicationRequest) {
        return listEndpointsByPlatformApplication(ListEndpointsByPlatformApplicationRequest.builder()
                .apply(listEndpointsByPlatformApplicationRequest).build());
    }

    /**
     * <p>
     * Returns a list of phone numbers that are opted out, meaning you cannot send SMS messages to them.
     * </p>
     * <p>
     * The results for <code>ListPhoneNumbersOptedOut</code> are paginated, and each page returns up to 100 phone
     * numbers. If additional phone numbers are available after the first page of results, then a <code>NextToken</code>
     * string will be returned. To receive the next page, you call <code>ListPhoneNumbersOptedOut</code> again using the
     * <code>NextToken</code> string received from the previous call. When there are no more records to return,
     * <code>NextToken</code> will be null.
     * </p>
     *
     * @param listPhoneNumbersOptedOutRequest
     *        The input for the <code>ListPhoneNumbersOptedOut</code> action.
     * @return A Java Future containing the result of the ListPhoneNumbersOptedOut operation returned by the service.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions.
     *         <ul>
     *         <li>ThrottledException Indicates that the rate at which requests have been submitted for this action
     *         exceeds the limit for your account.</li>
     *         <li>InternalErrorException Indicates an internal service error.</li>
     *         <li>AuthorizationErrorException Indicates that the user has been denied access to the requested resource.
     *         </li>
     *         <li>InvalidParameterException Indicates that a request parameter does not comply with the associated
     *         constraints.</li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>SNSException Base class for all service exceptions. Unknown exceptions will be thrown as an instance
     *         of this type.</li>
     *         </ul>
     * @sample SNSAsyncClient.ListPhoneNumbersOptedOut
     * @see <a href="http://docs.aws.amazon.com/goto/WebAPI/sns-2010-03-31/ListPhoneNumbersOptedOut" target="_top">AWS
     *      API Documentation</a>
     */
    default CompletableFuture<ListPhoneNumbersOptedOutResponse> listPhoneNumbersOptedOut(
            ListPhoneNumbersOptedOutRequest listPhoneNumbersOptedOutRequest) {
        throw new UnsupportedOperationException();
    }

    /**
     * <p>
     * Returns a list of phone numbers that are opted out, meaning you cannot send SMS messages to them.
     * </p>
     * <p>
     * The results for <code>ListPhoneNumbersOptedOut</code> are paginated, and each page returns up to 100 phone
     * numbers. If additional phone numbers are available after the first page of results, then a <code>NextToken</code>
     * string will be returned. To receive the next page, you call <code>ListPhoneNumbersOptedOut</code> again using the
     * <code>NextToken</code> string received from the previous call. When there are no more records to return,
     * <code>NextToken</code> will be null.
     * </p>
     *
     * @return A Java Future containing the result of the ListPhoneNumbersOptedOut operation returned by the service.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions.
     *         <ul>
     *         <li>ThrottledException Indicates that the rate at which requests have been submitted for this action
     *         exceeds the limit for your account.</li>
     *         <li>InternalErrorException Indicates an internal service error.</li>
     *         <li>AuthorizationErrorException Indicates that the user has been denied access to the requested resource.
     *         </li>
     *         <li>InvalidParameterException Indicates that a request parameter does not comply with the associated
     *         constraints.</li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>SNSException Base class for all service exceptions. Unknown exceptions will be thrown as an instance
     *         of this type.</li>
     *         </ul>
     * @sample SNSAsyncClient.ListPhoneNumbersOptedOut
     * @see <a href="http://docs.aws.amazon.com/goto/WebAPI/sns-2010-03-31/ListPhoneNumbersOptedOut" target="_top">AWS
     *      API Documentation</a>
     */
    default CompletableFuture<ListPhoneNumbersOptedOutResponse> listPhoneNumbersOptedOut() {
        return listPhoneNumbersOptedOut(ListPhoneNumbersOptedOutRequest.builder().build());
    }

    /**
     * <p>
     * Returns a list of phone numbers that are opted out, meaning you cannot send SMS messages to them.
     * </p>
     * <p>
     * The results for <code>ListPhoneNumbersOptedOut</code> are paginated, and each page returns up to 100 phone
     * numbers. If additional phone numbers are available after the first page of results, then a <code>NextToken</code>
     * string will be returned. To receive the next page, you call <code>ListPhoneNumbersOptedOut</code> again using the
     * <code>NextToken</code> string received from the previous call. When there are no more records to return,
     * <code>NextToken</code> will be null.
     * </p>
     * <br/>
     * This is a convenience which creates an instance of the {@link ListPhoneNumbersOptedOutRequest.Builder} avoiding
     * the need to create one manually via {@link ListPhoneNumbersOptedOutRequest#builder()}
     *
     * @param listPhoneNumbersOptedOutRequest
     *        a {@link Consumer} that will call methods on {@link ListPhoneNumbersOptedOutInput.Builder}.
     * @return A Java Future containing the result of the ListPhoneNumbersOptedOut operation returned by the service.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions.
     *         <ul>
     *         <li>ThrottledException Indicates that the rate at which requests have been submitted for this action
     *         exceeds the limit for your account.</li>
     *         <li>InternalErrorException Indicates an internal service error.</li>
     *         <li>AuthorizationErrorException Indicates that the user has been denied access to the requested resource.
     *         </li>
     *         <li>InvalidParameterException Indicates that a request parameter does not comply with the associated
     *         constraints.</li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>SNSException Base class for all service exceptions. Unknown exceptions will be thrown as an instance
     *         of this type.</li>
     *         </ul>
     * @sample SNSAsyncClient.ListPhoneNumbersOptedOut
     * @see <a href="http://docs.aws.amazon.com/goto/WebAPI/sns-2010-03-31/ListPhoneNumbersOptedOut" target="_top">AWS
     *      API Documentation</a>
     */
    default CompletableFuture<ListPhoneNumbersOptedOutResponse> listPhoneNumbersOptedOut(
            Consumer<ListPhoneNumbersOptedOutRequest.Builder> listPhoneNumbersOptedOutRequest) {
        return listPhoneNumbersOptedOut(ListPhoneNumbersOptedOutRequest.builder().apply(listPhoneNumbersOptedOutRequest).build());
    }

    /**
     * <p>
     * Lists the platform application objects for the supported push notification services, such as APNS and GCM. The
     * results for <code>ListPlatformApplications</code> are paginated and return a limited list of applications, up to
     * 100. If additional records are available after the first page results, then a NextToken string will be returned.
     * To receive the next page, you call <code>ListPlatformApplications</code> using the NextToken string received from
     * the previous call. When there are no more records to return, NextToken will be null. For more information, see <a
     * href="http://docs.aws.amazon.com/sns/latest/dg/SNSMobilePush.html">Using Amazon SNS Mobile Push
     * Notifications</a>.
     * </p>
     *
     * @param listPlatformApplicationsRequest
     *        Input for ListPlatformApplications action.
     * @return A Java Future containing the result of the ListPlatformApplications operation returned by the service.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions.
     *         <ul>
     *         <li>InvalidParameterException Indicates that a request parameter does not comply with the associated
     *         constraints.</li>
     *         <li>InternalErrorException Indicates an internal service error.</li>
     *         <li>AuthorizationErrorException Indicates that the user has been denied access to the requested resource.
     *         </li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>SNSException Base class for all service exceptions. Unknown exceptions will be thrown as an instance
     *         of this type.</li>
     *         </ul>
     * @sample SNSAsyncClient.ListPlatformApplications
     * @see <a href="http://docs.aws.amazon.com/goto/WebAPI/sns-2010-03-31/ListPlatformApplications" target="_top">AWS
     *      API Documentation</a>
     */
    default CompletableFuture<ListPlatformApplicationsResponse> listPlatformApplications(
            ListPlatformApplicationsRequest listPlatformApplicationsRequest) {
        throw new UnsupportedOperationException();
    }

    /**
     * <p>
     * Lists the platform application objects for the supported push notification services, such as APNS and GCM. The
     * results for <code>ListPlatformApplications</code> are paginated and return a limited list of applications, up to
     * 100. If additional records are available after the first page results, then a NextToken string will be returned.
     * To receive the next page, you call <code>ListPlatformApplications</code> using the NextToken string received from
     * the previous call. When there are no more records to return, NextToken will be null. For more information, see <a
     * href="http://docs.aws.amazon.com/sns/latest/dg/SNSMobilePush.html">Using Amazon SNS Mobile Push
     * Notifications</a>.
     * </p>
     *
     * @return A Java Future containing the result of the ListPlatformApplications operation returned by the service.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions.
     *         <ul>
     *         <li>InvalidParameterException Indicates that a request parameter does not comply with the associated
     *         constraints.</li>
     *         <li>InternalErrorException Indicates an internal service error.</li>
     *         <li>AuthorizationErrorException Indicates that the user has been denied access to the requested resource.
     *         </li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>SNSException Base class for all service exceptions. Unknown exceptions will be thrown as an instance
     *         of this type.</li>
     *         </ul>
     * @sample SNSAsyncClient.ListPlatformApplications
     * @see <a href="http://docs.aws.amazon.com/goto/WebAPI/sns-2010-03-31/ListPlatformApplications" target="_top">AWS
     *      API Documentation</a>
     */
    default CompletableFuture<ListPlatformApplicationsResponse> listPlatformApplications() {
        return listPlatformApplications(ListPlatformApplicationsRequest.builder().build());
    }

    /**
     * <p>
     * Lists the platform application objects for the supported push notification services, such as APNS and GCM. The
     * results for <code>ListPlatformApplications</code> are paginated and return a limited list of applications, up to
     * 100. If additional records are available after the first page results, then a NextToken string will be returned.
     * To receive the next page, you call <code>ListPlatformApplications</code> using the NextToken string received from
     * the previous call. When there are no more records to return, NextToken will be null. For more information, see <a
     * href="http://docs.aws.amazon.com/sns/latest/dg/SNSMobilePush.html">Using Amazon SNS Mobile Push
     * Notifications</a>.
     * </p>
     * <br/>
     * This is a convenience which creates an instance of the {@link ListPlatformApplicationsRequest.Builder} avoiding
     * the need to create one manually via {@link ListPlatformApplicationsRequest#builder()}
     *
     * @param listPlatformApplicationsRequest
     *        a {@link Consumer} that will call methods on {@link ListPlatformApplicationsInput.Builder}.
     * @return A Java Future containing the result of the ListPlatformApplications operation returned by the service.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions.
     *         <ul>
     *         <li>InvalidParameterException Indicates that a request parameter does not comply with the associated
     *         constraints.</li>
     *         <li>InternalErrorException Indicates an internal service error.</li>
     *         <li>AuthorizationErrorException Indicates that the user has been denied access to the requested resource.
     *         </li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>SNSException Base class for all service exceptions. Unknown exceptions will be thrown as an instance
     *         of this type.</li>
     *         </ul>
     * @sample SNSAsyncClient.ListPlatformApplications
     * @see <a href="http://docs.aws.amazon.com/goto/WebAPI/sns-2010-03-31/ListPlatformApplications" target="_top">AWS
     *      API Documentation</a>
     */
    default CompletableFuture<ListPlatformApplicationsResponse> listPlatformApplications(
            Consumer<ListPlatformApplicationsRequest.Builder> listPlatformApplicationsRequest) {
        return listPlatformApplications(ListPlatformApplicationsRequest.builder().apply(listPlatformApplicationsRequest).build());
    }

    /**
     * <p>
     * Returns a list of the requester's subscriptions. Each call returns a limited list of subscriptions, up to 100. If
     * there are more subscriptions, a <code>NextToken</code> is also returned. Use the <code>NextToken</code> parameter
     * in a new <code>ListSubscriptions</code> call to get further results.
     * </p>
     *
     * @param listSubscriptionsRequest
     *        Input for ListSubscriptions action.
     * @return A Java Future containing the result of the ListSubscriptions operation returned by the service.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions.
     *         <ul>
     *         <li>InvalidParameterException Indicates that a request parameter does not comply with the associated
     *         constraints.</li>
     *         <li>InternalErrorException Indicates an internal service error.</li>
     *         <li>AuthorizationErrorException Indicates that the user has been denied access to the requested resource.
     *         </li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>SNSException Base class for all service exceptions. Unknown exceptions will be thrown as an instance
     *         of this type.</li>
     *         </ul>
     * @sample SNSAsyncClient.ListSubscriptions
     * @see <a href="http://docs.aws.amazon.com/goto/WebAPI/sns-2010-03-31/ListSubscriptions" target="_top">AWS API
     *      Documentation</a>
     */
    default CompletableFuture<ListSubscriptionsResponse> listSubscriptions(ListSubscriptionsRequest listSubscriptionsRequest) {
        throw new UnsupportedOperationException();
    }

    /**
     * <p>
     * Returns a list of the requester's subscriptions. Each call returns a limited list of subscriptions, up to 100. If
     * there are more subscriptions, a <code>NextToken</code> is also returned. Use the <code>NextToken</code> parameter
     * in a new <code>ListSubscriptions</code> call to get further results.
     * </p>
     *
     * @return A Java Future containing the result of the ListSubscriptions operation returned by the service.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions.
     *         <ul>
     *         <li>InvalidParameterException Indicates that a request parameter does not comply with the associated
     *         constraints.</li>
     *         <li>InternalErrorException Indicates an internal service error.</li>
     *         <li>AuthorizationErrorException Indicates that the user has been denied access to the requested resource.
     *         </li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>SNSException Base class for all service exceptions. Unknown exceptions will be thrown as an instance
     *         of this type.</li>
     *         </ul>
     * @sample SNSAsyncClient.ListSubscriptions
     * @see <a href="http://docs.aws.amazon.com/goto/WebAPI/sns-2010-03-31/ListSubscriptions" target="_top">AWS API
     *      Documentation</a>
     */
    default CompletableFuture<ListSubscriptionsResponse> listSubscriptions() {
        return listSubscriptions(ListSubscriptionsRequest.builder().build());
    }

    /**
     * <p>
     * Returns a list of the requester's subscriptions. Each call returns a limited list of subscriptions, up to 100. If
     * there are more subscriptions, a <code>NextToken</code> is also returned. Use the <code>NextToken</code> parameter
     * in a new <code>ListSubscriptions</code> call to get further results.
     * </p>
     * <br/>
     * This is a convenience which creates an instance of the {@link ListSubscriptionsRequest.Builder} avoiding the need
     * to create one manually via {@link ListSubscriptionsRequest#builder()}
     *
     * @param listSubscriptionsRequest
     *        a {@link Consumer} that will call methods on {@link ListSubscriptionsInput.Builder}.
     * @return A Java Future containing the result of the ListSubscriptions operation returned by the service.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions.
     *         <ul>
     *         <li>InvalidParameterException Indicates that a request parameter does not comply with the associated
     *         constraints.</li>
     *         <li>InternalErrorException Indicates an internal service error.</li>
     *         <li>AuthorizationErrorException Indicates that the user has been denied access to the requested resource.
     *         </li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>SNSException Base class for all service exceptions. Unknown exceptions will be thrown as an instance
     *         of this type.</li>
     *         </ul>
     * @sample SNSAsyncClient.ListSubscriptions
     * @see <a href="http://docs.aws.amazon.com/goto/WebAPI/sns-2010-03-31/ListSubscriptions" target="_top">AWS API
     *      Documentation</a>
     */
    default CompletableFuture<ListSubscriptionsResponse> listSubscriptions(
            Consumer<ListSubscriptionsRequest.Builder> listSubscriptionsRequest) {
        return listSubscriptions(ListSubscriptionsRequest.builder().apply(listSubscriptionsRequest).build());
    }

    /**
     * <p>
     * Returns a list of the subscriptions to a specific topic. Each call returns a limited list of subscriptions, up to
     * 100. If there are more subscriptions, a <code>NextToken</code> is also returned. Use the <code>NextToken</code>
     * parameter in a new <code>ListSubscriptionsByTopic</code> call to get further results.
     * </p>
     *
     * @param listSubscriptionsByTopicRequest
     *        Input for ListSubscriptionsByTopic action.
     * @return A Java Future containing the result of the ListSubscriptionsByTopic operation returned by the service.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions.
     *         <ul>
     *         <li>InvalidParameterException Indicates that a request parameter does not comply with the associated
     *         constraints.</li>
     *         <li>InternalErrorException Indicates an internal service error.</li>
     *         <li>NotFoundException Indicates that the requested resource does not exist.</li>
     *         <li>AuthorizationErrorException Indicates that the user has been denied access to the requested resource.
     *         </li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>SNSException Base class for all service exceptions. Unknown exceptions will be thrown as an instance
     *         of this type.</li>
     *         </ul>
     * @sample SNSAsyncClient.ListSubscriptionsByTopic
     * @see <a href="http://docs.aws.amazon.com/goto/WebAPI/sns-2010-03-31/ListSubscriptionsByTopic" target="_top">AWS
     *      API Documentation</a>
     */
    default CompletableFuture<ListSubscriptionsByTopicResponse> listSubscriptionsByTopic(
            ListSubscriptionsByTopicRequest listSubscriptionsByTopicRequest) {
        throw new UnsupportedOperationException();
    }

    /**
     * <p>
     * Returns a list of the subscriptions to a specific topic. Each call returns a limited list of subscriptions, up to
     * 100. If there are more subscriptions, a <code>NextToken</code> is also returned. Use the <code>NextToken</code>
     * parameter in a new <code>ListSubscriptionsByTopic</code> call to get further results.
     * </p>
     * <br/>
     * This is a convenience which creates an instance of the {@link ListSubscriptionsByTopicRequest.Builder} avoiding
     * the need to create one manually via {@link ListSubscriptionsByTopicRequest#builder()}
     *
     * @param listSubscriptionsByTopicRequest
     *        a {@link Consumer} that will call methods on {@link ListSubscriptionsByTopicInput.Builder}.
     * @return A Java Future containing the result of the ListSubscriptionsByTopic operation returned by the service.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions.
     *         <ul>
     *         <li>InvalidParameterException Indicates that a request parameter does not comply with the associated
     *         constraints.</li>
     *         <li>InternalErrorException Indicates an internal service error.</li>
     *         <li>NotFoundException Indicates that the requested resource does not exist.</li>
     *         <li>AuthorizationErrorException Indicates that the user has been denied access to the requested resource.
     *         </li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>SNSException Base class for all service exceptions. Unknown exceptions will be thrown as an instance
     *         of this type.</li>
     *         </ul>
     * @sample SNSAsyncClient.ListSubscriptionsByTopic
     * @see <a href="http://docs.aws.amazon.com/goto/WebAPI/sns-2010-03-31/ListSubscriptionsByTopic" target="_top">AWS
     *      API Documentation</a>
     */
    default CompletableFuture<ListSubscriptionsByTopicResponse> listSubscriptionsByTopic(
            Consumer<ListSubscriptionsByTopicRequest.Builder> listSubscriptionsByTopicRequest) {
        return listSubscriptionsByTopic(ListSubscriptionsByTopicRequest.builder().apply(listSubscriptionsByTopicRequest).build());
    }

    /**
     * <p>
     * Returns a list of the requester's topics. Each call returns a limited list of topics, up to 100. If there are
     * more topics, a <code>NextToken</code> is also returned. Use the <code>NextToken</code> parameter in a new
     * <code>ListTopics</code> call to get further results.
     * </p>
     *
     * @param listTopicsRequest
     * @return A Java Future containing the result of the ListTopics operation returned by the service.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions.
     *         <ul>
     *         <li>InvalidParameterException Indicates that a request parameter does not comply with the associated
     *         constraints.</li>
     *         <li>InternalErrorException Indicates an internal service error.</li>
     *         <li>AuthorizationErrorException Indicates that the user has been denied access to the requested resource.
     *         </li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>SNSException Base class for all service exceptions. Unknown exceptions will be thrown as an instance
     *         of this type.</li>
     *         </ul>
     * @sample SNSAsyncClient.ListTopics
     * @see <a href="http://docs.aws.amazon.com/goto/WebAPI/sns-2010-03-31/ListTopics" target="_top">AWS API
     *      Documentation</a>
     */
    default CompletableFuture<ListTopicsResponse> listTopics(ListTopicsRequest listTopicsRequest) {
        throw new UnsupportedOperationException();
    }

    /**
     * <p>
     * Returns a list of the requester's topics. Each call returns a limited list of topics, up to 100. If there are
     * more topics, a <code>NextToken</code> is also returned. Use the <code>NextToken</code> parameter in a new
     * <code>ListTopics</code> call to get further results.
     * </p>
     *
     * @return A Java Future containing the result of the ListTopics operation returned by the service.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions.
     *         <ul>
     *         <li>InvalidParameterException Indicates that a request parameter does not comply with the associated
     *         constraints.</li>
     *         <li>InternalErrorException Indicates an internal service error.</li>
     *         <li>AuthorizationErrorException Indicates that the user has been denied access to the requested resource.
     *         </li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>SNSException Base class for all service exceptions. Unknown exceptions will be thrown as an instance
     *         of this type.</li>
     *         </ul>
     * @sample SNSAsyncClient.ListTopics
     * @see <a href="http://docs.aws.amazon.com/goto/WebAPI/sns-2010-03-31/ListTopics" target="_top">AWS API
     *      Documentation</a>
     */
    default CompletableFuture<ListTopicsResponse> listTopics() {
        return listTopics(ListTopicsRequest.builder().build());
    }

    /**
     * <p>
     * Returns a list of the requester's topics. Each call returns a limited list of topics, up to 100. If there are
     * more topics, a <code>NextToken</code> is also returned. Use the <code>NextToken</code> parameter in a new
     * <code>ListTopics</code> call to get further results.
     * </p>
     * <br/>
     * This is a convenience which creates an instance of the {@link ListTopicsRequest.Builder} avoiding the need to
     * create one manually via {@link ListTopicsRequest#builder()}
     *
     * @param listTopicsRequest
     *        a {@link Consumer} that will call methods on {@link ListTopicsInput.Builder}.
     * @return A Java Future containing the result of the ListTopics operation returned by the service.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions.
     *         <ul>
     *         <li>InvalidParameterException Indicates that a request parameter does not comply with the associated
     *         constraints.</li>
     *         <li>InternalErrorException Indicates an internal service error.</li>
     *         <li>AuthorizationErrorException Indicates that the user has been denied access to the requested resource.
     *         </li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>SNSException Base class for all service exceptions. Unknown exceptions will be thrown as an instance
     *         of this type.</li>
     *         </ul>
     * @sample SNSAsyncClient.ListTopics
     * @see <a href="http://docs.aws.amazon.com/goto/WebAPI/sns-2010-03-31/ListTopics" target="_top">AWS API
     *      Documentation</a>
     */
    default CompletableFuture<ListTopicsResponse> listTopics(Consumer<ListTopicsRequest.Builder> listTopicsRequest) {
        return listTopics(ListTopicsRequest.builder().apply(listTopicsRequest).build());
    }

    /**
     * <p>
     * Use this request to opt in a phone number that is opted out, which enables you to resume sending SMS messages to
     * the number.
     * </p>
     * <p>
     * You can opt in a phone number only once every 30 days.
     * </p>
     *
     * @param optInPhoneNumberRequest
     *        Input for the OptInPhoneNumber action.
     * @return A Java Future containing the result of the OptInPhoneNumber operation returned by the service.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions.
     *         <ul>
     *         <li>ThrottledException Indicates that the rate at which requests have been submitted for this action
     *         exceeds the limit for your account.</li>
     *         <li>InternalErrorException Indicates an internal service error.</li>
     *         <li>AuthorizationErrorException Indicates that the user has been denied access to the requested resource.
     *         </li>
     *         <li>InvalidParameterException Indicates that a request parameter does not comply with the associated
     *         constraints.</li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>SNSException Base class for all service exceptions. Unknown exceptions will be thrown as an instance
     *         of this type.</li>
     *         </ul>
     * @sample SNSAsyncClient.OptInPhoneNumber
     * @see <a href="http://docs.aws.amazon.com/goto/WebAPI/sns-2010-03-31/OptInPhoneNumber" target="_top">AWS API
     *      Documentation</a>
     */
    default CompletableFuture<OptInPhoneNumberResponse> optInPhoneNumber(OptInPhoneNumberRequest optInPhoneNumberRequest) {
        throw new UnsupportedOperationException();
    }

    /**
     * <p>
     * Use this request to opt in a phone number that is opted out, which enables you to resume sending SMS messages to
     * the number.
     * </p>
     * <p>
     * You can opt in a phone number only once every 30 days.
     * </p>
     * <br/>
     * This is a convenience which creates an instance of the {@link OptInPhoneNumberRequest.Builder} avoiding the need
     * to create one manually via {@link OptInPhoneNumberRequest#builder()}
     *
     * @param optInPhoneNumberRequest
     *        a {@link Consumer} that will call methods on {@link OptInPhoneNumberInput.Builder}.
     * @return A Java Future containing the result of the OptInPhoneNumber operation returned by the service.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions.
     *         <ul>
     *         <li>ThrottledException Indicates that the rate at which requests have been submitted for this action
     *         exceeds the limit for your account.</li>
     *         <li>InternalErrorException Indicates an internal service error.</li>
     *         <li>AuthorizationErrorException Indicates that the user has been denied access to the requested resource.
     *         </li>
     *         <li>InvalidParameterException Indicates that a request parameter does not comply with the associated
     *         constraints.</li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>SNSException Base class for all service exceptions. Unknown exceptions will be thrown as an instance
     *         of this type.</li>
     *         </ul>
     * @sample SNSAsyncClient.OptInPhoneNumber
     * @see <a href="http://docs.aws.amazon.com/goto/WebAPI/sns-2010-03-31/OptInPhoneNumber" target="_top">AWS API
     *      Documentation</a>
     */
    default CompletableFuture<OptInPhoneNumberResponse> optInPhoneNumber(
            Consumer<OptInPhoneNumberRequest.Builder> optInPhoneNumberRequest) {
        return optInPhoneNumber(OptInPhoneNumberRequest.builder().apply(optInPhoneNumberRequest).build());
    }

    /**
     * <p>
     * Sends a message to all of a topic's subscribed endpoints. When a <code>messageId</code> is returned, the message
     * has been saved and Amazon SNS will attempt to deliver it to the topic's subscribers shortly. The format of the
     * outgoing message to each subscribed endpoint depends on the notification protocol.
     * </p>
     * <p>
     * To use the <code>Publish</code> action for sending a message to a mobile endpoint, such as an app on a Kindle
     * device or mobile phone, you must specify the EndpointArn for the TargetArn parameter. The EndpointArn is returned
     * when making a call with the <code>CreatePlatformEndpoint</code> action.
     * </p>
     * <p>
     * For more information about formatting messages, see <a
     * href="http://docs.aws.amazon.com/sns/latest/dg/mobile-push-send-custommessage.html">Send Custom Platform-Specific
     * Payloads in Messages to Mobile Devices</a>.
     * </p>
     *
     * @param publishRequest
     *        Input for Publish action.
     * @return A Java Future containing the result of the Publish operation returned by the service.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions.
     *         <ul>
     *         <li>InvalidParameterException Indicates that a request parameter does not comply with the associated
     *         constraints.</li>
     *         <li>InvalidParameterValueException Indicates that a request parameter does not comply with the associated
     *         constraints.</li>
     *         <li>InternalErrorException Indicates an internal service error.</li>
     *         <li>NotFoundException Indicates that the requested resource does not exist.</li>
     *         <li>EndpointDisabledException Exception error indicating endpoint disabled.</li>
     *         <li>PlatformApplicationDisabledException Exception error indicating platform application disabled.</li>
     *         <li>AuthorizationErrorException Indicates that the user has been denied access to the requested resource.
     *         </li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>SNSException Base class for all service exceptions. Unknown exceptions will be thrown as an instance
     *         of this type.</li>
     *         </ul>
     * @sample SNSAsyncClient.Publish
     * @see <a href="http://docs.aws.amazon.com/goto/WebAPI/sns-2010-03-31/Publish" target="_top">AWS API
     *      Documentation</a>
     */
    default CompletableFuture<PublishResponse> publish(PublishRequest publishRequest) {
        throw new UnsupportedOperationException();
    }

    /**
     * <p>
     * Sends a message to all of a topic's subscribed endpoints. When a <code>messageId</code> is returned, the message
     * has been saved and Amazon SNS will attempt to deliver it to the topic's subscribers shortly. The format of the
     * outgoing message to each subscribed endpoint depends on the notification protocol.
     * </p>
     * <p>
     * To use the <code>Publish</code> action for sending a message to a mobile endpoint, such as an app on a Kindle
     * device or mobile phone, you must specify the EndpointArn for the TargetArn parameter. The EndpointArn is returned
     * when making a call with the <code>CreatePlatformEndpoint</code> action.
     * </p>
     * <p>
     * For more information about formatting messages, see <a
     * href="http://docs.aws.amazon.com/sns/latest/dg/mobile-push-send-custommessage.html">Send Custom Platform-Specific
     * Payloads in Messages to Mobile Devices</a>.
     * </p>
     * <br/>
     * This is a convenience which creates an instance of the {@link PublishRequest.Builder} avoiding the need to create
     * one manually via {@link PublishRequest#builder()}
     *
     * @param publishRequest
     *        a {@link Consumer} that will call methods on {@link PublishInput.Builder}.
     * @return A Java Future containing the result of the Publish operation returned by the service.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions.
     *         <ul>
     *         <li>InvalidParameterException Indicates that a request parameter does not comply with the associated
     *         constraints.</li>
     *         <li>InvalidParameterValueException Indicates that a request parameter does not comply with the associated
     *         constraints.</li>
     *         <li>InternalErrorException Indicates an internal service error.</li>
     *         <li>NotFoundException Indicates that the requested resource does not exist.</li>
     *         <li>EndpointDisabledException Exception error indicating endpoint disabled.</li>
     *         <li>PlatformApplicationDisabledException Exception error indicating platform application disabled.</li>
     *         <li>AuthorizationErrorException Indicates that the user has been denied access to the requested resource.
     *         </li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>SNSException Base class for all service exceptions. Unknown exceptions will be thrown as an instance
     *         of this type.</li>
     *         </ul>
     * @sample SNSAsyncClient.Publish
     * @see <a href="http://docs.aws.amazon.com/goto/WebAPI/sns-2010-03-31/Publish" target="_top">AWS API
     *      Documentation</a>
     */
    default CompletableFuture<PublishResponse> publish(Consumer<PublishRequest.Builder> publishRequest) {
        return publish(PublishRequest.builder().apply(publishRequest).build());
    }

    /**
     * <p>
     * Removes a statement from a topic's access control policy.
     * </p>
     *
     * @param removePermissionRequest
     *        Input for RemovePermission action.
     * @return A Java Future containing the result of the RemovePermission operation returned by the service.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions.
     *         <ul>
     *         <li>InvalidParameterException Indicates that a request parameter does not comply with the associated
     *         constraints.</li>
     *         <li>InternalErrorException Indicates an internal service error.</li>
     *         <li>AuthorizationErrorException Indicates that the user has been denied access to the requested resource.
     *         </li>
     *         <li>NotFoundException Indicates that the requested resource does not exist.</li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>SNSException Base class for all service exceptions. Unknown exceptions will be thrown as an instance
     *         of this type.</li>
     *         </ul>
     * @sample SNSAsyncClient.RemovePermission
     * @see <a href="http://docs.aws.amazon.com/goto/WebAPI/sns-2010-03-31/RemovePermission" target="_top">AWS API
     *      Documentation</a>
     */
    default CompletableFuture<RemovePermissionResponse> removePermission(RemovePermissionRequest removePermissionRequest) {
        throw new UnsupportedOperationException();
    }

    /**
     * <p>
     * Removes a statement from a topic's access control policy.
     * </p>
     * <br/>
     * This is a convenience which creates an instance of the {@link RemovePermissionRequest.Builder} avoiding the need
     * to create one manually via {@link RemovePermissionRequest#builder()}
     *
     * @param removePermissionRequest
     *        a {@link Consumer} that will call methods on {@link RemovePermissionInput.Builder}.
     * @return A Java Future containing the result of the RemovePermission operation returned by the service.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions.
     *         <ul>
     *         <li>InvalidParameterException Indicates that a request parameter does not comply with the associated
     *         constraints.</li>
     *         <li>InternalErrorException Indicates an internal service error.</li>
     *         <li>AuthorizationErrorException Indicates that the user has been denied access to the requested resource.
     *         </li>
     *         <li>NotFoundException Indicates that the requested resource does not exist.</li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>SNSException Base class for all service exceptions. Unknown exceptions will be thrown as an instance
     *         of this type.</li>
     *         </ul>
     * @sample SNSAsyncClient.RemovePermission
     * @see <a href="http://docs.aws.amazon.com/goto/WebAPI/sns-2010-03-31/RemovePermission" target="_top">AWS API
     *      Documentation</a>
     */
    default CompletableFuture<RemovePermissionResponse> removePermission(
            Consumer<RemovePermissionRequest.Builder> removePermissionRequest) {
        return removePermission(RemovePermissionRequest.builder().apply(removePermissionRequest).build());
    }

    /**
     * <p>
     * Sets the attributes for an endpoint for a device on one of the supported push notification services, such as GCM
     * and APNS. For more information, see <a href="http://docs.aws.amazon.com/sns/latest/dg/SNSMobilePush.html">Using
     * Amazon SNS Mobile Push Notifications</a>.
     * </p>
     *
     * @param setEndpointAttributesRequest
     *        Input for SetEndpointAttributes action.
     * @return A Java Future containing the result of the SetEndpointAttributes operation returned by the service.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions.
     *         <ul>
     *         <li>InvalidParameterException Indicates that a request parameter does not comply with the associated
     *         constraints.</li>
     *         <li>InternalErrorException Indicates an internal service error.</li>
     *         <li>AuthorizationErrorException Indicates that the user has been denied access to the requested resource.
     *         </li>
     *         <li>NotFoundException Indicates that the requested resource does not exist.</li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>SNSException Base class for all service exceptions. Unknown exceptions will be thrown as an instance
     *         of this type.</li>
     *         </ul>
     * @sample SNSAsyncClient.SetEndpointAttributes
     * @see <a href="http://docs.aws.amazon.com/goto/WebAPI/sns-2010-03-31/SetEndpointAttributes" target="_top">AWS API
     *      Documentation</a>
     */
    default CompletableFuture<SetEndpointAttributesResponse> setEndpointAttributes(
            SetEndpointAttributesRequest setEndpointAttributesRequest) {
        throw new UnsupportedOperationException();
    }

    /**
     * <p>
     * Sets the attributes for an endpoint for a device on one of the supported push notification services, such as GCM
     * and APNS. For more information, see <a href="http://docs.aws.amazon.com/sns/latest/dg/SNSMobilePush.html">Using
     * Amazon SNS Mobile Push Notifications</a>.
     * </p>
     * <br/>
     * This is a convenience which creates an instance of the {@link SetEndpointAttributesRequest.Builder} avoiding the
     * need to create one manually via {@link SetEndpointAttributesRequest#builder()}
     *
     * @param setEndpointAttributesRequest
     *        a {@link Consumer} that will call methods on {@link SetEndpointAttributesInput.Builder}.
     * @return A Java Future containing the result of the SetEndpointAttributes operation returned by the service.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions.
     *         <ul>
     *         <li>InvalidParameterException Indicates that a request parameter does not comply with the associated
     *         constraints.</li>
     *         <li>InternalErrorException Indicates an internal service error.</li>
     *         <li>AuthorizationErrorException Indicates that the user has been denied access to the requested resource.
     *         </li>
     *         <li>NotFoundException Indicates that the requested resource does not exist.</li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>SNSException Base class for all service exceptions. Unknown exceptions will be thrown as an instance
     *         of this type.</li>
     *         </ul>
     * @sample SNSAsyncClient.SetEndpointAttributes
     * @see <a href="http://docs.aws.amazon.com/goto/WebAPI/sns-2010-03-31/SetEndpointAttributes" target="_top">AWS API
     *      Documentation</a>
     */
    default CompletableFuture<SetEndpointAttributesResponse> setEndpointAttributes(
            Consumer<SetEndpointAttributesRequest.Builder> setEndpointAttributesRequest) {
        return setEndpointAttributes(SetEndpointAttributesRequest.builder().apply(setEndpointAttributesRequest).build());
    }

    /**
     * <p>
     * Sets the attributes of the platform application object for the supported push notification services, such as APNS
     * and GCM. For more information, see <a href="http://docs.aws.amazon.com/sns/latest/dg/SNSMobilePush.html">Using
     * Amazon SNS Mobile Push Notifications</a>. For information on configuring attributes for message delivery status,
     * see <a href="http://docs.aws.amazon.com/sns/latest/dg/sns-msg-status.html">Using Amazon SNS Application
     * Attributes for Message Delivery Status</a>.
     * </p>
     *
     * @param setPlatformApplicationAttributesRequest
     *        Input for SetPlatformApplicationAttributes action.
     * @return A Java Future containing the result of the SetPlatformApplicationAttributes operation returned by the
     *         service.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions.
     *         <ul>
     *         <li>InvalidParameterException Indicates that a request parameter does not comply with the associated
     *         constraints.</li>
     *         <li>InternalErrorException Indicates an internal service error.</li>
     *         <li>AuthorizationErrorException Indicates that the user has been denied access to the requested resource.
     *         </li>
     *         <li>NotFoundException Indicates that the requested resource does not exist.</li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>SNSException Base class for all service exceptions. Unknown exceptions will be thrown as an instance
     *         of this type.</li>
     *         </ul>
     * @sample SNSAsyncClient.SetPlatformApplicationAttributes
     * @see <a href="http://docs.aws.amazon.com/goto/WebAPI/sns-2010-03-31/SetPlatformApplicationAttributes"
     *      target="_top">AWS API Documentation</a>
     */
    default CompletableFuture<SetPlatformApplicationAttributesResponse> setPlatformApplicationAttributes(
            SetPlatformApplicationAttributesRequest setPlatformApplicationAttributesRequest) {
        throw new UnsupportedOperationException();
    }

    /**
     * <p>
     * Sets the attributes of the platform application object for the supported push notification services, such as APNS
     * and GCM. For more information, see <a href="http://docs.aws.amazon.com/sns/latest/dg/SNSMobilePush.html">Using
     * Amazon SNS Mobile Push Notifications</a>. For information on configuring attributes for message delivery status,
     * see <a href="http://docs.aws.amazon.com/sns/latest/dg/sns-msg-status.html">Using Amazon SNS Application
     * Attributes for Message Delivery Status</a>.
     * </p>
     * <br/>
     * This is a convenience which creates an instance of the {@link SetPlatformApplicationAttributesRequest.Builder}
     * avoiding the need to create one manually via {@link SetPlatformApplicationAttributesRequest#builder()}
     *
     * @param setPlatformApplicationAttributesRequest
     *        a {@link Consumer} that will call methods on {@link SetPlatformApplicationAttributesInput.Builder}.
     * @return A Java Future containing the result of the SetPlatformApplicationAttributes operation returned by the
     *         service.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions.
     *         <ul>
     *         <li>InvalidParameterException Indicates that a request parameter does not comply with the associated
     *         constraints.</li>
     *         <li>InternalErrorException Indicates an internal service error.</li>
     *         <li>AuthorizationErrorException Indicates that the user has been denied access to the requested resource.
     *         </li>
     *         <li>NotFoundException Indicates that the requested resource does not exist.</li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>SNSException Base class for all service exceptions. Unknown exceptions will be thrown as an instance
     *         of this type.</li>
     *         </ul>
     * @sample SNSAsyncClient.SetPlatformApplicationAttributes
     * @see <a href="http://docs.aws.amazon.com/goto/WebAPI/sns-2010-03-31/SetPlatformApplicationAttributes"
     *      target="_top">AWS API Documentation</a>
     */
    default CompletableFuture<SetPlatformApplicationAttributesResponse> setPlatformApplicationAttributes(
            Consumer<SetPlatformApplicationAttributesRequest.Builder> setPlatformApplicationAttributesRequest) {
        return setPlatformApplicationAttributes(SetPlatformApplicationAttributesRequest.builder()
                .apply(setPlatformApplicationAttributesRequest).build());
    }

    /**
     * <p>
     * Use this request to set the default settings for sending SMS messages and receiving daily SMS usage reports.
     * </p>
     * <p>
     * You can override some of these settings for a single message when you use the <code>Publish</code> action with
     * the <code>MessageAttributes.entry.N</code> parameter. For more information, see <a
     * href="http://docs.aws.amazon.com/sns/latest/dg/sms_publish-to-phone.html">Sending an SMS Message</a> in the
     * <i>Amazon SNS Developer Guide</i>.
     * </p>
     *
     * @param setSMSAttributesRequest
     *        The input for the SetSMSAttributes action.
     * @return A Java Future containing the result of the SetSMSAttributes operation returned by the service.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions.
     *         <ul>
     *         <li>InvalidParameterException Indicates that a request parameter does not comply with the associated
     *         constraints.</li>
     *         <li>ThrottledException Indicates that the rate at which requests have been submitted for this action
     *         exceeds the limit for your account.</li>
     *         <li>InternalErrorException Indicates an internal service error.</li>
     *         <li>AuthorizationErrorException Indicates that the user has been denied access to the requested resource.
     *         </li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>SNSException Base class for all service exceptions. Unknown exceptions will be thrown as an instance
     *         of this type.</li>
     *         </ul>
     * @sample SNSAsyncClient.SetSMSAttributes
     * @see <a href="http://docs.aws.amazon.com/goto/WebAPI/sns-2010-03-31/SetSMSAttributes" target="_top">AWS API
     *      Documentation</a>
     */
    default CompletableFuture<SetSMSAttributesResponse> setSMSAttributes(SetSMSAttributesRequest setSMSAttributesRequest) {
        throw new UnsupportedOperationException();
    }

    /**
     * <p>
     * Use this request to set the default settings for sending SMS messages and receiving daily SMS usage reports.
     * </p>
     * <p>
     * You can override some of these settings for a single message when you use the <code>Publish</code> action with
     * the <code>MessageAttributes.entry.N</code> parameter. For more information, see <a
     * href="http://docs.aws.amazon.com/sns/latest/dg/sms_publish-to-phone.html">Sending an SMS Message</a> in the
     * <i>Amazon SNS Developer Guide</i>.
     * </p>
     * <br/>
     * This is a convenience which creates an instance of the {@link SetSMSAttributesRequest.Builder} avoiding the need
     * to create one manually via {@link SetSMSAttributesRequest#builder()}
     *
     * @param setSMSAttributesRequest
     *        a {@link Consumer} that will call methods on {@link SetSMSAttributesInput.Builder}.
     * @return A Java Future containing the result of the SetSMSAttributes operation returned by the service.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions.
     *         <ul>
     *         <li>InvalidParameterException Indicates that a request parameter does not comply with the associated
     *         constraints.</li>
     *         <li>ThrottledException Indicates that the rate at which requests have been submitted for this action
     *         exceeds the limit for your account.</li>
     *         <li>InternalErrorException Indicates an internal service error.</li>
     *         <li>AuthorizationErrorException Indicates that the user has been denied access to the requested resource.
     *         </li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>SNSException Base class for all service exceptions. Unknown exceptions will be thrown as an instance
     *         of this type.</li>
     *         </ul>
     * @sample SNSAsyncClient.SetSMSAttributes
     * @see <a href="http://docs.aws.amazon.com/goto/WebAPI/sns-2010-03-31/SetSMSAttributes" target="_top">AWS API
     *      Documentation</a>
     */
    default CompletableFuture<SetSMSAttributesResponse> setSMSAttributes(
            Consumer<SetSMSAttributesRequest.Builder> setSMSAttributesRequest) {
        return setSMSAttributes(SetSMSAttributesRequest.builder().apply(setSMSAttributesRequest).build());
    }

    /**
     * <p>
     * Allows a subscription owner to set an attribute of the topic to a new value.
     * </p>
     *
     * @param setSubscriptionAttributesRequest
     *        Input for SetSubscriptionAttributes action.
     * @return A Java Future containing the result of the SetSubscriptionAttributes operation returned by the service.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions.
     *         <ul>
     *         <li>InvalidParameterException Indicates that a request parameter does not comply with the associated
     *         constraints.</li>
     *         <li>InternalErrorException Indicates an internal service error.</li>
     *         <li>NotFoundException Indicates that the requested resource does not exist.</li>
     *         <li>AuthorizationErrorException Indicates that the user has been denied access to the requested resource.
     *         </li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>SNSException Base class for all service exceptions. Unknown exceptions will be thrown as an instance
     *         of this type.</li>
     *         </ul>
     * @sample SNSAsyncClient.SetSubscriptionAttributes
     * @see <a href="http://docs.aws.amazon.com/goto/WebAPI/sns-2010-03-31/SetSubscriptionAttributes" target="_top">AWS
     *      API Documentation</a>
     */
    default CompletableFuture<SetSubscriptionAttributesResponse> setSubscriptionAttributes(
            SetSubscriptionAttributesRequest setSubscriptionAttributesRequest) {
        throw new UnsupportedOperationException();
    }

    /**
     * <p>
     * Allows a subscription owner to set an attribute of the topic to a new value.
     * </p>
     * <br/>
     * This is a convenience which creates an instance of the {@link SetSubscriptionAttributesRequest.Builder} avoiding
     * the need to create one manually via {@link SetSubscriptionAttributesRequest#builder()}
     *
     * @param setSubscriptionAttributesRequest
     *        a {@link Consumer} that will call methods on {@link SetSubscriptionAttributesInput.Builder}.
     * @return A Java Future containing the result of the SetSubscriptionAttributes operation returned by the service.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions.
     *         <ul>
     *         <li>InvalidParameterException Indicates that a request parameter does not comply with the associated
     *         constraints.</li>
     *         <li>InternalErrorException Indicates an internal service error.</li>
     *         <li>NotFoundException Indicates that the requested resource does not exist.</li>
     *         <li>AuthorizationErrorException Indicates that the user has been denied access to the requested resource.
     *         </li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>SNSException Base class for all service exceptions. Unknown exceptions will be thrown as an instance
     *         of this type.</li>
     *         </ul>
     * @sample SNSAsyncClient.SetSubscriptionAttributes
     * @see <a href="http://docs.aws.amazon.com/goto/WebAPI/sns-2010-03-31/SetSubscriptionAttributes" target="_top">AWS
     *      API Documentation</a>
     */
    default CompletableFuture<SetSubscriptionAttributesResponse> setSubscriptionAttributes(
            Consumer<SetSubscriptionAttributesRequest.Builder> setSubscriptionAttributesRequest) {
        return setSubscriptionAttributes(SetSubscriptionAttributesRequest.builder().apply(setSubscriptionAttributesRequest)
                .build());
    }

    /**
     * <p>
     * Allows a topic owner to set an attribute of the topic to a new value.
     * </p>
     *
     * @param setTopicAttributesRequest
     *        Input for SetTopicAttributes action.
     * @return A Java Future containing the result of the SetTopicAttributes operation returned by the service.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions.
     *         <ul>
     *         <li>InvalidParameterException Indicates that a request parameter does not comply with the associated
     *         constraints.</li>
     *         <li>InternalErrorException Indicates an internal service error.</li>
     *         <li>NotFoundException Indicates that the requested resource does not exist.</li>
     *         <li>AuthorizationErrorException Indicates that the user has been denied access to the requested resource.
     *         </li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>SNSException Base class for all service exceptions. Unknown exceptions will be thrown as an instance
     *         of this type.</li>
     *         </ul>
     * @sample SNSAsyncClient.SetTopicAttributes
     * @see <a href="http://docs.aws.amazon.com/goto/WebAPI/sns-2010-03-31/SetTopicAttributes" target="_top">AWS API
     *      Documentation</a>
     */
    default CompletableFuture<SetTopicAttributesResponse> setTopicAttributes(SetTopicAttributesRequest setTopicAttributesRequest) {
        throw new UnsupportedOperationException();
    }

    /**
     * <p>
     * Allows a topic owner to set an attribute of the topic to a new value.
     * </p>
     * <br/>
     * This is a convenience which creates an instance of the {@link SetTopicAttributesRequest.Builder} avoiding the
     * need to create one manually via {@link SetTopicAttributesRequest#builder()}
     *
     * @param setTopicAttributesRequest
     *        a {@link Consumer} that will call methods on {@link SetTopicAttributesInput.Builder}.
     * @return A Java Future containing the result of the SetTopicAttributes operation returned by the service.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions.
     *         <ul>
     *         <li>InvalidParameterException Indicates that a request parameter does not comply with the associated
     *         constraints.</li>
     *         <li>InternalErrorException Indicates an internal service error.</li>
     *         <li>NotFoundException Indicates that the requested resource does not exist.</li>
     *         <li>AuthorizationErrorException Indicates that the user has been denied access to the requested resource.
     *         </li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>SNSException Base class for all service exceptions. Unknown exceptions will be thrown as an instance
     *         of this type.</li>
     *         </ul>
     * @sample SNSAsyncClient.SetTopicAttributes
     * @see <a href="http://docs.aws.amazon.com/goto/WebAPI/sns-2010-03-31/SetTopicAttributes" target="_top">AWS API
     *      Documentation</a>
     */
    default CompletableFuture<SetTopicAttributesResponse> setTopicAttributes(
            Consumer<SetTopicAttributesRequest.Builder> setTopicAttributesRequest) {
        return setTopicAttributes(SetTopicAttributesRequest.builder().apply(setTopicAttributesRequest).build());
    }

    /**
     * <p>
     * Prepares to subscribe an endpoint by sending the endpoint a confirmation message. To actually create a
     * subscription, the endpoint owner must call the <code>ConfirmSubscription</code> action with the token from the
     * confirmation message. Confirmation tokens are valid for three days.
     * </p>
     *
     * @param subscribeRequest
     *        Input for Subscribe action.
     * @return A Java Future containing the result of the Subscribe operation returned by the service.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions.
     *         <ul>
     *         <li>SubscriptionLimitExceededException Indicates that the customer already owns the maximum allowed
     *         number of subscriptions.</li>
     *         <li>InvalidParameterException Indicates that a request parameter does not comply with the associated
     *         constraints.</li>
     *         <li>InternalErrorException Indicates an internal service error.</li>
     *         <li>NotFoundException Indicates that the requested resource does not exist.</li>
     *         <li>AuthorizationErrorException Indicates that the user has been denied access to the requested resource.
     *         </li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>SNSException Base class for all service exceptions. Unknown exceptions will be thrown as an instance
     *         of this type.</li>
     *         </ul>
     * @sample SNSAsyncClient.Subscribe
     * @see <a href="http://docs.aws.amazon.com/goto/WebAPI/sns-2010-03-31/Subscribe" target="_top">AWS API
     *      Documentation</a>
     */
    default CompletableFuture<SubscribeResponse> subscribe(SubscribeRequest subscribeRequest) {
        throw new UnsupportedOperationException();
    }

    /**
     * <p>
     * Prepares to subscribe an endpoint by sending the endpoint a confirmation message. To actually create a
     * subscription, the endpoint owner must call the <code>ConfirmSubscription</code> action with the token from the
     * confirmation message. Confirmation tokens are valid for three days.
     * </p>
     * <br/>
     * This is a convenience which creates an instance of the {@link SubscribeRequest.Builder} avoiding the need to
     * create one manually via {@link SubscribeRequest#builder()}
     *
     * @param subscribeRequest
     *        a {@link Consumer} that will call methods on {@link SubscribeInput.Builder}.
     * @return A Java Future containing the result of the Subscribe operation returned by the service.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions.
     *         <ul>
     *         <li>SubscriptionLimitExceededException Indicates that the customer already owns the maximum allowed
     *         number of subscriptions.</li>
     *         <li>InvalidParameterException Indicates that a request parameter does not comply with the associated
     *         constraints.</li>
     *         <li>InternalErrorException Indicates an internal service error.</li>
     *         <li>NotFoundException Indicates that the requested resource does not exist.</li>
     *         <li>AuthorizationErrorException Indicates that the user has been denied access to the requested resource.
     *         </li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>SNSException Base class for all service exceptions. Unknown exceptions will be thrown as an instance
     *         of this type.</li>
     *         </ul>
     * @sample SNSAsyncClient.Subscribe
     * @see <a href="http://docs.aws.amazon.com/goto/WebAPI/sns-2010-03-31/Subscribe" target="_top">AWS API
     *      Documentation</a>
     */
    default CompletableFuture<SubscribeResponse> subscribe(Consumer<SubscribeRequest.Builder> subscribeRequest) {
        return subscribe(SubscribeRequest.builder().apply(subscribeRequest).build());
    }

    /**
     * <p>
     * Deletes a subscription. If the subscription requires authentication for deletion, only the owner of the
     * subscription or the topic's owner can unsubscribe, and an AWS signature is required. If the
     * <code>Unsubscribe</code> call does not require authentication and the requester is not the subscription owner, a
     * final cancellation message is delivered to the endpoint, so that the endpoint owner can easily resubscribe to the
     * topic if the <code>Unsubscribe</code> request was unintended.
     * </p>
     *
     * @param unsubscribeRequest
     *        Input for Unsubscribe action.
     * @return A Java Future containing the result of the Unsubscribe operation returned by the service.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions.
     *         <ul>
     *         <li>InvalidParameterException Indicates that a request parameter does not comply with the associated
     *         constraints.</li>
     *         <li>InternalErrorException Indicates an internal service error.</li>
     *         <li>AuthorizationErrorException Indicates that the user has been denied access to the requested resource.
     *         </li>
     *         <li>NotFoundException Indicates that the requested resource does not exist.</li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>SNSException Base class for all service exceptions. Unknown exceptions will be thrown as an instance
     *         of this type.</li>
     *         </ul>
     * @sample SNSAsyncClient.Unsubscribe
     * @see <a href="http://docs.aws.amazon.com/goto/WebAPI/sns-2010-03-31/Unsubscribe" target="_top">AWS API
     *      Documentation</a>
     */
    default CompletableFuture<UnsubscribeResponse> unsubscribe(UnsubscribeRequest unsubscribeRequest) {
        throw new UnsupportedOperationException();
    }

    /**
     * <p>
     * Deletes a subscription. If the subscription requires authentication for deletion, only the owner of the
     * subscription or the topic's owner can unsubscribe, and an AWS signature is required. If the
     * <code>Unsubscribe</code> call does not require authentication and the requester is not the subscription owner, a
     * final cancellation message is delivered to the endpoint, so that the endpoint owner can easily resubscribe to the
     * topic if the <code>Unsubscribe</code> request was unintended.
     * </p>
     * <br/>
     * This is a convenience which creates an instance of the {@link UnsubscribeRequest.Builder} avoiding the need to
     * create one manually via {@link UnsubscribeRequest#builder()}
     *
     * @param unsubscribeRequest
     *        a {@link Consumer} that will call methods on {@link UnsubscribeInput.Builder}.
     * @return A Java Future containing the result of the Unsubscribe operation returned by the service.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions.
     *         <ul>
     *         <li>InvalidParameterException Indicates that a request parameter does not comply with the associated
     *         constraints.</li>
     *         <li>InternalErrorException Indicates an internal service error.</li>
     *         <li>AuthorizationErrorException Indicates that the user has been denied access to the requested resource.
     *         </li>
     *         <li>NotFoundException Indicates that the requested resource does not exist.</li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>SNSException Base class for all service exceptions. Unknown exceptions will be thrown as an instance
     *         of this type.</li>
     *         </ul>
     * @sample SNSAsyncClient.Unsubscribe
     * @see <a href="http://docs.aws.amazon.com/goto/WebAPI/sns-2010-03-31/Unsubscribe" target="_top">AWS API
     *      Documentation</a>
     */
    default CompletableFuture<UnsubscribeResponse> unsubscribe(Consumer<UnsubscribeRequest.Builder> unsubscribeRequest) {
        return unsubscribe(UnsubscribeRequest.builder().apply(unsubscribeRequest).build());
    }
}
