/*
 * Copyright 2012-2017 Amazon.com, Inc. or its affiliates. All Rights Reserved.
 * 
 * Licensed under the Apache License, Version 2.0 (the "License"). You may not use this file except in compliance with
 * the License. A copy of the License is located at
 * 
 * http://aws.amazon.com/apache2.0
 * 
 * or in the "license" file accompanying this file. This file is distributed on an "AS IS" BASIS, WITHOUT WARRANTIES OR
 * CONDITIONS OF ANY KIND, either express or implied. See the License for the specific language governing permissions
 * and limitations under the License.
 */

package software.amazon.awssdk.services.sns.model;

import java.util.Objects;
import java.util.Optional;
import java.util.function.Consumer;
import javax.annotation.Generated;
import software.amazon.awssdk.core.AwsRequestOverrideConfig;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

/**
 * <p>
 * The input for the <code>CheckIfPhoneNumberIsOptedOut</code> action.
 * </p>
 */
@Generated("software.amazon.awssdk:codegen")
public class CheckIfPhoneNumberIsOptedOutRequest extends SNSRequest implements
        ToCopyableBuilder<CheckIfPhoneNumberIsOptedOutRequest.Builder, CheckIfPhoneNumberIsOptedOutRequest> {
    private final String phoneNumber;

    private CheckIfPhoneNumberIsOptedOutRequest(BuilderImpl builder) {
        super(builder);
        this.phoneNumber = builder.phoneNumber;
    }

    /**
     * <p>
     * The phone number for which you want to check the opt out status.
     * </p>
     * 
     * @return The phone number for which you want to check the opt out status.
     */
    public String phoneNumber() {
        return phoneNumber;
    }

    @Override
    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    @Override
    public int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + Objects.hashCode(phoneNumber());
        return hashCode;
    }

    @Override
    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof CheckIfPhoneNumberIsOptedOutRequest)) {
            return false;
        }
        CheckIfPhoneNumberIsOptedOutRequest other = (CheckIfPhoneNumberIsOptedOutRequest) obj;
        return Objects.equals(phoneNumber(), other.phoneNumber());
    }

    @Override
    public String toString() {
        StringBuilder sb = new StringBuilder("{");
        if (phoneNumber() != null) {
            sb.append("PhoneNumber: ").append(phoneNumber()).append(",");
        }
        if (sb.length() > 1) {
            sb.setLength(sb.length() - 1);
        }
        sb.append("}");
        return sb.toString();
    }

    public <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
        case "phoneNumber":
            return Optional.of(clazz.cast(phoneNumber()));
        default:
            return Optional.empty();
        }
    }

    public interface Builder extends SNSRequest.Builder, CopyableBuilder<Builder, CheckIfPhoneNumberIsOptedOutRequest> {
        /**
         * <p>
         * The phone number for which you want to check the opt out status.
         * </p>
         * 
         * @param phoneNumber
         *        The phone number for which you want to check the opt out status.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder phoneNumber(String phoneNumber);

        @Override
        Builder requestOverrideConfig(AwsRequestOverrideConfig awsRequestOverrideConfig);
    }

    static final class BuilderImpl extends SNSRequest.BuilderImpl implements Builder {
        private String phoneNumber;

        private BuilderImpl() {
        }

        private BuilderImpl(CheckIfPhoneNumberIsOptedOutRequest model) {
            phoneNumber(model.phoneNumber);
        }

        public final String getPhoneNumber() {
            return phoneNumber;
        }

        @Override
        public final Builder phoneNumber(String phoneNumber) {
            this.phoneNumber = phoneNumber;
            return this;
        }

        public final void setPhoneNumber(String phoneNumber) {
            this.phoneNumber = phoneNumber;
        }

        @Override
        public Builder requestOverrideConfig(AwsRequestOverrideConfig awsRequestOverrideConfig) {
            super.requestOverrideConfig(awsRequestOverrideConfig);
            return this;
        }

        @Override
        public Builder requestOverrideConfig(Consumer<AwsRequestOverrideConfig.Builder> builderConsumer) {
            super.requestOverrideConfig(builderConsumer);
            return this;
        }

        @Override
        public CheckIfPhoneNumberIsOptedOutRequest build() {
            return new CheckIfPhoneNumberIsOptedOutRequest(this);
        }
    }
}
