/*
 * Copyright 2012-2017 Amazon.com, Inc. or its affiliates. All Rights Reserved.
 * 
 * Licensed under the Apache License, Version 2.0 (the "License"). You may not use this file except in compliance with
 * the License. A copy of the License is located at
 * 
 * http://aws.amazon.com/apache2.0
 * 
 * or in the "license" file accompanying this file. This file is distributed on an "AS IS" BASIS, WITHOUT WARRANTIES OR
 * CONDITIONS OF ANY KIND, either express or implied. See the License for the specific language governing permissions
 * and limitations under the License.
 */

package software.amazon.awssdk.services.sns.model;

import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.function.Consumer;
import javax.annotation.Generated;
import software.amazon.awssdk.core.AwsRequestOverrideConfig;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

/**
 * <p>
 * Input for CreatePlatformApplication action.
 * </p>
 */
@Generated("software.amazon.awssdk:codegen")
public class CreatePlatformApplicationRequest extends SNSRequest implements
        ToCopyableBuilder<CreatePlatformApplicationRequest.Builder, CreatePlatformApplicationRequest> {
    private final String name;

    private final String platform;

    private final Map<String, String> attributes;

    private CreatePlatformApplicationRequest(BuilderImpl builder) {
        super(builder);
        this.name = builder.name;
        this.platform = builder.platform;
        this.attributes = builder.attributes;
    }

    /**
     * <p>
     * Application names must be made up of only uppercase and lowercase ASCII letters, numbers, underscores, hyphens,
     * and periods, and must be between 1 and 256 characters long.
     * </p>
     * 
     * @return Application names must be made up of only uppercase and lowercase ASCII letters, numbers, underscores,
     *         hyphens, and periods, and must be between 1 and 256 characters long.
     */
    public String name() {
        return name;
    }

    /**
     * <p>
     * The following platforms are supported: ADM (Amazon Device Messaging), APNS (Apple Push Notification Service),
     * APNS_SANDBOX, and GCM (Google Cloud Messaging).
     * </p>
     * 
     * @return The following platforms are supported: ADM (Amazon Device Messaging), APNS (Apple Push Notification
     *         Service), APNS_SANDBOX, and GCM (Google Cloud Messaging).
     */
    public String platform() {
        return platform;
    }

    /**
     * <p>
     * For a list of attributes, see <a
     * href="http://docs.aws.amazon.com/sns/latest/api/API_SetPlatformApplicationAttributes.html"
     * >SetPlatformApplicationAttributes</a>
     * </p>
     * <p>
     * Attempts to modify the collection returned by this method will result in an UnsupportedOperationException.
     * </p>
     * 
     * @return For a list of attributes, see <a
     *         href="http://docs.aws.amazon.com/sns/latest/api/API_SetPlatformApplicationAttributes.html"
     *         >SetPlatformApplicationAttributes</a>
     */
    public Map<String, String> attributes() {
        return attributes;
    }

    @Override
    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    @Override
    public int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + Objects.hashCode(name());
        hashCode = 31 * hashCode + Objects.hashCode(platform());
        hashCode = 31 * hashCode + Objects.hashCode(attributes());
        return hashCode;
    }

    @Override
    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof CreatePlatformApplicationRequest)) {
            return false;
        }
        CreatePlatformApplicationRequest other = (CreatePlatformApplicationRequest) obj;
        return Objects.equals(name(), other.name()) && Objects.equals(platform(), other.platform())
                && Objects.equals(attributes(), other.attributes());
    }

    @Override
    public String toString() {
        StringBuilder sb = new StringBuilder("{");
        if (name() != null) {
            sb.append("Name: ").append(name()).append(",");
        }
        if (platform() != null) {
            sb.append("Platform: ").append(platform()).append(",");
        }
        if (attributes() != null) {
            sb.append("Attributes: ").append(attributes()).append(",");
        }
        if (sb.length() > 1) {
            sb.setLength(sb.length() - 1);
        }
        sb.append("}");
        return sb.toString();
    }

    public <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
        case "Name":
            return Optional.of(clazz.cast(name()));
        case "Platform":
            return Optional.of(clazz.cast(platform()));
        case "Attributes":
            return Optional.of(clazz.cast(attributes()));
        default:
            return Optional.empty();
        }
    }

    public interface Builder extends SNSRequest.Builder, CopyableBuilder<Builder, CreatePlatformApplicationRequest> {
        /**
         * <p>
         * Application names must be made up of only uppercase and lowercase ASCII letters, numbers, underscores,
         * hyphens, and periods, and must be between 1 and 256 characters long.
         * </p>
         * 
         * @param name
         *        Application names must be made up of only uppercase and lowercase ASCII letters, numbers, underscores,
         *        hyphens, and periods, and must be between 1 and 256 characters long.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder name(String name);

        /**
         * <p>
         * The following platforms are supported: ADM (Amazon Device Messaging), APNS (Apple Push Notification Service),
         * APNS_SANDBOX, and GCM (Google Cloud Messaging).
         * </p>
         * 
         * @param platform
         *        The following platforms are supported: ADM (Amazon Device Messaging), APNS (Apple Push Notification
         *        Service), APNS_SANDBOX, and GCM (Google Cloud Messaging).
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder platform(String platform);

        /**
         * <p>
         * For a list of attributes, see <a
         * href="http://docs.aws.amazon.com/sns/latest/api/API_SetPlatformApplicationAttributes.html"
         * >SetPlatformApplicationAttributes</a>
         * </p>
         * 
         * @param attributes
         *        For a list of attributes, see <a
         *        href="http://docs.aws.amazon.com/sns/latest/api/API_SetPlatformApplicationAttributes.html"
         *        >SetPlatformApplicationAttributes</a>
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder attributes(Map<String, String> attributes);

        @Override
        Builder requestOverrideConfig(AwsRequestOverrideConfig awsRequestOverrideConfig);
    }

    static final class BuilderImpl extends SNSRequest.BuilderImpl implements Builder {
        private String name;

        private String platform;

        private Map<String, String> attributes;

        private BuilderImpl() {
        }

        private BuilderImpl(CreatePlatformApplicationRequest model) {
            name(model.name);
            platform(model.platform);
            attributes(model.attributes);
        }

        public final String getName() {
            return name;
        }

        @Override
        public final Builder name(String name) {
            this.name = name;
            return this;
        }

        public final void setName(String name) {
            this.name = name;
        }

        public final String getPlatform() {
            return platform;
        }

        @Override
        public final Builder platform(String platform) {
            this.platform = platform;
            return this;
        }

        public final void setPlatform(String platform) {
            this.platform = platform;
        }

        public final Map<String, String> getAttributes() {
            return attributes;
        }

        @Override
        public final Builder attributes(Map<String, String> attributes) {
            this.attributes = MapStringToStringCopier.copy(attributes);
            return this;
        }

        public final void setAttributes(Map<String, String> attributes) {
            this.attributes = MapStringToStringCopier.copy(attributes);
        }

        @Override
        public Builder requestOverrideConfig(AwsRequestOverrideConfig awsRequestOverrideConfig) {
            super.requestOverrideConfig(awsRequestOverrideConfig);
            return this;
        }

        @Override
        public Builder requestOverrideConfig(Consumer<AwsRequestOverrideConfig.Builder> builderConsumer) {
            super.requestOverrideConfig(builderConsumer);
            return this;
        }

        @Override
        public CreatePlatformApplicationRequest build() {
            return new CreatePlatformApplicationRequest(this);
        }
    }
}
