/*
 * Copyright 2012-2017 Amazon.com, Inc. or its affiliates. All Rights Reserved.
 * 
 * Licensed under the Apache License, Version 2.0 (the "License"). You may not use this file except in compliance with
 * the License. A copy of the License is located at
 * 
 * http://aws.amazon.com/apache2.0
 * 
 * or in the "license" file accompanying this file. This file is distributed on an "AS IS" BASIS, WITHOUT WARRANTIES OR
 * CONDITIONS OF ANY KIND, either express or implied. See the License for the specific language governing permissions
 * and limitations under the License.
 */

package software.amazon.awssdk.services.sns.model;

import java.util.Objects;
import java.util.Optional;
import java.util.function.Consumer;
import javax.annotation.Generated;
import software.amazon.awssdk.core.AwsRequestOverrideConfig;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

/**
 * <p>
 * Input for DeletePlatformApplication action.
 * </p>
 */
@Generated("software.amazon.awssdk:codegen")
public class DeletePlatformApplicationRequest extends SNSRequest implements
        ToCopyableBuilder<DeletePlatformApplicationRequest.Builder, DeletePlatformApplicationRequest> {
    private final String platformApplicationArn;

    private DeletePlatformApplicationRequest(BuilderImpl builder) {
        super(builder);
        this.platformApplicationArn = builder.platformApplicationArn;
    }

    /**
     * <p>
     * PlatformApplicationArn of platform application object to delete.
     * </p>
     * 
     * @return PlatformApplicationArn of platform application object to delete.
     */
    public String platformApplicationArn() {
        return platformApplicationArn;
    }

    @Override
    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    @Override
    public int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + Objects.hashCode(platformApplicationArn());
        return hashCode;
    }

    @Override
    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof DeletePlatformApplicationRequest)) {
            return false;
        }
        DeletePlatformApplicationRequest other = (DeletePlatformApplicationRequest) obj;
        return Objects.equals(platformApplicationArn(), other.platformApplicationArn());
    }

    @Override
    public String toString() {
        StringBuilder sb = new StringBuilder("{");
        if (platformApplicationArn() != null) {
            sb.append("PlatformApplicationArn: ").append(platformApplicationArn()).append(",");
        }
        if (sb.length() > 1) {
            sb.setLength(sb.length() - 1);
        }
        sb.append("}");
        return sb.toString();
    }

    public <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
        case "PlatformApplicationArn":
            return Optional.of(clazz.cast(platformApplicationArn()));
        default:
            return Optional.empty();
        }
    }

    public interface Builder extends SNSRequest.Builder, CopyableBuilder<Builder, DeletePlatformApplicationRequest> {
        /**
         * <p>
         * PlatformApplicationArn of platform application object to delete.
         * </p>
         * 
         * @param platformApplicationArn
         *        PlatformApplicationArn of platform application object to delete.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder platformApplicationArn(String platformApplicationArn);

        @Override
        Builder requestOverrideConfig(AwsRequestOverrideConfig awsRequestOverrideConfig);
    }

    static final class BuilderImpl extends SNSRequest.BuilderImpl implements Builder {
        private String platformApplicationArn;

        private BuilderImpl() {
        }

        private BuilderImpl(DeletePlatformApplicationRequest model) {
            platformApplicationArn(model.platformApplicationArn);
        }

        public final String getPlatformApplicationArn() {
            return platformApplicationArn;
        }

        @Override
        public final Builder platformApplicationArn(String platformApplicationArn) {
            this.platformApplicationArn = platformApplicationArn;
            return this;
        }

        public final void setPlatformApplicationArn(String platformApplicationArn) {
            this.platformApplicationArn = platformApplicationArn;
        }

        @Override
        public Builder requestOverrideConfig(AwsRequestOverrideConfig awsRequestOverrideConfig) {
            super.requestOverrideConfig(awsRequestOverrideConfig);
            return this;
        }

        @Override
        public Builder requestOverrideConfig(Consumer<AwsRequestOverrideConfig.Builder> builderConsumer) {
            super.requestOverrideConfig(builderConsumer);
            return this;
        }

        @Override
        public DeletePlatformApplicationRequest build() {
            return new DeletePlatformApplicationRequest(this);
        }
    }
}
