/*
 * Copyright 2012-2017 Amazon.com, Inc. or its affiliates. All Rights Reserved.
 * 
 * Licensed under the Apache License, Version 2.0 (the "License"). You may not use this file except in compliance with
 * the License. A copy of the License is located at
 * 
 * http://aws.amazon.com/apache2.0
 * 
 * or in the "license" file accompanying this file. This file is distributed on an "AS IS" BASIS, WITHOUT WARRANTIES OR
 * CONDITIONS OF ANY KIND, either express or implied. See the License for the specific language governing permissions
 * and limitations under the License.
 */

package software.amazon.awssdk.services.sns.model;

import java.util.Arrays;
import java.util.Collection;
import java.util.List;
import java.util.Objects;
import java.util.Optional;
import java.util.function.Consumer;
import javax.annotation.Generated;
import software.amazon.awssdk.core.AwsRequestOverrideConfig;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

/**
 * <p>
 * The input for the <code>GetSMSAttributes</code> request.
 * </p>
 */
@Generated("software.amazon.awssdk:codegen")
public class GetSMSAttributesRequest extends SNSRequest implements
        ToCopyableBuilder<GetSMSAttributesRequest.Builder, GetSMSAttributesRequest> {
    private final List<String> attributes;

    private GetSMSAttributesRequest(BuilderImpl builder) {
        super(builder);
        this.attributes = builder.attributes;
    }

    /**
     * <p>
     * A list of the individual attribute names, such as <code>MonthlySpendLimit</code>, for which you want values.
     * </p>
     * <p>
     * For all attribute names, see <a
     * href="http://docs.aws.amazon.com/sns/latest/api/API_SetSMSAttributes.html">SetSMSAttributes</a>.
     * </p>
     * <p>
     * If you don't use this parameter, Amazon SNS returns all SMS attributes.
     * </p>
     * <p>
     * Attempts to modify the collection returned by this method will result in an UnsupportedOperationException.
     * </p>
     * 
     * @return A list of the individual attribute names, such as <code>MonthlySpendLimit</code>, for which you want
     *         values.</p>
     *         <p>
     *         For all attribute names, see <a
     *         href="http://docs.aws.amazon.com/sns/latest/api/API_SetSMSAttributes.html">SetSMSAttributes</a>.
     *         </p>
     *         <p>
     *         If you don't use this parameter, Amazon SNS returns all SMS attributes.
     */
    public List<String> attributes() {
        return attributes;
    }

    @Override
    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    @Override
    public int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + Objects.hashCode(attributes());
        return hashCode;
    }

    @Override
    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof GetSMSAttributesRequest)) {
            return false;
        }
        GetSMSAttributesRequest other = (GetSMSAttributesRequest) obj;
        return Objects.equals(attributes(), other.attributes());
    }

    @Override
    public String toString() {
        StringBuilder sb = new StringBuilder("{");
        if (attributes() != null) {
            sb.append("Attributes: ").append(attributes()).append(",");
        }
        if (sb.length() > 1) {
            sb.setLength(sb.length() - 1);
        }
        sb.append("}");
        return sb.toString();
    }

    public <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
        case "attributes":
            return Optional.of(clazz.cast(attributes()));
        default:
            return Optional.empty();
        }
    }

    public interface Builder extends SNSRequest.Builder, CopyableBuilder<Builder, GetSMSAttributesRequest> {
        /**
         * <p>
         * A list of the individual attribute names, such as <code>MonthlySpendLimit</code>, for which you want values.
         * </p>
         * <p>
         * For all attribute names, see <a
         * href="http://docs.aws.amazon.com/sns/latest/api/API_SetSMSAttributes.html">SetSMSAttributes</a>.
         * </p>
         * <p>
         * If you don't use this parameter, Amazon SNS returns all SMS attributes.
         * </p>
         * 
         * @param attributes
         *        A list of the individual attribute names, such as <code>MonthlySpendLimit</code>, for which you want
         *        values.</p>
         *        <p>
         *        For all attribute names, see <a
         *        href="http://docs.aws.amazon.com/sns/latest/api/API_SetSMSAttributes.html">SetSMSAttributes</a>.
         *        </p>
         *        <p>
         *        If you don't use this parameter, Amazon SNS returns all SMS attributes.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder attributes(Collection<String> attributes);

        /**
         * <p>
         * A list of the individual attribute names, such as <code>MonthlySpendLimit</code>, for which you want values.
         * </p>
         * <p>
         * For all attribute names, see <a
         * href="http://docs.aws.amazon.com/sns/latest/api/API_SetSMSAttributes.html">SetSMSAttributes</a>.
         * </p>
         * <p>
         * If you don't use this parameter, Amazon SNS returns all SMS attributes.
         * </p>
         * 
         * @param attributes
         *        A list of the individual attribute names, such as <code>MonthlySpendLimit</code>, for which you want
         *        values.</p>
         *        <p>
         *        For all attribute names, see <a
         *        href="http://docs.aws.amazon.com/sns/latest/api/API_SetSMSAttributes.html">SetSMSAttributes</a>.
         *        </p>
         *        <p>
         *        If you don't use this parameter, Amazon SNS returns all SMS attributes.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder attributes(String... attributes);

        @Override
        Builder requestOverrideConfig(AwsRequestOverrideConfig awsRequestOverrideConfig);
    }

    static final class BuilderImpl extends SNSRequest.BuilderImpl implements Builder {
        private List<String> attributes;

        private BuilderImpl() {
        }

        private BuilderImpl(GetSMSAttributesRequest model) {
            attributes(model.attributes);
        }

        public final Collection<String> getAttributes() {
            return attributes;
        }

        @Override
        public final Builder attributes(Collection<String> attributes) {
            this.attributes = ListStringCopier.copy(attributes);
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder attributes(String... attributes) {
            attributes(Arrays.asList(attributes));
            return this;
        }

        public final void setAttributes(Collection<String> attributes) {
            this.attributes = ListStringCopier.copy(attributes);
        }

        @Override
        public Builder requestOverrideConfig(AwsRequestOverrideConfig awsRequestOverrideConfig) {
            super.requestOverrideConfig(awsRequestOverrideConfig);
            return this;
        }

        @Override
        public Builder requestOverrideConfig(Consumer<AwsRequestOverrideConfig.Builder> builderConsumer) {
            super.requestOverrideConfig(builderConsumer);
            return this;
        }

        @Override
        public GetSMSAttributesRequest build() {
            return new GetSMSAttributesRequest(this);
        }
    }
}
