/*
 * Copyright 2012-2017 Amazon.com, Inc. or its affiliates. All Rights Reserved.
 * 
 * Licensed under the Apache License, Version 2.0 (the "License"). You may not use this file except in compliance with
 * the License. A copy of the License is located at
 * 
 * http://aws.amazon.com/apache2.0
 * 
 * or in the "license" file accompanying this file. This file is distributed on an "AS IS" BASIS, WITHOUT WARRANTIES OR
 * CONDITIONS OF ANY KIND, either express or implied. See the License for the specific language governing permissions
 * and limitations under the License.
 */

package software.amazon.awssdk.services.sns.transform;

import javax.xml.stream.events.XMLEvent;
import javax.annotation.Generated;

import software.amazon.awssdk.services.sns.model.*;
import software.amazon.awssdk.core.runtime.transform.Unmarshaller;

import software.amazon.awssdk.core.runtime.transform.StaxUnmarshallerContext;
import software.amazon.awssdk.core.runtime.transform.SimpleTypeStaxUnmarshallers.*;

/**
 * ConfirmSubscriptionResponse StAX Unmarshaller
 */

@Generated("software.amazon.awssdk:aws-java-sdk-code-generator")
public class ConfirmSubscriptionResponseUnmarshaller implements
        Unmarshaller<ConfirmSubscriptionResponse, StaxUnmarshallerContext> {

    public ConfirmSubscriptionResponse unmarshall(StaxUnmarshallerContext context) throws Exception {
        ConfirmSubscriptionResponse.Builder confirmSubscriptionResponse = ConfirmSubscriptionResponse.builder();
        int originalDepth = context.getCurrentDepth();
        int targetDepth = originalDepth + 1;

        if (context.isStartOfDocument())
            targetDepth += 2;

        while (true) {
            XMLEvent xmlEvent = context.nextEvent();
            if (xmlEvent.isEndDocument()) {
                break;
            }

            if (xmlEvent.isAttribute() || xmlEvent.isStartElement()) {

                if (context.testExpression("SubscriptionArn", targetDepth)) {
                    confirmSubscriptionResponse.subscriptionArn(StringUnmarshaller.getInstance().unmarshall(context));
                    continue;
                }
            } else if (xmlEvent.isEndElement()) {
                if (context.getCurrentDepth() < originalDepth) {
                    break;
                }
            }
        }
        return confirmSubscriptionResponse.build();
    }

    private static final ConfirmSubscriptionResponseUnmarshaller INSTANCE = new ConfirmSubscriptionResponseUnmarshaller();

    public static ConfirmSubscriptionResponseUnmarshaller getInstance() {
        return INSTANCE;
    }
}
