/*
 * Copyright 2012-2017 Amazon.com, Inc. or its affiliates. All Rights Reserved.
 * 
 * Licensed under the Apache License, Version 2.0 (the "License"). You may not use this file except in compliance with
 * the License. A copy of the License is located at
 * 
 * http://aws.amazon.com/apache2.0
 * 
 * or in the "license" file accompanying this file. This file is distributed on an "AS IS" BASIS, WITHOUT WARRANTIES OR
 * CONDITIONS OF ANY KIND, either express or implied. See the License for the specific language governing permissions
 * and limitations under the License.
 */

package software.amazon.awssdk.services.sns.transform;

import java.util.Map;
import javax.annotation.Generated;

import software.amazon.awssdk.core.exception.SdkClientException;
import software.amazon.awssdk.core.Request;
import software.amazon.awssdk.core.DefaultRequest;
import software.amazon.awssdk.core.http.HttpMethodName;
import software.amazon.awssdk.services.sns.model.*;
import software.amazon.awssdk.core.runtime.transform.Marshaller;
import software.amazon.awssdk.core.util.StringUtils;

/**
 * CreatePlatformEndpointRequest Marshaller
 */

@Generated("software.amazon.awssdk:aws-java-sdk-code-generator")
public class CreatePlatformEndpointRequestMarshaller implements
        Marshaller<Request<CreatePlatformEndpointRequest>, CreatePlatformEndpointRequest> {

    public Request<CreatePlatformEndpointRequest> marshall(CreatePlatformEndpointRequest createPlatformEndpointRequest) {

        if (createPlatformEndpointRequest == null) {
            throw new SdkClientException("Invalid argument passed to marshall(...)");
        }

        Request<CreatePlatformEndpointRequest> request = new DefaultRequest<CreatePlatformEndpointRequest>(
                createPlatformEndpointRequest, "SNSClient");
        request.addParameter("Action", "CreatePlatformEndpoint");
        request.addParameter("Version", "2010-03-31");
        request.setHttpMethod(HttpMethodName.POST);

        if (createPlatformEndpointRequest.platformApplicationArn() != null) {
            request.addParameter("PlatformApplicationArn",
                    StringUtils.fromString(createPlatformEndpointRequest.platformApplicationArn()));
        }

        if (createPlatformEndpointRequest.token() != null) {
            request.addParameter("Token", StringUtils.fromString(createPlatformEndpointRequest.token()));
        }

        if (createPlatformEndpointRequest.customUserData() != null) {
            request.addParameter("CustomUserData", StringUtils.fromString(createPlatformEndpointRequest.customUserData()));
        }

        java.util.Map<String, String> attributes = createPlatformEndpointRequest.attributes();

        if (attributes != null) {
            int attributesListIndex = 1;
            for (Map.Entry<String, String> entry : attributes.entrySet()) {
                if (entry.getKey() != null) {
                    request.addParameter("Attributes.entry." + attributesListIndex + ".key",
                            StringUtils.fromString(entry.getKey()));
                }
                if (entry.getValue() != null) {
                    request.addParameter("Attributes.entry." + attributesListIndex + ".value",
                            StringUtils.fromString(entry.getValue()));
                }
                attributesListIndex++;
            }
        }

        return request;
    }

}
