/*
 * Copyright 2012-2017 Amazon.com, Inc. or its affiliates. All Rights Reserved.
 * 
 * Licensed under the Apache License, Version 2.0 (the "License"). You may not use this file except in compliance with
 * the License. A copy of the License is located at
 * 
 * http://aws.amazon.com/apache2.0
 * 
 * or in the "license" file accompanying this file. This file is distributed on an "AS IS" BASIS, WITHOUT WARRANTIES OR
 * CONDITIONS OF ANY KIND, either express or implied. See the License for the specific language governing permissions
 * and limitations under the License.
 */

package software.amazon.awssdk.services.sns.transform;

import javax.annotation.Generated;

import software.amazon.awssdk.core.exception.SdkClientException;
import software.amazon.awssdk.core.Request;
import software.amazon.awssdk.core.DefaultRequest;
import software.amazon.awssdk.core.http.HttpMethodName;
import software.amazon.awssdk.services.sns.model.*;
import software.amazon.awssdk.core.runtime.transform.Marshaller;
import software.amazon.awssdk.core.util.StringUtils;

/**
 * GetSubscriptionAttributesRequest Marshaller
 */

@Generated("software.amazon.awssdk:aws-java-sdk-code-generator")
public class GetSubscriptionAttributesRequestMarshaller implements
        Marshaller<Request<GetSubscriptionAttributesRequest>, GetSubscriptionAttributesRequest> {

    public Request<GetSubscriptionAttributesRequest> marshall(GetSubscriptionAttributesRequest getSubscriptionAttributesRequest) {

        if (getSubscriptionAttributesRequest == null) {
            throw new SdkClientException("Invalid argument passed to marshall(...)");
        }

        Request<GetSubscriptionAttributesRequest> request = new DefaultRequest<GetSubscriptionAttributesRequest>(
                getSubscriptionAttributesRequest, "SNSClient");
        request.addParameter("Action", "GetSubscriptionAttributes");
        request.addParameter("Version", "2010-03-31");
        request.setHttpMethod(HttpMethodName.POST);

        if (getSubscriptionAttributesRequest.subscriptionArn() != null) {
            request.addParameter("SubscriptionArn", StringUtils.fromString(getSubscriptionAttributesRequest.subscriptionArn()));
        }

        return request;
    }

}
