/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.sns;

import software.amazon.awssdk.annotations.SdkInternalApi;
import software.amazon.awssdk.core.auth.Aws4Signer;
import software.amazon.awssdk.core.auth.Signer;
import software.amazon.awssdk.core.auth.StaticSignerProvider;
import software.amazon.awssdk.core.client.builder.DefaultClientBuilder;
import software.amazon.awssdk.core.config.defaults.ClientConfigurationDefaults;
import software.amazon.awssdk.core.config.defaults.ServiceBuilderConfigurationDefaults;
import software.amazon.awssdk.core.runtime.auth.SignerProvider;
import software.amazon.awssdk.services.sns.SNSBaseClientBuilder;

@SdkInternalApi
abstract class DefaultSNSBaseClientBuilder<B extends SNSBaseClientBuilder<B, C>, C>
extends DefaultClientBuilder<B, C> {
    DefaultSNSBaseClientBuilder() {
    }

    protected final String serviceEndpointPrefix() {
        return "sns";
    }

    protected final ClientConfigurationDefaults serviceDefaults() {
        return ServiceBuilderConfigurationDefaults.builder().defaultSignerProvider(this::defaultSignerProvider).addRequestHandlerPath("software/amazon/awssdk/services/sns/execution.interceptors").crc32FromCompressedDataEnabled(Boolean.valueOf(false)).build();
    }

    private SignerProvider defaultSignerProvider() {
        Aws4Signer signer = new Aws4Signer();
        signer.setServiceName("sns");
        signer.setRegionName(this.signingRegion().value());
        return StaticSignerProvider.create((Signer)signer);
    }
}

