/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.sns.model;

import java.util.Objects;
import java.util.Optional;
import java.util.function.Consumer;
import software.amazon.awssdk.core.AwsRequestOverrideConfig;
import software.amazon.awssdk.services.sns.model.SNSRequest;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

public class SetTopicAttributesRequest
extends SNSRequest
implements ToCopyableBuilder<Builder, SetTopicAttributesRequest> {
    private final String topicArn;
    private final String attributeName;
    private final String attributeValue;

    private SetTopicAttributesRequest(BuilderImpl builder) {
        super(builder);
        this.topicArn = builder.topicArn;
        this.attributeName = builder.attributeName;
        this.attributeValue = builder.attributeValue;
    }

    public String topicArn() {
        return this.topicArn;
    }

    public String attributeName() {
        return this.attributeName;
    }

    public String attributeValue() {
        return this.attributeValue;
    }

    @Override
    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    public int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + Objects.hashCode(this.topicArn());
        hashCode = 31 * hashCode + Objects.hashCode(this.attributeName());
        hashCode = 31 * hashCode + Objects.hashCode(this.attributeValue());
        return hashCode;
    }

    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof SetTopicAttributesRequest)) {
            return false;
        }
        SetTopicAttributesRequest other = (SetTopicAttributesRequest)((Object)obj);
        return Objects.equals(this.topicArn(), other.topicArn()) && Objects.equals(this.attributeName(), other.attributeName()) && Objects.equals(this.attributeValue(), other.attributeValue());
    }

    public String toString() {
        StringBuilder sb = new StringBuilder("{");
        if (this.topicArn() != null) {
            sb.append("TopicArn: ").append(this.topicArn()).append(",");
        }
        if (this.attributeName() != null) {
            sb.append("AttributeName: ").append(this.attributeName()).append(",");
        }
        if (this.attributeValue() != null) {
            sb.append("AttributeValue: ").append(this.attributeValue()).append(",");
        }
        if (sb.length() > 1) {
            sb.setLength(sb.length() - 1);
        }
        sb.append("}");
        return sb.toString();
    }

    public <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
            case "TopicArn": {
                return Optional.of(clazz.cast(this.topicArn()));
            }
            case "AttributeName": {
                return Optional.of(clazz.cast(this.attributeName()));
            }
            case "AttributeValue": {
                return Optional.of(clazz.cast(this.attributeValue()));
            }
        }
        return Optional.empty();
    }

    static final class BuilderImpl
    extends SNSRequest.BuilderImpl
    implements Builder {
        private String topicArn;
        private String attributeName;
        private String attributeValue;

        private BuilderImpl() {
        }

        private BuilderImpl(SetTopicAttributesRequest model) {
            this.topicArn(model.topicArn);
            this.attributeName(model.attributeName);
            this.attributeValue(model.attributeValue);
        }

        public final String getTopicArn() {
            return this.topicArn;
        }

        @Override
        public final Builder topicArn(String topicArn) {
            this.topicArn = topicArn;
            return this;
        }

        public final void setTopicArn(String topicArn) {
            this.topicArn = topicArn;
        }

        public final String getAttributeName() {
            return this.attributeName;
        }

        @Override
        public final Builder attributeName(String attributeName) {
            this.attributeName = attributeName;
            return this;
        }

        public final void setAttributeName(String attributeName) {
            this.attributeName = attributeName;
        }

        public final String getAttributeValue() {
            return this.attributeValue;
        }

        @Override
        public final Builder attributeValue(String attributeValue) {
            this.attributeValue = attributeValue;
            return this;
        }

        public final void setAttributeValue(String attributeValue) {
            this.attributeValue = attributeValue;
        }

        @Override
        public Builder requestOverrideConfig(AwsRequestOverrideConfig awsRequestOverrideConfig) {
            super.requestOverrideConfig(awsRequestOverrideConfig);
            return this;
        }

        public Builder requestOverrideConfig(Consumer<AwsRequestOverrideConfig.Builder> builderConsumer) {
            super.requestOverrideConfig(builderConsumer);
            return this;
        }

        @Override
        public SetTopicAttributesRequest build() {
            return new SetTopicAttributesRequest(this);
        }
    }

    public static interface Builder
    extends SNSRequest.Builder,
    CopyableBuilder<Builder, SetTopicAttributesRequest> {
        public Builder topicArn(String var1);

        public Builder attributeName(String var1);

        public Builder attributeValue(String var1);

        public Builder requestOverrideConfig(AwsRequestOverrideConfig var1);
    }
}

