/*
 * Copyright 2013-2018 Amazon.com, Inc. or its affiliates. All Rights Reserved.
 * 
 * Licensed under the Apache License, Version 2.0 (the "License"). You may not use this file except in compliance with
 * the License. A copy of the License is located at
 * 
 * http://aws.amazon.com/apache2.0
 * 
 * or in the "license" file accompanying this file. This file is distributed on an "AS IS" BASIS, WITHOUT WARRANTIES OR
 * CONDITIONS OF ANY KIND, either express or implied. See the License for the specific language governing permissions
 * and limitations under the License.
 */

package software.amazon.awssdk.services.sns.model;

import java.util.Objects;
import java.util.Optional;
import java.util.function.Consumer;
import javax.annotation.Generated;
import software.amazon.awssdk.core.AwsRequestOverrideConfig;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

/**
 * <p>
 * Input for ListSubscriptionsByTopic action.
 * </p>
 */
@Generated("software.amazon.awssdk:codegen")
public class ListSubscriptionsByTopicRequest extends SNSRequest implements
        ToCopyableBuilder<ListSubscriptionsByTopicRequest.Builder, ListSubscriptionsByTopicRequest> {
    private final String topicArn;

    private final String nextToken;

    private ListSubscriptionsByTopicRequest(BuilderImpl builder) {
        super(builder);
        this.topicArn = builder.topicArn;
        this.nextToken = builder.nextToken;
    }

    /**
     * <p>
     * The ARN of the topic for which you wish to find subscriptions.
     * </p>
     * 
     * @return The ARN of the topic for which you wish to find subscriptions.
     */
    public String topicArn() {
        return topicArn;
    }

    /**
     * <p>
     * Token returned by the previous <code>ListSubscriptionsByTopic</code> request.
     * </p>
     * 
     * @return Token returned by the previous <code>ListSubscriptionsByTopic</code> request.
     */
    public String nextToken() {
        return nextToken;
    }

    @Override
    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    @Override
    public int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + Objects.hashCode(topicArn());
        hashCode = 31 * hashCode + Objects.hashCode(nextToken());
        return hashCode;
    }

    @Override
    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof ListSubscriptionsByTopicRequest)) {
            return false;
        }
        ListSubscriptionsByTopicRequest other = (ListSubscriptionsByTopicRequest) obj;
        return Objects.equals(topicArn(), other.topicArn()) && Objects.equals(nextToken(), other.nextToken());
    }

    @Override
    public String toString() {
        return ToString.builder("ListSubscriptionsByTopicRequest").add("TopicArn", topicArn()).add("NextToken", nextToken())
                .build();
    }

    public <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
        case "TopicArn":
            return Optional.of(clazz.cast(topicArn()));
        case "NextToken":
            return Optional.of(clazz.cast(nextToken()));
        default:
            return Optional.empty();
        }
    }

    public interface Builder extends SNSRequest.Builder, CopyableBuilder<Builder, ListSubscriptionsByTopicRequest> {
        /**
         * <p>
         * The ARN of the topic for which you wish to find subscriptions.
         * </p>
         * 
         * @param topicArn
         *        The ARN of the topic for which you wish to find subscriptions.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder topicArn(String topicArn);

        /**
         * <p>
         * Token returned by the previous <code>ListSubscriptionsByTopic</code> request.
         * </p>
         * 
         * @param nextToken
         *        Token returned by the previous <code>ListSubscriptionsByTopic</code> request.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder nextToken(String nextToken);

        @Override
        Builder requestOverrideConfig(AwsRequestOverrideConfig awsRequestOverrideConfig);
    }

    static final class BuilderImpl extends SNSRequest.BuilderImpl implements Builder {
        private String topicArn;

        private String nextToken;

        private BuilderImpl() {
        }

        private BuilderImpl(ListSubscriptionsByTopicRequest model) {
            topicArn(model.topicArn);
            nextToken(model.nextToken);
        }

        public final String getTopicArn() {
            return topicArn;
        }

        @Override
        public final Builder topicArn(String topicArn) {
            this.topicArn = topicArn;
            return this;
        }

        public final void setTopicArn(String topicArn) {
            this.topicArn = topicArn;
        }

        public final String getNextToken() {
            return nextToken;
        }

        @Override
        public final Builder nextToken(String nextToken) {
            this.nextToken = nextToken;
            return this;
        }

        public final void setNextToken(String nextToken) {
            this.nextToken = nextToken;
        }

        @Override
        public Builder requestOverrideConfig(AwsRequestOverrideConfig awsRequestOverrideConfig) {
            super.requestOverrideConfig(awsRequestOverrideConfig);
            return this;
        }

        @Override
        public Builder requestOverrideConfig(Consumer<AwsRequestOverrideConfig.Builder> builderConsumer) {
            super.requestOverrideConfig(builderConsumer);
            return this;
        }

        @Override
        public ListSubscriptionsByTopicRequest build() {
            return new ListSubscriptionsByTopicRequest(this);
        }
    }
}
