/*
 * Copyright 2013-2018 Amazon.com, Inc. or its affiliates. All Rights Reserved.
 * 
 * Licensed under the Apache License, Version 2.0 (the "License"). You may not use this file except in compliance with
 * the License. A copy of the License is located at
 * 
 * http://aws.amazon.com/apache2.0
 * 
 * or in the "license" file accompanying this file. This file is distributed on an "AS IS" BASIS, WITHOUT WARRANTIES OR
 * CONDITIONS OF ANY KIND, either express or implied. See the License for the specific language governing permissions
 * and limitations under the License.
 */

package software.amazon.awssdk.services.sns.model;

import java.util.Arrays;
import java.util.Collection;
import java.util.List;
import java.util.Objects;
import java.util.Optional;
import java.util.stream.Collectors;
import javax.annotation.Generated;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

/**
 * <p>
 * Response for ListTopics action.
 * </p>
 */
@Generated("software.amazon.awssdk:codegen")
public class ListTopicsResponse extends SNSResponse implements ToCopyableBuilder<ListTopicsResponse.Builder, ListTopicsResponse> {
    private final List<Topic> topics;

    private final String nextToken;

    private ListTopicsResponse(BuilderImpl builder) {
        super(builder);
        this.topics = builder.topics;
        this.nextToken = builder.nextToken;
    }

    /**
     * <p>
     * A list of topic ARNs.
     * </p>
     * <p>
     * Attempts to modify the collection returned by this method will result in an UnsupportedOperationException.
     * </p>
     * 
     * @return A list of topic ARNs.
     */
    public List<Topic> topics() {
        return topics;
    }

    /**
     * <p>
     * Token to pass along to the next <code>ListTopics</code> request. This element is returned if there are additional
     * topics to retrieve.
     * </p>
     * 
     * @return Token to pass along to the next <code>ListTopics</code> request. This element is returned if there are
     *         additional topics to retrieve.
     */
    public String nextToken() {
        return nextToken;
    }

    @Override
    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    @Override
    public int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + Objects.hashCode(topics());
        hashCode = 31 * hashCode + Objects.hashCode(nextToken());
        return hashCode;
    }

    @Override
    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof ListTopicsResponse)) {
            return false;
        }
        ListTopicsResponse other = (ListTopicsResponse) obj;
        return Objects.equals(topics(), other.topics()) && Objects.equals(nextToken(), other.nextToken());
    }

    @Override
    public String toString() {
        return ToString.builder("ListTopicsResponse").add("Topics", topics()).add("NextToken", nextToken()).build();
    }

    public <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
        case "Topics":
            return Optional.of(clazz.cast(topics()));
        case "NextToken":
            return Optional.of(clazz.cast(nextToken()));
        default:
            return Optional.empty();
        }
    }

    public interface Builder extends SNSResponse.Builder, CopyableBuilder<Builder, ListTopicsResponse> {
        /**
         * <p>
         * A list of topic ARNs.
         * </p>
         * 
         * @param topics
         *        A list of topic ARNs.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder topics(Collection<Topic> topics);

        /**
         * <p>
         * A list of topic ARNs.
         * </p>
         * 
         * @param topics
         *        A list of topic ARNs.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder topics(Topic... topics);

        /**
         * <p>
         * Token to pass along to the next <code>ListTopics</code> request. This element is returned if there are
         * additional topics to retrieve.
         * </p>
         * 
         * @param nextToken
         *        Token to pass along to the next <code>ListTopics</code> request. This element is returned if there are
         *        additional topics to retrieve.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder nextToken(String nextToken);
    }

    static final class BuilderImpl extends SNSResponse.BuilderImpl implements Builder {
        private List<Topic> topics;

        private String nextToken;

        private BuilderImpl() {
        }

        private BuilderImpl(ListTopicsResponse model) {
            topics(model.topics);
            nextToken(model.nextToken);
        }

        public final Collection<Topic.Builder> getTopics() {
            return topics != null ? topics.stream().map(Topic::toBuilder).collect(Collectors.toList()) : null;
        }

        @Override
        public final Builder topics(Collection<Topic> topics) {
            this.topics = TopicsListCopier.copy(topics);
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder topics(Topic... topics) {
            topics(Arrays.asList(topics));
            return this;
        }

        public final void setTopics(Collection<Topic.BuilderImpl> topics) {
            this.topics = TopicsListCopier.copyFromBuilder(topics);
        }

        public final String getNextToken() {
            return nextToken;
        }

        @Override
        public final Builder nextToken(String nextToken) {
            this.nextToken = nextToken;
            return this;
        }

        public final void setNextToken(String nextToken) {
            this.nextToken = nextToken;
        }

        @Override
        public ListTopicsResponse build() {
            return new ListTopicsResponse(this);
        }
    }
}
