/*
 * Copyright 2013-2018 Amazon.com, Inc. or its affiliates. All Rights Reserved.
 * 
 * Licensed under the Apache License, Version 2.0 (the "License"). You may not use this file except in compliance with
 * the License. A copy of the License is located at
 * 
 * http://aws.amazon.com/apache2.0
 * 
 * or in the "license" file accompanying this file. This file is distributed on an "AS IS" BASIS, WITHOUT WARRANTIES OR
 * CONDITIONS OF ANY KIND, either express or implied. See the License for the specific language governing permissions
 * and limitations under the License.
 */

package software.amazon.awssdk.services.sns.transform;

import java.util.ArrayList;

import javax.xml.stream.events.XMLEvent;
import javax.annotation.Generated;

import software.amazon.awssdk.services.sns.model.*;
import software.amazon.awssdk.core.runtime.transform.Unmarshaller;

import software.amazon.awssdk.core.runtime.transform.StaxUnmarshallerContext;
import software.amazon.awssdk.core.runtime.transform.SimpleTypeStaxUnmarshallers.*;

/**
 * ListSubscriptionsResponse StAX Unmarshaller
 */

@Generated("software.amazon.awssdk:aws-java-sdk-code-generator")
public class ListSubscriptionsResponseUnmarshaller implements Unmarshaller<ListSubscriptionsResponse, StaxUnmarshallerContext> {

    public ListSubscriptionsResponse unmarshall(StaxUnmarshallerContext context) throws Exception {
        ListSubscriptionsResponse.Builder listSubscriptionsResponse = ListSubscriptionsResponse.builder();
        int originalDepth = context.getCurrentDepth();
        int targetDepth = originalDepth + 1;

        if (context.isStartOfDocument())
            targetDepth += 2;

        java.util.List<Subscription> subscriptions = null;

        while (true) {
            XMLEvent xmlEvent = context.nextEvent();
            if (xmlEvent.isEndDocument()) {
                listSubscriptionsResponse.subscriptions(subscriptions);
                break;
            }

            if (xmlEvent.isAttribute() || xmlEvent.isStartElement()) {

                if (context.testExpression("Subscriptions", targetDepth)) {
                    subscriptions = new ArrayList<Subscription>();
                    continue;
                }

                if (context.testExpression("Subscriptions/member", targetDepth)) {
                    subscriptions.add(SubscriptionUnmarshaller.getInstance().unmarshall(context));
                    continue;
                }

                if (context.testExpression("NextToken", targetDepth)) {
                    listSubscriptionsResponse.nextToken(StringUnmarshaller.getInstance().unmarshall(context));
                    continue;
                }
            } else if (xmlEvent.isEndElement()) {
                if (context.getCurrentDepth() < originalDepth) {
                    listSubscriptionsResponse.subscriptions(subscriptions);
                    break;
                }
            }
        }
        return listSubscriptionsResponse.build();
    }

    private static final ListSubscriptionsResponseUnmarshaller INSTANCE = new ListSubscriptionsResponseUnmarshaller();

    public static ListSubscriptionsResponseUnmarshaller getInstance() {
        return INSTANCE;
    }
}
