/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.sns.model;

import java.util.Arrays;
import java.util.Collection;
import java.util.List;
import java.util.Objects;
import java.util.Optional;
import java.util.stream.Collectors;
import software.amazon.awssdk.services.sns.model.Endpoint;
import software.amazon.awssdk.services.sns.model.ListOfEndpointsCopier;
import software.amazon.awssdk.services.sns.model.SNSResponse;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

public class ListEndpointsByPlatformApplicationResponse
extends SNSResponse
implements ToCopyableBuilder<Builder, ListEndpointsByPlatformApplicationResponse> {
    private final List<Endpoint> endpoints;
    private final String nextToken;

    private ListEndpointsByPlatformApplicationResponse(BuilderImpl builder) {
        super(builder);
        this.endpoints = builder.endpoints;
        this.nextToken = builder.nextToken;
    }

    public List<Endpoint> endpoints() {
        return this.endpoints;
    }

    public String nextToken() {
        return this.nextToken;
    }

    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    public int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + Objects.hashCode(this.endpoints());
        hashCode = 31 * hashCode + Objects.hashCode(this.nextToken());
        return hashCode;
    }

    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof ListEndpointsByPlatformApplicationResponse)) {
            return false;
        }
        ListEndpointsByPlatformApplicationResponse other = (ListEndpointsByPlatformApplicationResponse)((Object)obj);
        return Objects.equals(this.endpoints(), other.endpoints()) && Objects.equals(this.nextToken(), other.nextToken());
    }

    public String toString() {
        return ToString.builder((String)"ListEndpointsByPlatformApplicationResponse").add("Endpoints", this.endpoints()).add("NextToken", (Object)this.nextToken()).build();
    }

    public <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
            case "Endpoints": {
                return Optional.of(clazz.cast(this.endpoints()));
            }
            case "NextToken": {
                return Optional.of(clazz.cast(this.nextToken()));
            }
        }
        return Optional.empty();
    }

    static final class BuilderImpl
    extends SNSResponse.BuilderImpl
    implements Builder {
        private List<Endpoint> endpoints;
        private String nextToken;

        private BuilderImpl() {
        }

        private BuilderImpl(ListEndpointsByPlatformApplicationResponse model) {
            this.endpoints(model.endpoints);
            this.nextToken(model.nextToken);
        }

        public final Collection<Endpoint.Builder> getEndpoints() {
            return this.endpoints != null ? (Collection)this.endpoints.stream().map(Endpoint::toBuilder).collect(Collectors.toList()) : null;
        }

        @Override
        public final Builder endpoints(Collection<Endpoint> endpoints) {
            this.endpoints = ListOfEndpointsCopier.copy(endpoints);
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder endpoints(Endpoint ... endpoints) {
            this.endpoints(Arrays.asList(endpoints));
            return this;
        }

        public final void setEndpoints(Collection<Endpoint.BuilderImpl> endpoints) {
            this.endpoints = ListOfEndpointsCopier.copyFromBuilder(endpoints);
        }

        public final String getNextToken() {
            return this.nextToken;
        }

        @Override
        public final Builder nextToken(String nextToken) {
            this.nextToken = nextToken;
            return this;
        }

        public final void setNextToken(String nextToken) {
            this.nextToken = nextToken;
        }

        @Override
        public ListEndpointsByPlatformApplicationResponse build() {
            return new ListEndpointsByPlatformApplicationResponse(this);
        }
    }

    public static interface Builder
    extends SNSResponse.Builder,
    CopyableBuilder<Builder, ListEndpointsByPlatformApplicationResponse> {
        public Builder endpoints(Collection<Endpoint> var1);

        public Builder endpoints(Endpoint ... var1);

        public Builder nextToken(String var1);
    }
}

