/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.sns.model;

import java.util.Objects;
import java.util.Optional;
import java.util.function.Consumer;
import software.amazon.awssdk.core.AwsRequestOverrideConfig;
import software.amazon.awssdk.services.sns.model.SNSRequest;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

public class SubscribeRequest
extends SNSRequest
implements ToCopyableBuilder<Builder, SubscribeRequest> {
    private final String topicArn;
    private final String protocol;
    private final String endpoint;

    private SubscribeRequest(BuilderImpl builder) {
        super(builder);
        this.topicArn = builder.topicArn;
        this.protocol = builder.protocol;
        this.endpoint = builder.endpoint;
    }

    public String topicArn() {
        return this.topicArn;
    }

    public String protocol() {
        return this.protocol;
    }

    public String endpoint() {
        return this.endpoint;
    }

    @Override
    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    public int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + Objects.hashCode(this.topicArn());
        hashCode = 31 * hashCode + Objects.hashCode(this.protocol());
        hashCode = 31 * hashCode + Objects.hashCode(this.endpoint());
        return hashCode;
    }

    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof SubscribeRequest)) {
            return false;
        }
        SubscribeRequest other = (SubscribeRequest)((Object)obj);
        return Objects.equals(this.topicArn(), other.topicArn()) && Objects.equals(this.protocol(), other.protocol()) && Objects.equals(this.endpoint(), other.endpoint());
    }

    public String toString() {
        return ToString.builder((String)"SubscribeRequest").add("TopicArn", (Object)this.topicArn()).add("Protocol", (Object)this.protocol()).add("Endpoint", (Object)this.endpoint()).build();
    }

    public <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
            case "TopicArn": {
                return Optional.of(clazz.cast(this.topicArn()));
            }
            case "Protocol": {
                return Optional.of(clazz.cast(this.protocol()));
            }
            case "Endpoint": {
                return Optional.of(clazz.cast(this.endpoint()));
            }
        }
        return Optional.empty();
    }

    static final class BuilderImpl
    extends SNSRequest.BuilderImpl
    implements Builder {
        private String topicArn;
        private String protocol;
        private String endpoint;

        private BuilderImpl() {
        }

        private BuilderImpl(SubscribeRequest model) {
            this.topicArn(model.topicArn);
            this.protocol(model.protocol);
            this.endpoint(model.endpoint);
        }

        public final String getTopicArn() {
            return this.topicArn;
        }

        @Override
        public final Builder topicArn(String topicArn) {
            this.topicArn = topicArn;
            return this;
        }

        public final void setTopicArn(String topicArn) {
            this.topicArn = topicArn;
        }

        public final String getProtocol() {
            return this.protocol;
        }

        @Override
        public final Builder protocol(String protocol) {
            this.protocol = protocol;
            return this;
        }

        public final void setProtocol(String protocol) {
            this.protocol = protocol;
        }

        public final String getEndpoint() {
            return this.endpoint;
        }

        @Override
        public final Builder endpoint(String endpoint) {
            this.endpoint = endpoint;
            return this;
        }

        public final void setEndpoint(String endpoint) {
            this.endpoint = endpoint;
        }

        @Override
        public Builder requestOverrideConfig(AwsRequestOverrideConfig awsRequestOverrideConfig) {
            super.requestOverrideConfig(awsRequestOverrideConfig);
            return this;
        }

        public Builder requestOverrideConfig(Consumer<AwsRequestOverrideConfig.Builder> builderConsumer) {
            super.requestOverrideConfig(builderConsumer);
            return this;
        }

        @Override
        public SubscribeRequest build() {
            return new SubscribeRequest(this);
        }
    }

    public static interface Builder
    extends SNSRequest.Builder,
    CopyableBuilder<Builder, SubscribeRequest> {
        public Builder topicArn(String var1);

        public Builder protocol(String var1);

        public Builder endpoint(String var1);

        public Builder requestOverrideConfig(AwsRequestOverrideConfig var1);
    }
}

