/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.sns.transform;

import software.amazon.awssdk.core.DefaultRequest;
import software.amazon.awssdk.core.Request;
import software.amazon.awssdk.core.exception.SdkClientException;
import software.amazon.awssdk.core.http.HttpMethodName;
import software.amazon.awssdk.core.runtime.transform.Marshaller;
import software.amazon.awssdk.core.util.StringUtils;
import software.amazon.awssdk.services.sns.model.OptInPhoneNumberRequest;

public class OptInPhoneNumberRequestMarshaller
implements Marshaller<Request<OptInPhoneNumberRequest>, OptInPhoneNumberRequest> {
    public Request<OptInPhoneNumberRequest> marshall(OptInPhoneNumberRequest optInPhoneNumberRequest) {
        if (optInPhoneNumberRequest == null) {
            throw new SdkClientException("Invalid argument passed to marshall(...)");
        }
        DefaultRequest request = new DefaultRequest((Object)optInPhoneNumberRequest, "SNSClient");
        request.addParameter("Action", "OptInPhoneNumber");
        request.addParameter("Version", "2010-03-31");
        request.setHttpMethod(HttpMethodName.POST);
        if (optInPhoneNumberRequest.phoneNumber() != null) {
            request.addParameter("phoneNumber", StringUtils.fromString((String)optInPhoneNumberRequest.phoneNumber()));
        }
        return request;
    }
}

